/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.ElementNamesConfigurationBlock;
import org.eclipse.birt.report.designer.ui.preferences.IItemListViewer;
import org.eclipse.birt.report.designer.ui.preferences.ItemContent;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;

public class ItemContentList {
    private Vector contents = new Vector();
    private Set changeListeners = new HashSet();
    private ElementNamesConfigurationBlock block;
    private OptionsConfigurationBlock.Key[] keies;

    public ItemContentList(ElementNamesConfigurationBlock block, OptionsConfigurationBlock.Key[] keies) {
        this.block = block;
        this.keies = keies;
        this.initData();
    }

    public void clearList() {
        this.contents.clear();
    }

    private void initData() {
        String[] defaultNames = ReportPlugin.convert(this.block.getValue(this.keies[0]));
        String[] customNames = ReportPlugin.convert(this.block.getValue(this.keies[1]));
        String[] descriptions = ReportPlugin.convert(this.block.getValue(this.keies[2]));
        String[] newElement = ReportPlugin.getDefault().getDefaultDefaultNamePreference();
        if (defaultNames.length != customNames.length || defaultNames.length != descriptions.length || customNames.length != descriptions.length) {
            defaultNames = ReportPlugin.getDefault().getDefaultDefaultNamePreference();
            customNames = ReportPlugin.getDefault().getDefaultCustomNamePreference();
            descriptions = ReportPlugin.getDefault().getDefaultDescriptionPreference();
        }
        int i = 0;
        while (i < defaultNames.length) {
            IElementDefn elementDefn = DEUtil.getElementDefn((String)defaultNames[i]);
            ItemContent content = new ItemContent(customNames[i]);
            content.setDefaultName(defaultNames[i]);
            content.setDisplayName(elementDefn != null ? DEUtil.getElementDefn((String)defaultNames[i]).getDisplayName() : defaultNames[i]);
            content.setDescription(descriptions[i]);
            this.contents.add(content);
            ++i;
        }
        if (newElement.length != defaultNames.length) {
            this.addNewElementName(defaultNames, newElement);
        }
    }

    private void addNewElementName(String[] oldElement, String[] newElement) {
        int oldSize = oldElement.length;
        int newSize = newElement.length;
        int i = 0;
        while (i < newSize) {
            boolean find = false;
            int j = oldSize - 1;
            while (j >= 0) {
                if (newElement[i].equals(oldElement[j])) {
                    find = true;
                    break;
                }
                --j;
            }
            if (!find) {
                ItemContent content = new ItemContent("");
                content.setDefaultName(newElement[i]);
                content.setDescription("");
                this.contents.add(content);
            }
            ++i;
        }
    }

    public Vector getContents() {
        return this.contents;
    }

    public boolean setContent(int i, ItemContent itemContent) {
        if (i < 0 || i >= this.contents.size()) {
            return false;
        }
        ((ItemContent)this.contents.get(i)).setDefaultName(itemContent.getDefaultName());
        ((ItemContent)this.contents.get(i)).setCustomName(itemContent.getCustomName());
        ((ItemContent)this.contents.get(i)).setDescription(itemContent.getDescription());
        this.updateKeyValues();
        return true;
    }

    public void addContent() {
        ItemContent content = new ItemContent("New Custom Name");
        this.contents.add(this.contents.size(), content);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IItemListViewer)iterator.next()).addContent(content);
        }
        this.updateKeyValues();
    }

    public void addContent(ItemContent content) {
        this.contents.add(this.contents.size(), content);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IItemListViewer)iterator.next()).addContent(content);
        }
        this.updateKeyValues();
    }

    public void removeContent(ItemContent content) {
        this.contents.remove(content);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IItemListViewer)iterator.next()).removeContent(content);
        }
        this.updateKeyValues();
    }

    public void contentChanged(ItemContent content) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IItemListViewer)iterator.next()).updateContent(content);
        }
        this.updateKeyValues();
    }

    public void removeChangeListener(IItemListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IItemListViewer viewer) {
        this.changeListeners.add(viewer);
    }

    private void updateKeyValues() {
        StringBuilder defaultNamePreference = new StringBuilder();
        StringBuilder customNamePreference = new StringBuilder();
        StringBuilder descriptionPreference = new StringBuilder();
        Vector contents = this.getContents();
        int i = 0;
        while (i < contents.size()) {
            ItemContent content = (ItemContent)contents.get(i);
            defaultNamePreference.append(content.getDefaultName());
            defaultNamePreference.append(";");
            customNamePreference.append(content.getCustomName());
            customNamePreference.append(";");
            descriptionPreference.append(content.getDescription());
            descriptionPreference.append(";");
            ++i;
        }
        this.block.setValue(this.keies[0], defaultNamePreference.toString());
        this.block.setValue(this.keies[1], customNamePreference.toString());
        this.block.setValue(this.keies[2], descriptionPreference.toString());
    }
}

