/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.parameters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.ui.parameters.AbstractParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.CascadingParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.CheckBoxParameter;
import org.eclipse.birt.report.designer.ui.parameters.ComboBoxParameter;
import org.eclipse.birt.report.designer.ui.parameters.IParameter;
import org.eclipse.birt.report.designer.ui.parameters.IParameterAdapter;
import org.eclipse.birt.report.designer.ui.parameters.IParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.ListBoxParameter;
import org.eclipse.birt.report.designer.ui.parameters.ParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.RadioParameter;
import org.eclipse.birt.report.designer.ui.parameters.ScalarParameter;
import org.eclipse.birt.report.designer.ui.parameters.StaticTextParameter;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.core.runtime.Platform;

public class ParameterFactory {
    private static final String RADIO_BUTTON = "radio-button";
    private static final String TEXT_BOX = "text-box";
    private static final String LIST_BOX = "list-box";
    private static final String CHECK_BOX = "check-box";
    private static final String AUTOSUGGEST_BOX = "auto-suggest";
    private IGetParameterDefinitionTask task;

    public ParameterFactory(IGetParameterDefinitionTask task) {
        this.task = task;
    }

    public List getRootChildren() {
        return this.getRootChildren(true);
    }

    public List getRootChildren(boolean includeHidden) {
        IReportRunnable runnable = this.task.getReportRunnable();
        if (runnable == null) {
            return null;
        }
        DesignElementHandle designHandle = runnable.getDesignHandle();
        if (designHandle == null) {
            return null;
        }
        assert (designHandle.getRoot() != null);
        List parameters = designHandle.getRoot().getParameters().getContents();
        Iterator iterator = parameters.iterator();
        ArrayList<Object> childrenList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Object adapter;
            DesignElementHandle handle = (DesignElementHandle)iterator.next();
            if (handle instanceof ScalarParameterHandle) {
                ScalarParameterHandle temp = (ScalarParameterHandle)handle;
                if (!includeHidden && temp.isHidden()) continue;
                ScalarParameter param = this.createScalarParameter(temp);
                childrenList.add(param);
                continue;
            }
            if (handle instanceof ParameterGroupHandle) {
                ParameterGroupHandle groupHandle = (ParameterGroupHandle)handle;
                AbstractParameterGroup group = handle instanceof CascadingParameterGroupHandle ? new CascadingParameterGroup(groupHandle) : new ParameterGroup(groupHandle);
                childrenList.add(group);
                this.createParameterGroup(group, groupHandle, includeHidden);
                continue;
            }
            if (!(handle instanceof AbstractScalarParameterHandle) || (adapter = Platform.getAdapterManager().getAdapter((Object)handle, IParameterAdapter.class)) == null) continue;
            ((IParameterAdapter)adapter).setHandle((AbstractScalarParameterHandle)handle);
            ((IParameterAdapter)adapter).setParameterDefinitionTask(this.task);
            childrenList.add(adapter);
        }
        return childrenList;
    }

    private void createParameterGroup(IParameterGroup group, ParameterGroupHandle groupHandle, boolean includeHidden) {
        assert (group != null);
        assert (groupHandle != null);
        SlotHandle slotHandle = groupHandle.getSlot(0);
        for (ParameterHandle handle : slotHandle) {
            if (!includeHidden && handle.isHidden()) continue;
            this.createParameter(group, handle);
        }
    }

    private IParameter createParameter(IParameterGroup parentGroup, ParameterHandle paramHandle) {
        assert (parentGroup != null);
        assert (paramHandle != null);
        ScalarParameter param = null;
        if (paramHandle instanceof ScalarParameterHandle) {
            param = this.createScalarParameter((ScalarParameterHandle)paramHandle);
        }
        if (param != null) {
            parentGroup.addParameter(param);
        }
        return param;
    }

    private ScalarParameter createScalarParameter(ScalarParameterHandle paramHandle) {
        ScalarParameter param = null;
        String controlType = paramHandle.getControlType();
        if (controlType.equals(LIST_BOX)) {
            boolean mustMatch = paramHandle.isMustMatch();
            param = mustMatch ? new ListBoxParameter(paramHandle, (IEngineTask)this.task) : new ComboBoxParameter(paramHandle, (IEngineTask)this.task);
        } else if (controlType.equals(TEXT_BOX) || controlType.equals(AUTOSUGGEST_BOX)) {
            param = new StaticTextParameter(paramHandle, (IEngineTask)this.task);
        } else if (controlType.equals(RADIO_BUTTON)) {
            param = new RadioParameter(paramHandle, (IEngineTask)this.task);
        } else if (controlType.equals(CHECK_BOX)) {
            param = new CheckBoxParameter(paramHandle, (IEngineTask)this.task);
        }
        return param;
    }
}

