/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Random;

public class SocketUtil {
    private static final Random RANDOM = new Random();

    public static int findUnusedLocalPort() {
        InetAddress address;
        try {
            byte[] byArray = new byte[4];
            byArray[0] = 127;
            byArray[3] = 1;
            address = InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException uhe) {
            return -1;
        }
        int port = SocketUtil.findUnusedPort(address, 49152, 65535);
        if (port == -1) {
            port = SocketUtil.findFreePort();
        }
        return port;
    }

    private static int findUnusedPort(InetAddress address, int from, int to) {
        int i = 0;
        while (i < 12) {
            ServerSocket ss = null;
            int port = SocketUtil.getRandomPort(from, to);
            try {
                ss = new ServerSocket();
                InetSocketAddress sa = new InetSocketAddress(address, port);
                ss.bind(sa);
                int n = ss.getLocalPort();
                return n;
            }
            catch (IOException iOException) {
            }
            finally {
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++i;
        }
        return -1;
    }

    private static int getRandomPort(int low, int high) {
        return (int)(RANDOM.nextFloat() * (float)(high - low)) + low;
    }

    private static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }
}

