/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.bindings.StandardDeployer;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.osgi.boot.AbstractOSGiApp;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.osgi.boot.utils.EventSender;

public class OSGiDeployer
extends StandardDeployer {
    private ServerInstanceWrapper _server;

    public OSGiDeployer(ServerInstanceWrapper server) {
        this._server = server;
    }

    public void processBinding(Node node, App app) throws Exception {
        if (!(app instanceof AbstractOSGiApp)) {
            this.doProcessBinding(node, app);
        } else {
            EventSender.getInstance().send("org/osgi/service/web/DEPLOYING", ((AbstractOSGiApp)app).getBundle(), app.getContextPath());
            try {
                this.doProcessBinding(node, app);
                ((AbstractOSGiApp)app).registerAsOSGiService();
                EventSender.getInstance().send("org/osgi/service/web/DEPLOYED", ((AbstractOSGiApp)app).getBundle(), app.getContextPath());
            }
            catch (Exception e) {
                EventSender.getInstance().send("org/osgi/service/web/FAILED", ((AbstractOSGiApp)app).getBundle(), app.getContextPath());
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessBinding(Node node, App app) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this._server.getParentClassLoaderForWebapps());
        try {
            super.processBinding(node, app);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

