/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures;

import org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures.ColumnConnectionRouter;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnConnection
extends PolylineConnection
implements AnchorListener {
    protected Label joinTypeIcon;
    protected int theJoinType;
    protected static Image equalJoin;
    protected static Image leftArrowJoin;
    protected static Image rightArrowJoin;
    protected static Image expressionJoin;
    private PolygonDecoration joinDirection = null;

    public ColumnConnection() {
        this.setOutline(true);
        this.joinTypeIcon = new Label("");
        this.joinTypeIcon.setLabelAlignment(1);
        this.joinTypeIcon.setTextPlacement(20);
        this.joinTypeIcon.setIcon(UIHelper.getImage("icons/obj16/equal.gif"));
        this.add((IFigure)this.joinTypeIcon);
        this.setConnectionRouter(null);
        this.joinDirection = new PolygonDecoration();
        this.joinDirection.setForegroundColor(ColorConstants.darkBlue);
        this.setTargetDecoration((RotatableDecoration)this.joinDirection);
    }

    public PolygonDecoration getJoinDirection() {
        return this.joinDirection;
    }

    public void setJoinDirection(PolygonDecoration joinDirection) {
        this.joinDirection = joinDirection;
    }

    public int getJoinType() {
        return this.theJoinType;
    }

    public void setConnectionRouter(ConnectionRouter cr) {
        if (cr == null) {
            super.setConnectionRouter((ConnectionRouter)new ColumnConnectionRouter());
        } else {
            super.setConnectionRouter(cr);
        }
    }

    protected void outlineShape(Graphics g) {
        g.setForegroundColor(ColorConstants.blue);
        this.setForegroundColor(this.getBackgroundColor());
        super.outlineShape(g);
    }

    public org.eclipse.draw2d.geometry.Rectangle getBounds() {
        if (this.bounds == null) {
            super.getBounds();
            if (this.joinTypeIcon != null) {
                this.bounds.union(this.joinTypeIcon.getBounds());
            }
        }
        return this.bounds;
    }

    public void validate() {
        if (!this.isValid()) {
            this.erase();
            if (this.getSourceAnchor() != null && this.getTargetAnchor() != null) {
                Point center = this.getTargetAnchor().getReferencePoint();
                this.setStart(this.getSourceAnchor().getLocation(center));
                center = this.getSourceAnchor().getReferencePoint();
                this.setEnd(this.getTargetAnchor().getLocation(center));
            }
            super.validate();
            if (this.getSourceAnchor().getOwner() != null && this.getTargetAnchor().getOwner() != null) {
                this.validateJoinIcon();
                this.repaint();
            }
        }
    }

    private void validateJoinIcon() {
        PointList points = super.getPoints();
        Point leftPoint = points.getPoint(1);
        Point rightPoint = points.getPoint(2);
        int minX = Math.min(leftPoint.x, rightPoint.x);
        int maxX = Math.max(leftPoint.x, rightPoint.x);
        int minY = Math.min(leftPoint.y, rightPoint.y);
        int maxY = Math.max(leftPoint.y, rightPoint.y);
        Rectangle imageRect = this.joinTypeIcon.getIcon().getBounds();
        int x = minX + (maxX - minX) / 2 - imageRect.width / 2;
        int y = minY + (maxY - minY) / 2 - imageRect.height / 2;
        Point newPoint = new Point(x, y);
        this.joinTypeIcon.setLocation(newPoint);
        this.joinTypeIcon.setBounds(this.joinTypeIcon.getIconBounds());
        this.bounds = null;
    }
}

