/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.querymodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.oda.pojo.querymodel.IColumnsMapping;
import org.eclipse.birt.data.oda.pojo.querymodel.IMappingSource;
import org.eclipse.birt.data.oda.pojo.querymodel.ReferenceNode;
import org.eclipse.birt.data.oda.pojo.querymodel.RelayReferenceNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClassColumnMappings
implements IColumnsMapping {
    private IMappingSource source;
    private List<IColumnsMapping> mappings = new ArrayList<IColumnsMapping>();

    public ClassColumnMappings(IMappingSource source) {
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        this.source = source;
    }

    public void addColumnsMapping(IColumnsMapping mapping) {
        if (mapping == null) {
            throw new NullPointerException("mapping is null");
        }
        this.mappings.add(mapping);
    }

    @Override
    public IMappingSource getSource() {
        return this.source;
    }

    public IColumnsMapping[] getColumnsMappings() {
        return this.mappings.toArray(new IColumnsMapping[0]);
    }

    @Override
    public ReferenceNode createReferenceNode(RelayReferenceNode parent) {
        RelayReferenceNode result = new RelayReferenceNode(parent, this.getSource());
        for (IColumnsMapping mapping : this.mappings) {
            mapping.createReferenceNode(result);
        }
        return result;
    }

    @Override
    public Element createElement(Document doc) {
        Element newElement = doc.createElement("ClassColumnMappings");
        IColumnsMapping[] iColumnsMappingArray = this.getColumnsMappings();
        int n = iColumnsMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumnsMapping cm = iColumnsMappingArray[n2];
            newElement.appendChild(cm.createElement(doc));
            ++n2;
        }
        newElement.appendChild(this.getSource().createElement(doc));
        return newElement;
    }
}

