/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.common.HelperVisitor;
import org.eclipse.jdt.internal.common.ReferenceHolder;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopOperation;
import org.eclipse.jdt.internal.corext.fix.UseIteratorToForLoopFixCore;
import org.eclipse.jdt.internal.corext.fix.helper.AbstractTool;
import org.eclipse.jdt.internal.corext.fix.helper.WhileLoopToChangeHit;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.text.edits.TextEditGroup;

public class WhileToForEach
extends AbstractTool<WhileLoopToChangeHit> {
    @Override
    public void find(UseIteratorToForLoopFixCore fixcore, CompilationUnit compilationUnit, Set<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations, Set<ASTNode> nodesprocessed, boolean createForOnlyIfVarUsed) {
        ReferenceHolder dataholder = new ReferenceHolder();
        LinkedHashMap operationsMap = new LinkedHashMap();
        WhileLoopToChangeHit invalidHit = new WhileLoopToChangeHit(true);
        HelperVisitor.callVariableDeclarationStatementVisitor(Iterator.class, (ASTNode)compilationUnit, dataholder, nodesprocessed, (init_iterator, holder_a) -> {
            List<Object> computeVarName = WhileToForEach.computeVarName(init_iterator);
            MethodInvocation iteratorCall = WhileToForEach.computeIteratorCall(init_iterator);
            if (computeVarName != null && iteratorCall != null) {
                Statement iteratorAssignment = (Statement)ASTNodes.getFirstAncestorOrNull((ASTNode)iteratorCall, Statement.class, new Class[0]);
                HelperVisitor.callWhileStatementVisitor(init_iterator.getParent(), dataholder, nodesprocessed, (whilestatement, holder) -> {
                    String name = WhileToForEach.computeNextVarname(whilestatement);
                    if (computeVarName.get(0).equals(name) && iteratorCall.getStartPosition() < whilestatement.getStartPosition()) {
                        HelperVisitor helperVisitor = holder.getHelperVisitor();
                        if (helperVisitor.nodesprocessed.size() > 0) {
                            boolean invalidated = false;
                            for (ASTNode astNode : helperVisitor.nodesprocessed) {
                                WhileLoopToChangeHit oldHit = (WhileLoopToChangeHit)operationsMap.get(astNode);
                                if (oldHit == null || oldHit.iteratorDeclaration != init_iterator) continue;
                                operationsMap.put(astNode, invalidHit);
                                invalidated = true;
                            }
                            if (invalidated) {
                                return true;
                            }
                        }
                        WhileLoopToChangeHit hit = holder.computeIfAbsent(whilestatement, k -> new WhileLoopToChangeHit());
                        if (!createForOnlyIfVarUsed) {
                            hit.iteratorDeclaration = init_iterator;
                            hit.iteratorCall = iteratorAssignment;
                            hit.iteratorName = name;
                            if (computeVarName.size() == 1) {
                                hit.self = true;
                            } else {
                                hit.collectionExpression = (Expression)computeVarName.get(1);
                            }
                            hit.whileStatement = whilestatement;
                            hit.loopVarName = hit.self ? ConvertLoopOperation.modifybasename("i") : (hit.collectionExpression instanceof SimpleName ? ConvertLoopOperation.modifybasename(((SimpleName)hit.collectionExpression).getIdentifier()) : ConvertLoopOperation.modifybasename("element"));
                            operationsMap.put(whilestatement, hit);
                        }
                        HelperVisitor.callMethodInvocationVisitor((ASTNode)whilestatement.getBody(), dataholder, nodesprocessed, (mi, holder2) -> {
                            SimpleName sn = ASTNodes.as(mi.getExpression(), SimpleName.class);
                            if (sn != null) {
                                String identifier = sn.getIdentifier();
                                if (!name.equals(identifier)) {
                                    return true;
                                }
                                String method = mi.getName().getFullyQualifiedName();
                                WhileLoopToChangeHit previousHit = (WhileLoopToChangeHit)operationsMap.get(whilestatement);
                                if (previousHit != null && (previousHit == invalidHit || previousHit.nextFound || !method.equals("next"))) {
                                    operationsMap.put(whilestatement, invalidHit);
                                    return true;
                                }
                                if (ASTNodes.getFirstAncestorOrNull((ASTNode)mi, ExpressionStatement.class, new Class[0]) != null && createForOnlyIfVarUsed) {
                                    operationsMap.put(whilestatement, invalidHit);
                                    return true;
                                }
                                whileLoopToChangeHit2.nextFound = true;
                                whileLoopToChangeHit2.iteratorName = name;
                                whileLoopToChangeHit2.iteratorDeclaration = init_iterator;
                                whileLoopToChangeHit2.iteratorCall = iteratorAssignment;
                                whileLoopToChangeHit2.whileStatement = whilestatement;
                                whileLoopToChangeHit2.loopVarDeclaration = mi;
                                if (computeVarName.size() == 1) {
                                    whileLoopToChangeHit2.self = true;
                                } else {
                                    whileLoopToChangeHit2.collectionExpression = (Expression)computeVarName.get(1);
                                }
                                VariableDeclarationStatement typedAncestor = ASTNodes.getTypedAncestor((ASTNode)mi, VariableDeclarationStatement.class);
                                if (typedAncestor != null) {
                                    ITypeBinding iteratorTypeArgument = WhileToForEach.computeTypeArgument(init_iterator);
                                    ITypeBinding varTypeBinding = typedAncestor.getType().resolveBinding();
                                    if (varTypeBinding == null || iteratorTypeArgument == null || !varTypeBinding.isEqualTo((IBinding)iteratorTypeArgument) && !Bindings.isSuperType(varTypeBinding, iteratorTypeArgument)) {
                                        operationsMap.put(whilestatement, invalidHit);
                                        return true;
                                    }
                                    VariableDeclarationFragment vdf = (VariableDeclarationFragment)typedAncestor.fragments().get(0);
                                    whileLoopToChangeHit2.loopVarName = vdf.getName().getIdentifier();
                                } else {
                                    whileLoopToChangeHit2.loopVarName = whileLoopToChangeHit2.self ? ConvertLoopOperation.modifybasename("i") : (whileLoopToChangeHit2.collectionExpression instanceof SimpleName ? ConvertLoopOperation.modifybasename(((SimpleName)whileLoopToChangeHit2.collectionExpression).getIdentifier()) : ConvertLoopOperation.modifybasename("element"));
                                    whileLoopToChangeHit2.nextWithoutVariableDeclaration = true;
                                }
                                operationsMap.put(whilestatement, hit);
                                helperVisitor.nodesprocessed.add((ASTNode)whilestatement);
                                holder2.remove(whilestatement);
                                return true;
                            }
                            return true;
                        });
                    }
                    return true;
                });
            }
            return true;
        });
        for (WhileLoopToChangeHit hit : operationsMap.values()) {
            if (hit.isInvalid || !WhileToForEach.validate(hit)) continue;
            operations.add(fixcore.rewrite(hit));
        }
    }

    private static boolean validate(WhileLoopToChangeHit hit) {
        ASTNode iterDeclarationParent = hit.iteratorDeclaration.getParent();
        List descs = iterDeclarationParent.structuralPropertiesForType();
        boolean hasStatements = false;
        for (StructuralPropertyDescriptor desc : descs) {
            if (!desc.getId().equals("statements")) continue;
            hasStatements = true;
            break;
        }
        if (!hasStatements) {
            return false;
        }
        ReferenceHolder dataholder = new ReferenceHolder();
        HashSet<ASTNode> nodesprocessed = new HashSet<ASTNode>();
        VariableDeclarationFragment iterDeclFragment = (VariableDeclarationFragment)hit.iteratorDeclaration.fragments().get(0);
        IVariableBinding iterBinding = iterDeclFragment.resolveBinding();
        if (iterBinding == null) {
            return false;
        }
        HelperVisitor.callMethodInvocationVisitor(iterDeclarationParent, dataholder, nodesprocessed, (mi, holder2) -> {
            Statement stmt;
            Expression leftSide;
            SimpleName assignedVar;
            ASTNode assignment;
            SimpleName sn = ASTNodes.as(mi.getExpression(), SimpleName.class);
            if (sn != null && sn.getIdentifier().equals(whileLoopToChangeHit.iteratorName)) {
                if (mi.getStartPosition() < whileLoopToChangeHit.whileStatement.getStartPosition()) {
                    whileLoopToChangeHit.isInvalid = true;
                    return false;
                }
            } else if (mi.getName().getIdentifier().equals("iterator") && (assignment = ASTNodes.getFirstAncestorOrNull((ASTNode)mi, Assignment.class, new Class[0])) instanceof Assignment && (assignedVar = ASTNodes.as(leftSide = ((Assignment)assignment).getLeftHandSide(), SimpleName.class)) != null && assignedVar.getIdentifier().equals(whileLoopToChangeHit.iteratorName) && ((stmt = (Statement)ASTNodes.getFirstAncestorOrNull(assignment, Statement.class, new Class[0])) == null || stmt.getParent() != whileLoopToChangeHit.whileStatement.getParent())) {
                whileLoopToChangeHit.isInvalid = true;
                return false;
            }
            return true;
        });
        return !hit.isInvalid;
    }

    private static String computeNextVarname(WhileStatement whilestatement) {
        SimpleName variable;
        MethodInvocation mi;
        String name = null;
        Expression exp = whilestatement.getExpression();
        if (exp instanceof MethodInvocation && (mi = (MethodInvocation)exp).getName().getIdentifier().equals("hasNext") && (variable = ASTNodes.as(mi.getExpression(), SimpleName.class)) != null) {
            IBinding resolveBinding = variable.resolveBinding();
            name = resolveBinding.getName();
        }
        return name;
    }

    private static List<Object> computeVarName(VariableDeclarationStatement node_a) {
        MethodInvocation mi;
        ArrayList<Object> objectList = new ArrayList<Object>();
        if (node_a.fragments().size() > 1) {
            return null;
        }
        VariableDeclarationFragment bli = (VariableDeclarationFragment)node_a.fragments().get(0);
        objectList.add(bli.getName().getIdentifier());
        Expression exp = bli.getInitializer();
        if (exp == null) {
            exp = WhileToForEach.computeIteratorCall(node_a);
        }
        if ((mi = ASTNodes.as(exp, MethodInvocation.class)) == null || !mi.getName().getIdentifier().equals("iterator")) {
            return null;
        }
        ITypeBinding iterableAncestor = null;
        IMethodBinding miBinding = mi.resolveMethodBinding();
        if (miBinding != null) {
            iterableAncestor = ASTNodes.findImplementedType(miBinding.getDeclaringClass(), Iterable.class.getCanonicalName());
        }
        if (iterableAncestor == null || iterableAncestor.isRawType()) {
            return null;
        }
        Expression sn = ASTNodes.as(mi.getExpression(), Expression.class);
        if (sn != null) {
            objectList.add(sn);
        }
        return objectList;
    }

    private static MethodInvocation computeIteratorCall(VariableDeclarationStatement node_a) {
        VariableDeclarationFragment bli = (VariableDeclarationFragment)node_a.fragments().get(0);
        Expression exp = bli.getInitializer();
        IBinding bliBinding = bli.getName().resolveBinding();
        if (bliBinding == null) {
            return null;
        }
        ASTNode parent = node_a.getParent();
        ReferenceHolder dataholder = new ReferenceHolder();
        if (exp != null && exp instanceof MethodInvocation) {
            dataholder.put(node_a, exp);
        }
        HashSet<ASTNode> nodesprocessed = new HashSet<ASTNode>();
        Object Invalid = new Object();
        try {
            HelperVisitor.callAssignmentVisitor(parent, dataholder, nodesprocessed, (assignment, holder2) -> {
                IBinding binding;
                Expression leftSide;
                SimpleName sn;
                if (assignment.getStartPosition() > node_a.getStartPosition() && (sn = ASTNodes.as(leftSide = assignment.getLeftHandSide(), SimpleName.class)) != null && (binding = sn.resolveBinding()).isEqualTo(bliBinding)) {
                    MethodInvocation mi = ASTNodes.as(assignment.getRightHandSide(), MethodInvocation.class);
                    if (mi == null || !mi.getName().getIdentifier().equals("iterator")) {
                        dataholder.put(node_a, (Expression)Invalid);
                        throw new AbortSearchException();
                    }
                    if (dataholder.get(node_a) != null) {
                        dataholder.put(node_a, (Expression)Invalid);
                        throw new AbortSearchException();
                    }
                    dataholder.put(node_a, (Expression)mi);
                }
                return true;
            });
        }
        catch (AbortSearchException abortSearchException) {}
        Object holderObject = dataholder.get(node_a);
        if (holderObject == Invalid || holderObject == null) {
            return null;
        }
        return (MethodInvocation)holderObject;
    }

    private static ITypeBinding computeTypeArgument(VariableDeclarationStatement node_a) {
        MethodInvocation mi;
        VariableDeclarationFragment bli = (VariableDeclarationFragment)node_a.fragments().get(0);
        Expression exp = bli.getInitializer();
        if (exp == null) {
            IBinding bliBinding = bli.getName().resolveBinding();
            if (bliBinding == null) {
                return null;
            }
            ASTNode parent = node_a.getParent();
            ReferenceHolder dataholder = new ReferenceHolder();
            HashSet<ASTNode> nodesprocessed = new HashSet<ASTNode>();
            Object Invalid = new Object();
            try {
                HelperVisitor.callAssignmentVisitor(parent, dataholder, nodesprocessed, (assignment, holder2) -> {
                    IBinding binding;
                    Expression leftSide;
                    SimpleName sn;
                    if (assignment.getStartPosition() > node_a.getStartPosition() && (sn = ASTNodes.as(leftSide = assignment.getLeftHandSide(), SimpleName.class)) != null && (binding = sn.resolveBinding()).isEqualTo(bliBinding)) {
                        MethodInvocation mi = ASTNodes.as(assignment.getRightHandSide(), MethodInvocation.class);
                        if (mi == null || !mi.getName().getIdentifier().equals("iterator")) {
                            dataholder.put(node_a, Invalid);
                            throw new AbortSearchException();
                        }
                        dataholder.put(node_a, mi);
                    }
                    return true;
                });
            }
            catch (AbortSearchException abortSearchException) {}
            Object holderObject = dataholder.get(node_a);
            if (holderObject == Invalid || holderObject == null) {
                return null;
            }
            exp = (Expression)dataholder.get(node_a);
        }
        if ((mi = ASTNodes.as(exp, MethodInvocation.class)) != null && mi.getName().toString().equals("iterator")) {
            ITypeBinding[] typeArgs;
            ITypeBinding iterableAncestor = null;
            IMethodBinding miBinding = mi.resolveMethodBinding();
            if (miBinding != null) {
                iterableAncestor = ASTNodes.findImplementedType(miBinding.getDeclaringClass(), Iterable.class.getCanonicalName());
            }
            if (iterableAncestor != null && (typeArgs = iterableAncestor.getTypeArguments()).length > 0) {
                return typeArgs[0];
            }
        } else {
            ITypeBinding[] typeArgs;
            ITypeBinding varTypeBinding = node_a.getType().resolveBinding();
            if (varTypeBinding != null && (typeArgs = varTypeBinding.getTypeArguments()).length > 0) {
                return typeArgs[0];
            }
        }
        return node_a.getAST().resolveWellKnownType("java.lang.Object");
    }

    @Override
    public void rewrite(UseIteratorToForLoopFixCore upp, WhileLoopToChangeHit hit, CompilationUnitRewrite cuRewrite, TextEditGroup group) {
        String looptargettype;
        Type type;
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        AST ast = cuRewrite.getRoot().getAST();
        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
        ImportRemover remover = cuRewrite.getImportRemover();
        EnhancedForStatement newEnhancedForStatement = ast.newEnhancedForStatement();
        SingleVariableDeclaration result = ast.newSingleVariableDeclaration();
        SimpleName name = ast.newSimpleName(hit.loopVarName);
        result.setName(name);
        ITypeBinding varBinding = null;
        if (hit.nextWithoutVariableDeclaration || !hit.nextFound) {
            type = null;
        } else {
            Expression expression = hit.loopVarDeclaration.getExpression();
            SimpleName variable = ASTNodes.as(expression, SimpleName.class);
            looptargettype = variable.resolveTypeBinding().getErasure().getQualifiedName();
            VariableDeclarationStatement typedAncestor = ASTNodes.getTypedAncestor((ASTNode)hit.loopVarDeclaration, VariableDeclarationStatement.class);
            type = typedAncestor.getType();
            varBinding = type.resolveBinding();
        }
        if (type == null || varBinding == null) {
            looptargettype = "java.lang.Object";
            ITypeBinding binding = WhileToForEach.computeTypeArgument(hit.iteratorDeclaration);
            SimpleType parameterizedType = null;
            if (binding != null) {
                looptargettype = binding.getErasure().getQualifiedName();
                if (binding.isParameterizedType()) {
                    parameterizedType = this.handleParameterizedType(binding, ast, cuRewrite);
                }
            }
            if (parameterizedType == null) {
                parameterizedType = ast.newSimpleType(this.addImport(looptargettype, cuRewrite, ast));
            }
            result.setType(parameterizedType);
        } else {
            Type importType = this.importType(varBinding, (ASTNode)hit.iteratorDeclaration, importRewrite, (CompilationUnit)hit.iteratorDeclaration.getRoot(), ImportRewrite.TypeLocation.LOCAL_VARIABLE);
            remover.registerAddedImports(importType);
            result.setType(importType);
        }
        newEnhancedForStatement.setParameter(result);
        if (hit.self) {
            ThisExpression newThisExpression = ast.newThisExpression();
            newEnhancedForStatement.setExpression((Expression)newThisExpression);
        } else {
            Expression loopExpression = (Expression)rewrite.createCopyTarget((ASTNode)hit.collectionExpression);
            newEnhancedForStatement.setExpression(loopExpression);
        }
        ASTNodes.removeButKeepComment(rewrite, (ASTNode)hit.iteratorDeclaration, group);
        remover.registerRemovedNode((ASTNode)hit.iteratorDeclaration.getType());
        if (hit.iteratorCall != hit.iteratorDeclaration) {
            ASTNodes.removeButKeepComment(rewrite, (ASTNode)hit.iteratorCall, group);
            remover.registerRemovedNode((ASTNode)hit.iteratorCall);
        }
        if (hit.nextFound) {
            if (hit.nextWithoutVariableDeclaration) {
                MethodInvocation loopVarDeclaration = hit.loopVarDeclaration;
                while (loopVarDeclaration.getParent() instanceof ParenthesizedExpression) {
                    loopVarDeclaration = loopVarDeclaration.getParent();
                }
                if (loopVarDeclaration.getLocationInParent() == ExpressionStatement.EXPRESSION_PROPERTY) {
                    rewrite.remove(loopVarDeclaration.getParent(), group);
                    remover.registerRemovedNode((ASTNode)loopVarDeclaration);
                } else {
                    ASTNodes.replaceButKeepComment(rewrite, (ASTNode)hit.loopVarDeclaration, (ASTNode)name, group);
                    remover.registerRemovedNode((ASTNode)hit.loopVarDeclaration);
                }
            } else {
                VariableDeclarationStatement node = ASTNodes.getTypedAncestor((ASTNode)hit.loopVarDeclaration, VariableDeclarationStatement.class);
                ASTNodes.removeButKeepComment(rewrite, (ASTNode)node, group);
                remover.registerRemovedNode((ASTNode)node);
            }
        }
        newEnhancedForStatement.setBody(ASTNodes.createMoveTarget(rewrite, hit.whileStatement.getBody()));
        ASTNodes.replaceButKeepComment(rewrite, (ASTNode)hit.whileStatement, (ASTNode)newEnhancedForStatement, group);
        remover.registerRemovedNode((ASTNode)hit.whileStatement.getExpression());
        remover.applyRemoves(importRewrite);
    }

    private Type handleParameterizedType(ITypeBinding binding, AST ast, CompilationUnitRewrite cuRewrite) {
        String loopTargetType = binding.getErasure().getQualifiedName();
        SimpleType type = ast.newSimpleType(this.addImport(loopTargetType, cuRewrite, ast));
        if (binding.isParameterizedType()) {
            ITypeBinding[] args;
            ParameterizedType pType = ast.newParameterizedType((Type)type);
            ArrayList<Type> typeArgs = new ArrayList<Type>();
            ITypeBinding[] iTypeBindingArray = args = binding.getTypeArguments();
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding arg = iTypeBindingArray[n2];
                Type argType = null;
                if (arg.isParameterizedType()) {
                    argType = this.handleParameterizedType(arg, ast, cuRewrite);
                } else {
                    String argumentType = arg.getQualifiedName();
                    Name argumentTypeName = !arg.isTypeVariable() ? this.addImport(argumentType, cuRewrite, ast) : ast.newName(argumentType);
                    argType = ast.newSimpleType(argumentTypeName);
                }
                typeArgs.add(argType);
                ++n2;
            }
            pType.typeArguments().addAll(typeArgs);
            type = pType;
        }
        return type;
    }

    private Type importType(ITypeBinding toImport, ASTNode accessor, ImportRewrite imports, CompilationUnit compilationUnit, ImportRewrite.TypeLocation location) {
        ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(compilationUnit, accessor.getStartPosition(), imports);
        return imports.addImport(toImport, compilationUnit.getAST(), (ImportRewrite.ImportRewriteContext)importContext, location);
    }

    @Override
    public String getPreview(boolean afterRefactoring) {
        if (afterRefactoring) {
            return "\nfor (String s : strings) {\n\n\tSystem.out.println(s);\n}\n\n";
        }
        return "Iterator it = lists.iterator();\nwhile (it.hasNext()) {\n    String s = (String) it.next();\n\tSystem.out.println(s);\n}\n\n";
    }
}

