/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.layout;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.BirtContext;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.presentation.aggregation.BirtBaseFragment;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.actionhandler.BirtCustomerExtractDataActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtExtractDataActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtGetReportletActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRenderImageActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRenderReportActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunAndRenderActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunReportActionHandler;
import org.eclipse.birt.report.session.IViewingSession;
import org.eclipse.birt.report.session.ViewingSessionUtil;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class EngineFragment
extends BirtBaseFragment {
    @Override
    protected void doPreService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        BirtContext context = new BirtContext(request, response);
        String format = ParameterAccessor.getFormat(request);
        String emitterId = ParameterAccessor.getEmitterId(request);
        String openType = ParameterAccessor.getOpenType(request);
        if ("/download".equalsIgnoreCase(request.getServletPath())) {
            response.setContentType("text/plain; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=exportdata.csv");
        } else if ("/extract".equalsIgnoreCase(request.getServletPath())) {
            String mimeType;
            String docFile;
            BaseAttributeBean attrBean = (BaseAttributeBean)request.getAttribute("attributeBean");
            String extractFormat = ParameterAccessor.getExtractFormat(request);
            String extractExtension = ParameterAccessor.getExtractExtension(request);
            if (extractExtension != null) {
                extractFormat = ParameterAccessor.getExtractFormat(extractExtension);
            }
            if ((docFile = attrBean.getReportDocumentName()) != null && docFile.length() > 0 && extractFormat != null) {
                String fileName = ParameterAccessor.getExtractionFilename(context, extractExtension, extractFormat);
                response.setHeader("Content-Disposition", String.valueOf(openType) + "; filename=\"" + fileName + "\"");
            }
            if ((mimeType = ParameterAccessor.getExtractionMIMEType(extractFormat, extractExtension)) != null && mimeType.length() > 0) {
                response.setContentType(mimeType);
            } else {
                response.setContentType("application/octet-stream");
            }
        } else if ("/document".equalsIgnoreCase(request.getServletPath())) {
            BaseAttributeBean attrBean = (BaseAttributeBean)request.getAttribute("attributeBean");
            String docFile = attrBean.getReportDocumentName();
            if (docFile == null || docFile.length() <= 0) {
                String fileName = ParameterAccessor.getGeneratedReportDocumentName(context);
                response.setContentType("application/octet-stream");
                response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            } else {
                response.setContentType("text/html; charset=utf-8");
            }
        } else {
            String mimeType = ParameterAccessor.getEmitterMimeType(emitterId);
            if (mimeType == null) {
                mimeType = ReportEngineService.getInstance().getMIMEType(format);
            }
            if (mimeType != null && mimeType.length() > 0) {
                response.setContentType(mimeType);
            } else {
                response.setContentType("application/octet-stream");
            }
            if (!ParameterAccessor.isGetImageOperator(request)) {
                if ("html".equals(ParameterAccessor.getFormat(request))) {
                    try {
                        IViewingSession session = ViewingSessionUtil.getSession(context.getRequest());
                        if (session == null) {
                            session = ViewingSessionUtil.createSession(context.getRequest());
                        }
                    }
                    catch (ViewerException e) {
                        throw new ServletException((Throwable)((Object)e));
                    }
                }
                String filename = ParameterAccessor.getExportFilename(context, format, emitterId);
                response.setHeader("Content-Disposition", String.valueOf(openType) + "; filename=\"" + filename + "\"");
            }
        }
    }

    @Override
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        BaseAttributeBean attrBean = (BaseAttributeBean)request.getAttribute("attributeBean");
        Object out = response.getOutputStream();
        GetUpdatedObjectsResponse upResponse = new GetUpdatedObjectsResponse();
        BirtContext context = new BirtContext(request, response);
        Operation op = null;
        try {
            if ("/download".equalsIgnoreCase(request.getServletPath())) {
                BirtExtractDataActionHandler extractDataHandler = new BirtExtractDataActionHandler(context, op, upResponse);
                extractDataHandler.execute();
            } else if ("/extract".equalsIgnoreCase(request.getServletPath())) {
                BirtCustomerExtractDataActionHandler extractDataHandler = new BirtCustomerExtractDataActionHandler(context, op, upResponse);
                extractDataHandler.execute();
            } else if ("/document".equalsIgnoreCase(request.getServletPath())) {
                String docFile = attrBean.getReportDocumentName();
                if (docFile == null || docFile.length() <= 0) {
                    docFile = ParameterAccessor.getReportDocument(request, "", true);
                    attrBean.setReportDocumentName(docFile);
                    BirtRunReportActionHandler runReport = new BirtRunReportActionHandler(context, op, upResponse);
                    runReport.execute();
                    BirtUtility.outputFile(docFile, (OutputStream)out, true);
                } else {
                    BirtRunReportActionHandler runReport = new BirtRunReportActionHandler(context, op, upResponse);
                    runReport.execute();
                    BirtUtility.writeMessage((OutputStream)out, BirtResources.getMessage("birt.viewer.message.document.successful"), "complete", ParameterAccessor.isCloseWindow(request));
                }
            } else if (ParameterAccessor.isGetImageOperator(request)) {
                BirtRenderImageActionHandler renderImageHandler = new BirtRenderImageActionHandler(context, op, upResponse);
                renderImageHandler.execute();
            } else {
                if ("/output".equalsIgnoreCase(request.getServletPath())) {
                    AxisFault fault;
                    File file = new File(attrBean.getReportDocumentName());
                    if (!file.exists()) {
                        BirtRunReportActionHandler handler = new BirtRunReportActionHandler(context, op, upResponse);
                        handler.execute();
                    }
                    if (!(file = new File(attrBean.getReportDocumentName())).exists()) {
                        fault = new AxisFault();
                        fault.setFaultReason(BirtResources.getMessage("birt.viewer.actionException.NO_REPORT_DOCUMENT"));
                        throw fault;
                    }
                    if (attrBean.isDocumentProcessing()) {
                        fault = new AxisFault();
                        fault.setFaultReason(BirtResources.getMessage("birt.viewer.generalException.DOCUMENT_FILE_PROCESSING"));
                        throw fault;
                    }
                    attrBean.setDocumentInUrl(true);
                }
                boolean isPrint = false;
                if ("print".equalsIgnoreCase(attrBean.getAction())) {
                    isPrint = true;
                    out = new ByteArrayOutputStream();
                }
                if (ParameterAccessor.isGetReportlet(request)) {
                    BirtGetReportletActionHandler getReportletHandler = new BirtGetReportletActionHandler(context, op, upResponse, (OutputStream)out);
                    getReportletHandler.execute();
                } else if (attrBean.isDocumentInUrl()) {
                    BirtRenderReportActionHandler runReportHandler = new BirtRenderReportActionHandler(context, op, upResponse, (OutputStream)out);
                    runReportHandler.execute();
                } else {
                    BirtRunAndRenderActionHandler runAndRenderHandler = new BirtRunAndRenderActionHandler(context, op, upResponse, (OutputStream)out);
                    runAndRenderHandler.execute();
                }
                if (isPrint) {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                    BirtUtility.doPrintAction(inputStream, request, response);
                }
            }
        }
        catch (RemoteException | ViewerException e) {
            this.handleException(request, response, (Exception)e);
        }
    }

    private void handleException(HttpServletRequest request, HttpServletResponse response, Exception e) throws IOException {
        if (ParameterAccessor.isGetImageOperator(request)) {
            response.sendError(404);
            e.printStackTrace();
        } else {
            response.setContentType("text/html; charset=utf-8");
            response.setHeader("Content-Disposition", "inline");
            BirtUtility.appendErrorMessage((OutputStream)response.getOutputStream(), e);
        }
    }

    @Override
    protected String doPostService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return null;
    }
}

