/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model;

import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public abstract class ReportItemtHandleAdapter
extends DesignElementHandleAdapter {
    public ReportItemtHandleAdapter(ReportItemHandle handle, IModelAdapterHelper mark) {
        super((DesignElementHandle)handle, mark);
    }

    public Point getLocation() {
        DimensionHandle handle = this.getReportItemHandle().getX();
        int x = 0;
        if ("px".equals(handle.getUnits())) {
            x = (int)handle.getMeasure();
        }
        double px = DEUtil.convertToValue(handle, "in");
        handle = this.getReportItemHandle().getY();
        int y = 0;
        if ("px".equals(handle.getUnits())) {
            y = (int)handle.getMeasure();
        }
        double py = DEUtil.convertToValue(handle, "in");
        Point p = MetricUtility.inchToPixel(px, py);
        if (x != 0) {
            p.x = x;
        }
        if (y != 0) {
            p.y = y;
        }
        return p;
    }

    public void setLocation(Point location) throws SemanticException {
        this.getReportItemHandle().getX().setStringValue(String.valueOf(Integer.toString(location.x)) + "px");
        this.getReportItemHandle().getY().setStringValue(String.valueOf(Integer.toString(location.y)) + "px");
    }

    public Dimension getSize() {
        DimensionHandle handle = this.getReportItemHandle().getWidth();
        int px = (int)DEUtil.convertoToPixel(handle);
        handle = this.getReportItemHandle().getHeight();
        int py = (int)DEUtil.convertoToPixel(handle);
        return new Dimension(px, py);
    }

    public void setSize(Dimension size) throws SemanticException {
        DimensionValue dimensionValue;
        if (size.width >= 0) {
            double width = MetricUtility.pixelToPixelInch(size.width);
            dimensionValue = new DimensionValue(width, "in");
            this.getReportItemHandle().getWidth().setValue((Object)dimensionValue);
        }
        if (size.height >= 0) {
            double height = MetricUtility.pixelToPixelInch(size.height);
            dimensionValue = new DimensionValue(height, "in");
            this.getReportItemHandle().getHeight().setValue((Object)dimensionValue);
        }
    }

    public Rectangle getbounds() {
        return new Rectangle(this.getLocation().x, this.getLocation().y, this.getSize().width, this.getSize().height);
    }

    public void setBounds(Rectangle bounds) throws SemanticException {
        this.setSize(bounds.getSize());
        this.setLocation(new Point(bounds.getLocation().x, bounds.getLocation().y));
    }

    public ReportItemHandle getReportItemHandle() {
        return (ReportItemHandle)this.getHandle();
    }
}

