/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceSelectionValidator;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class BgImageFieldEditor
extends AbstractFieldEditor {
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg", ".jpeg", ".jpe", ".jfif", ".gif", ".png", ".tif", ".tiff", ".ico", ".svg"};
    private static final String[] IMAGE_FILEFILTERS = new String[]{"*.bmp;*.jpg;*.jpeg;*.jpe;*.jfif;*.gif;*.png;*.tif;*.tiff;*.ico;*.svg"};
    private Text fText;
    private Button fButton;

    public BgImageFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected void doLoad() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        if (value != null) {
            this.fText.setText(value);
        } else {
            this.fText.setText("");
        }
        this.setOldValue(this.getStringValue());
    }

    protected void doLoadDefault() {
        String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        if (value != null) {
            this.fText.setText(value);
        } else {
            this.fText.setText("");
        }
        this.setDefaultValue(value);
        if (this.getPreferenceStore() instanceof StylePreferenceStore) {
            StylePreferenceStore store = (StylePreferenceStore)this.getPreferenceStore();
            if (store.hasLocalValue(this.getPreferenceName())) {
                this.markDirty(true);
            } else {
                this.markDirty(false);
            }
        } else {
            this.markDirty(true);
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = 1;
            --numColumns;
        }
        ((GridData)this.getTextControl(null).getLayoutData()).horizontalSpan = 1;
        ((GridData)this.getTextControl(null).getLayoutData()).widthHint = 85;
        ((GridData)this.getButtonControl(null).getLayoutData()).horizontalSpan = --numColumns;
        ((GridData)this.getButtonControl(null).getLayoutData()).widthHint = Math.max(this.getButtonControl(null).computeSize((int)-1, (int)-1).x, 85);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        control.setLayoutData((Object)new GridData());
        control = this.getTextControl(parent);
        control.setLayoutData((Object)new GridData());
        Button button = this.getButtonControl(parent);
        button.setText(Messages.getString((String)"BgImageFieldEditor.displayname.Browse"));
        button.setLayoutData((Object)new GridData());
    }

    public Text getTextControl(Composite parent) {
        if (this.fText == null) {
            this.fText = new Text(parent, 2048);
            this.fText.setFont(parent.getFont());
            this.fText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BgImageFieldEditor.this.valueChanged("field_editor_value");
                }
            });
        }
        return this.fText;
    }

    protected Button getButtonControl(Composite parent) {
        if (this.fButton == null) {
            this.fButton = new Button(parent, 8);
            this.fButton.setFont(parent.getFont());
            this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String file;
                    ResourceSelectionValidator validator = new ResourceSelectionValidator(IMAGE_TYPES);
                    ResourceFileFolderSelectionDialog dialog = new ResourceFileFolderSelectionDialog(true, true, IMAGE_FILEFILTERS);
                    dialog.setEmptyFolderShowStatus(2);
                    dialog.setTitle(Messages.getString((String)"ImageBuilder.BrowserResourceDialog.Title"));
                    dialog.setMessage(Messages.getString((String)"ImageBuilder.BrowserResourceDialog.Message"));
                    dialog.setValidator(validator);
                    if (dialog.open() == 0 && (file = dialog.getPath()) != null) {
                        if (!BgImageFieldEditor.this.checkExtensions(IMAGE_TYPES, file)) {
                            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Title"), Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Message"));
                            return;
                        }
                        BgImageFieldEditor.this.getTextControl(null).setText(dialog.getPath());
                        BgImageFieldEditor.this.valueChanged("field_editor_value");
                    }
                }
            });
        }
        return this.fButton;
    }

    @Override
    protected String getStringValue() {
        if (this.fText != null) {
            return this.fText.getText();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    private boolean checkExtensions(String[] fileExt, String fileName) {
        int i = 0;
        while (i < fileExt.length) {
            String ext = fileExt[i].substring(fileExt[i].lastIndexOf(46));
            if (fileName.toLowerCase().endsWith(ext.toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

