/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;

class AncestorHelper
implements PropertyChangeListener,
FigureListener {
    protected final IFigure base;
    protected AncestorListener[] listeners;

    public AncestorHelper(IFigure baseFigure) {
        this.base = baseFigure;
        this.addAncestors(baseFigure);
    }

    public void addAncestorListener(AncestorListener listener) {
        if (this.listeners == null) {
            this.listeners = new AncestorListener[1];
            this.listeners[0] = listener;
        } else {
            int oldSize = this.listeners.length;
            AncestorListener[] newListeners = new AncestorListener[oldSize + 1];
            System.arraycopy(this.listeners, 0, newListeners, 0, oldSize);
            newListeners[oldSize] = listener;
            this.listeners = newListeners;
        }
    }

    protected void addAncestors(IFigure rootFigure) {
        IFigure ancestor = rootFigure;
        while (ancestor != null) {
            ancestor.addFigureListener(this);
            ancestor.addPropertyChangeListener("parent", this);
            ancestor = ancestor.getParent();
        }
    }

    public void dispose() {
        this.removeAncestors(this.base);
        this.listeners = null;
    }

    @Override
    public void figureMoved(IFigure ancestor) {
        this.fireAncestorMoved(ancestor);
    }

    protected void fireAncestorMoved(IFigure ancestor) {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].ancestorMoved(ancestor);
            ++i;
        }
    }

    protected void fireAncestorAdded(IFigure ancestor) {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].ancestorAdded(ancestor);
            ++i;
        }
    }

    protected void fireAncestorRemoved(IFigure ancestor) {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].ancestorRemoved(ancestor);
            ++i;
        }
    }

    public boolean isEmpty() {
        return this.listeners == null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("parent")) {
            IFigure oldParent = (IFigure)event.getOldValue();
            IFigure newParent = (IFigure)event.getNewValue();
            if (oldParent != null) {
                this.removeAncestors(oldParent);
                this.fireAncestorRemoved(oldParent);
            }
            if (newParent != null) {
                this.addAncestors(newParent);
                this.fireAncestorAdded(newParent);
            }
        }
    }

    public void removeAncestorListener(AncestorListener listener) {
        if (this.listeners == null) {
            return;
        }
        int index = 0;
        while (index < this.listeners.length) {
            if (this.listeners[index] == listener) {
                int newSize = this.listeners.length - 1;
                AncestorListener[] newListeners = null;
                if (newSize != 0) {
                    newListeners = new AncestorListener[newSize];
                    System.arraycopy(this.listeners, 0, newListeners, 0, index);
                    System.arraycopy(this.listeners, index + 1, newListeners, index, newSize - index);
                }
                this.listeners = newListeners;
                return;
            }
            ++index;
        }
    }

    protected void removeAncestors(IFigure rootFigure) {
        IFigure ancestor = rootFigure;
        while (ancestor != null) {
            ancestor.removeFigureListener(this);
            ancestor.removePropertyChangeListener("parent", this);
            ancestor = ancestor.getParent();
        }
    }
}

