/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import com.ibm.icu.util.ULocale;
import com.lowagie.text.Image;
import java.util.Locale;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.ObjectContent;
import org.eclipse.birt.report.engine.emitter.ImageReader;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageBlockContainer;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageInlineContainer;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineStackingArea;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;

public class ImageAreaLayout
implements ILayout {
    private ILayout layout = null;
    private ContainerArea parent;
    private IImageContent content;
    private ImageReader reader;
    private Image imageObject = null;
    private LayoutContext context;
    protected static Logger logger = Logger.getLogger(ImageAreaLayout.class.getName());
    private static Pattern pattern = Pattern.compile(" ([^=]*)=\"([^\"]*)\"");

    public ImageAreaLayout(ContainerArea parent, LayoutContext context, IImageContent content) {
        this.parent = parent;
        this.content = content;
        this.context = context;
    }

    @Override
    public void layout() throws BirtException {
        this.initialize();
        if (this.layout != null) {
            this.layout.layout();
        }
    }

    protected void initialize() throws BirtException {
        this.reader = new ImageReader(this.content, this.context.getSupportedImageFormats());
        int result = this.reader.read();
        switch (result) {
            case 0: {
                this.layout = this.createAltTextLayout(0);
                break;
            }
            case 1: {
                this.layout = this.createAltTextLayout(1);
                break;
            }
            case 2: {
                if (this.reader.getType() == 0 || this.reader.getType() == 3) {
                    try {
                        this.imageObject = Image.getInstance((byte[])this.reader.getByteArray());
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getLocalizedMessage());
                    }
                    if (this.imageObject == null) {
                        this.layout = this.createAltTextLayout(1);
                        break;
                    }
                }
                this.layout = new ConcreteImageLayout(this.context, this.parent, this.content, this.reader.getByteArray());
            }
        }
    }

    private ILayout createAltTextLayout(int altTextType) {
        ITextContent altTextContent = this.createAltText(this.content, altTextType);
        if (altTextContent == null) {
            return null;
        }
        BlockTextArea bta = new BlockTextArea(this.parent, this.context, altTextContent);
        bta.setHelpText(altTextContent.getText());
        return bta;
    }

    private ITextContent createAltText(IImageContent imageContent, int altTextType) {
        IReportContent report = imageContent.getReportContent();
        if (report == null) {
            return null;
        }
        ITextContent altTextContent = report.createTextContent(imageContent);
        altTextContent.setParent(imageContent.getParent());
        String alt = imageContent.getAltText();
        if (alt == null) {
            ULocale locale = ULocale.forLocale((Locale)this.context.getLocale());
            if (locale == null) {
                locale = ULocale.getDefault();
            }
            EngineResourceHandle resourceHandle = new EngineResourceHandle(locale);
            if (altTextType == 1) {
                alt = this.reader.getType() == 1 ? resourceHandle.getMessage("Error.FlashObjectNotSupported") : resourceHandle.getMessage("Error.ReportItemNotSupported");
            }
            if (altTextType == 0) {
                alt = resourceHandle.getMessage("Error.ResourceUnreachable");
            }
        }
        altTextContent.setText(alt);
        return altTextContent;
    }

    class ConcreteImageLayout
    implements ILayout {
        private int resolutionX = 0;
        private int resolutionY = 0;
        private byte[] data;
        private ContainerArea parent;
        protected static final int DEFAULT_WIDHT = 212000;
        protected static final int DEFAULT_HEIGHT = 130000;
        protected IImageContent image;
        protected ContainerArea root;
        private Dimension intrinsic;
        private static final String BOOKMARK_JAVASCRIPT_PREFIX = "javascript:catchBookmark('";
        private static final String BOOKMARK_URL_PREFIX = "__bookmark=";
        private static final String BOOKMARK_ANCHOR_PREFIX = "#";
        private LayoutContext context;
        private boolean fitToContainer = false;
        private BlockTextArea innerText = null;

        public ConcreteImageLayout(LayoutContext context, ContainerArea parent, IImageContent content, byte[] data) {
            this.context = context;
            this.image = content;
            this.parent = parent;
            this.data = data;
            Object reportItemDesign = content.getGenerateBy();
            if (reportItemDesign != null && reportItemDesign instanceof ImageItemDesign) {
                this.fitToContainer = ((ImageItemDesign)reportItemDesign).isFitToContainer();
            }
        }

        protected Dimension getIntrinsicDimension(IImageContent content, Image image) {
            if (image != null) {
                return new Dimension((int)(image.getPlainWidth() * 1000.0f / (float)this.resolutionX * 72.0f), (int)(image.getPlainHeight() * 1000.0f / (float)this.resolutionY * 72.0f));
            }
            return null;
        }

        protected Dimension getSpecifiedDimension(IImageContent content, int pWidth, boolean scale) {
            int imageFileDpiX = 0;
            int imageFileDpiY = 0;
            if ((ImageAreaLayout.this.reader.getType() == 0 || ImageAreaLayout.this.reader.getType() == 3) && ImageAreaLayout.this.imageObject != null) {
                imageFileDpiX = ImageAreaLayout.this.imageObject.getDpiX();
                imageFileDpiY = ImageAreaLayout.this.imageObject.getDpiY();
            }
            this.resolutionX = PropertyUtil.getImageDpi(content, imageFileDpiX, this.context.getDpi());
            this.resolutionY = PropertyUtil.getImageDpi(content, imageFileDpiY, this.context.getDpi());
            try {
                this.intrinsic = this.getIntrinsicDimension(content, ImageAreaLayout.this.imageObject);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage());
            }
            int specifiedWidth = PropertyUtil.getImageDimensionValue(content, content.getWidth(), this.context.getDpi(), pWidth);
            int specifiedHeight = PropertyUtil.getImageDimensionValue(content, content.getHeight(), this.context.getDpi(), -1);
            Dimension dim = new Dimension(212000, 130000);
            if (this.intrinsic == null) {
                dim.setDimension(specifiedWidth == -1 ? 212000 : specifiedWidth, specifiedHeight == -1 ? 130000 : specifiedHeight);
                return dim;
            }
            if (scale) {
                double ratio = this.intrinsic.getRatio();
                if (specifiedWidth >= 0) {
                    if (specifiedHeight >= 0) {
                        dim.setDimension(specifiedWidth, specifiedHeight);
                    } else {
                        dim.setDimension(specifiedWidth, (int)((double)specifiedWidth / ratio));
                    }
                } else if (specifiedHeight >= 0) {
                    dim.setDimension((int)((double)specifiedHeight * ratio), specifiedHeight);
                } else {
                    dim.setDimension(this.intrinsic.getWidth(), this.intrinsic.getHeight());
                }
            } else if (specifiedWidth >= 0) {
                if (specifiedHeight >= 0) {
                    dim.setDimension(specifiedWidth, specifiedHeight);
                } else {
                    dim.setDimension(specifiedWidth, this.intrinsic.getHeight());
                }
            } else if (specifiedHeight >= 0) {
                dim.setDimension(this.intrinsic.getWidth(), specifiedHeight);
            } else {
                dim.setDimension(this.intrinsic.getWidth(), this.intrinsic.getHeight());
            }
            return dim;
        }

        @Override
        public void layout() throws BirtException {
            this.init();
            boolean isEmptyLine = true;
            boolean innerTextInserted = false;
            if ("pdf".equalsIgnoreCase(this.context.getFormat()) && ImageAreaLayout.this.reader.getType() == 1) {
                innerTextInserted = true;
                this.innerText = this.createInnerTextLayout();
                this.innerText.content.getStyle().setProperty(23, IStyle.CENTER_VALUE);
                this.innerText.setVerticalAlign(IStyle.MIDDLE_VALUE);
                this.innerText.setIgnoreReordering(true);
                if (PropertyUtil.isInlineElement(this.image)) {
                    InlineStackingArea lineParent = (InlineStackingArea)this.parent;
                    isEmptyLine = lineParent.isEmptyLine();
                }
                int lastIP = this.root.currentIP;
                int lastBP = this.root.currentBP;
                this.innerText.layout();
                this.innerText.setAllocatedPosition(0, 0);
                int rootHeight = this.root.getContentHeight();
                if (rootHeight < this.innerText.getHeight()) {
                    this.innerText.setHeight(rootHeight - 1000 > 0 ? rootHeight - 1000 : 0);
                    this.innerText.setNeedClip(true);
                }
                this.root.currentIP = lastIP;
                this.root.currentBP = lastBP;
            }
            if (PropertyUtil.isInlineElement(this.image)) {
                assert (this.parent instanceof InlineStackingArea);
                InlineStackingArea lineParent = (InlineStackingArea)this.parent;
                if (this.root.getAllocatedWidth() > this.parent.getCurrentMaxContentWidth()) {
                    if (innerTextInserted && !isEmptyLine || !innerTextInserted && !lineParent.isEmptyLine()) {
                        lineParent.endLine(false);
                        this.layout();
                    } else {
                        this.parent.add(this.root);
                        this.root.finished = true;
                        this.parent.update(this.root);
                    }
                } else {
                    this.parent.add(this.root);
                    this.root.finished = true;
                    this.parent.update(this.root);
                }
            } else {
                int aHeight;
                this.parent.add(this.root);
                if (!this.parent.isInInlineStacking && this.context.isAutoPageBreak() && (aHeight = this.root.getAllocatedHeight()) + this.parent.getAbsoluteBP() > this.context.getMaxBP()) {
                    this.parent.autoPageBreak();
                }
                this.root.finished = true;
                this.parent.update(this.root);
            }
            this.checkDisplayNone();
        }

        protected void checkDisplayNone() {
            if (this.context != null && this.context.isDisplayNone()) {
                int aHeight = this.root.getAllocatedHeight();
                this.parent.setCurrentBP(this.parent.currentBP - aHeight);
                this.root.height = 0;
            }
        }

        protected void init() throws BirtException {
            this.root = PropertyUtil.isInlineElement(this.image) ? new ImageInlineContainer(this.parent, this.context, this.image) : new ImageBlockContainer(this.parent, this.context, this.image);
            this.root.initialize();
            this.root.setAllocatedWidth(this.parent.getMaxAvaWidth());
            this.root.setMaxAvaWidth(this.root.getContentWidth());
            Dimension contentDimension = this.getSpecifiedDimension(this.image, this.root.getContentWidth(), true);
            ImageArea imageArea = this.createImageArea(this.image);
            imageArea.setParent(this.root);
            int maxHeight = this.root.getMaxAvaHeight();
            int maxWidth = this.root.getMaxAvaWidth();
            int cHeight = contentDimension.getHeight();
            int cWidth = contentDimension.getWidth();
            int actualHeight = cHeight;
            int actualWidth = cWidth;
            if (cHeight > maxHeight || cWidth > maxWidth) {
                if (this.fitToContainer) {
                    float rh = (float)maxHeight / (float)cHeight;
                    float rw = (float)maxWidth / (float)cWidth;
                    if (rh > rw) {
                        actualHeight = (int)((float)cHeight * (float)maxWidth / (float)cWidth);
                        actualWidth = maxWidth;
                    } else {
                        actualHeight = maxHeight;
                        actualWidth = (int)((float)cWidth * (float)maxHeight / (float)cHeight);
                    }
                    imageArea.setWidth(actualWidth);
                    imageArea.setHeight(actualHeight);
                    this.root.setContentWidth(imageArea.getWidth());
                    this.root.setContentHeight(imageArea.getHeight());
                } else if (this.context.getPageOverflow() == 2 || this.context.getPageOverflow() == 8) {
                    imageArea.setWidth(actualWidth);
                    imageArea.setHeight(actualHeight);
                    this.root.setContentHeight(actualHeight);
                    this.root.setContentWidth(actualWidth);
                } else {
                    imageArea.setWidth(actualWidth);
                    imageArea.setHeight(actualHeight);
                    this.root.setNeedClip(true);
                    this.root.setContentHeight(Math.min(maxHeight, cHeight));
                    this.root.setContentWidth(Math.min(maxWidth, cWidth));
                    if (maxWidth < cWidth) {
                        if (this.root.getBoxStyle() == BoxStyle.DEFAULT) {
                            this.root.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                        }
                        this.root.getBoxStyle().setRightBorder(null);
                    }
                    if (maxHeight < cHeight) {
                        if (this.root.getBoxStyle() == BoxStyle.DEFAULT) {
                            this.root.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                        }
                        this.root.getBoxStyle().setBottomBorder(null);
                    }
                }
            } else {
                imageArea.setWidth(actualWidth);
                imageArea.setHeight(actualHeight);
                this.root.setContentWidth(imageArea.getWidth());
                this.root.setContentHeight(imageArea.getHeight());
            }
            this.root.addChild(imageArea);
            imageArea.setPosition(this.root.getContentX(), this.root.getContentY());
            if (this.context.getEngineTaskType() != 1) {
                this.processChartLegend(this.image, imageArea);
            }
            this.root.finished = false;
        }

        protected ImageArea createImageArea(IImageContent content) {
            ImageArea area = new ImageArea();
            String mimeType = content.getMIMEType();
            String extension = content.getExtension();
            area.setExtension(extension);
            area.setMIMEType(mimeType);
            switch (content.getImageSource()) {
                case 0: 
                case 3: {
                    area.setUrl(content.getURI());
                    break;
                }
                case 1: {
                    area.setUrl("NamedImage_" + content.getURI());
                    break;
                }
            }
            area.setData(this.data);
            if (ImageAreaLayout.this.reader.getType() == 2) {
                area.setMIMEType("image/svg+xml");
                area.setExtension(".svg");
            }
            if (ImageAreaLayout.this.reader.getType() == 3) {
                area.setMIMEType("image/jpeg");
                area.setExtension(".jpg");
            }
            if (content instanceof ObjectContent) {
                ObjectContent object = (ObjectContent)content;
                area.setParameters(object.getParamters());
            }
            area.setAction(content.getHyperlinkAction());
            return area;
        }

        private BlockTextArea createInnerTextLayout() {
            IReportContent report = this.image.getReportContent();
            if (report == null) {
                return null;
            }
            ITextContent promptTextContent = report.createTextContent(this.image);
            ULocale locale = ULocale.forLocale((Locale)this.context.getLocale());
            if (locale == null) {
                locale = ULocale.getDefault();
            }
            EngineResourceHandle resourceHandle = new EngineResourceHandle(locale);
            String prompt = resourceHandle.getMessage("Error.UpdateUserAgent");
            promptTextContent.setText(prompt);
            return new BlockTextArea(this.root, this.context, promptTextContent);
        }

        private void processChartLegend(IImageContent imageContent, IImageArea imageArea) {
            boolean hasImageMap;
            Object imageMapObject = imageContent.getImageMap();
            boolean bl = hasImageMap = imageMapObject != null && imageMapObject instanceof String && ((String)imageMapObject).length() > 0;
            if (hasImageMap) {
                this.createImageMap((String)imageMapObject, imageArea);
            }
        }

        private void createImageMap(String imageMapObject, IImageArea imageArea) {
            String[] maps;
            if (imageMapObject == null) {
                return;
            }
            String[] stringArray = maps = imageMapObject.split("/>");
            int n = maps.length;
            int n2 = 0;
            while (n2 < n) {
                String map = stringArray[n2];
                if ((map = map.trim()).length() != 0) {
                    TreeMap<String, String> attributes = new TreeMap<String, String>();
                    Matcher matcher = pattern.matcher(map);
                    while (matcher.find()) {
                        attributes.put(matcher.group(1), matcher.group(2));
                    }
                    try {
                        int[] area;
                        if (attributes.size() > 0 && (area = this.getArea((String)attributes.get("coords"))) != null) {
                            String url = (String)attributes.get("href");
                            if (url != null && url.startsWith("javascript:")) {
                                url = null;
                            }
                            String targetWindow = (String)attributes.get("target");
                            this.createImageMap(area, imageArea, url, targetWindow);
                        }
                    }
                    catch (NumberFormatException e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                ++n2;
            }
        }

        private void createImageMap(int[] area, IImageArea imageArea, String url, String targetWindow) {
            if (url == null || url.length() == 0) {
                return;
            }
            url = url.replace("&amp;", "&");
            ActionContent link = new ActionContent();
            String bookmark = this.getBookmark(url);
            if (bookmark != null) {
                link.setBookmark(bookmark);
            } else {
                link.setHyperlink(url, targetWindow);
            }
            area = this.getAbsoluteArea(area, imageArea);
            this.createImageMapContainer(area[0], area[1], area[2], area[3], link);
        }

        private void createImageMapContainer(int x, int y, int width, int height, IHyperlinkAction link) {
            BlockContainerArea area = new BlockContainerArea();
            area.setAction(link);
            area.setPosition(x, y);
            area.setWidth(width);
            area.setHeight(height);
            this.root.addChild(area);
        }

        private int[] getAbsoluteArea(int[] area, IImageArea imageArea) {
            int[] result = new int[4];
            if (this.intrinsic == null) {
                int imageX = imageArea.getX();
                int imageY = imageArea.getY();
                result[0] = imageX + area[0] * 1000;
                result[2] = area[2] * 1000;
                result[1] = imageY + area[1] * 1000;
                result[3] = area[3] * 1000;
            } else {
                int i = 0;
                while (i < 4) {
                    area[i] = this.getTranslatedLengthX(area[i]);
                    area[++i] = this.getTranslatedLengthY(area[i]);
                    ++i;
                }
                int imageX = imageArea.getX();
                int imageY = imageArea.getY();
                int imageHeight = imageArea.getHeight();
                int imageWidth = imageArea.getWidth();
                int intrinsicWidth = this.intrinsic.getWidth();
                int intrinsicHeight = this.intrinsic.getHeight();
                float ratio = (float)imageWidth / (float)intrinsicWidth;
                result[0] = imageX + (int)((float)area[0] * ratio);
                result[2] = (int)((float)area[2] * ratio);
                ratio = (float)imageHeight / (float)intrinsicHeight;
                result[1] = imageY + (int)((float)area[1] * ratio);
                result[3] = (int)((float)area[3] * ratio);
            }
            return result;
        }

        private int[] getArea(String string) {
            if (string == null) {
                return null;
            }
            String[] rawDatas = string.split(",");
            if (rawDatas.length == 8) {
                int[] area;
                area = new int[]{Integer.parseInt(rawDatas[0]), Integer.parseInt(rawDatas[1]), Integer.parseInt(rawDatas[4]) - area[0], Integer.parseInt(rawDatas[5]) - area[1]};
                return area;
            }
            if (rawDatas.length >= 6) {
                return this.generateRectangleByPolygon(rawDatas);
            }
            return null;
        }

        private int[] generateRectangleByPolygon(String[] values) {
            int[] intValues = this.convertToInt(values);
            int[] xValues = new int[values.length / 2];
            int i = 0;
            while (i < values.length) {
                xValues[i / 2] = intValues[i];
                i += 2;
            }
            int[] yValues = new int[values.length / 2];
            int i2 = 1;
            while (i2 < values.length) {
                yValues[i2 / 2] = intValues[i2];
                i2 += 2;
            }
            int maxX = this.getMax(xValues);
            int maxY = this.getMax(yValues);
            int minX = this.getMin(xValues);
            int minY = this.getMin(yValues);
            int avaX = this.getAva(xValues);
            int avaY = this.getAva(yValues);
            return new int[]{avaX - (avaX - minX) / 2, avaY - (avaY - minY) / 2, (maxX - minX) / 2, (maxY - minY) / 2};
        }

        private int getMax(int[] values) {
            int max = Integer.MIN_VALUE;
            int i = 0;
            while (i < values.length) {
                if (values[i] > max) {
                    max = values[i];
                }
                ++i;
            }
            return max;
        }

        private int getAva(int[] values) {
            int total = 0;
            int i = 0;
            while (i < values.length) {
                total += values[i];
                ++i;
            }
            return total / values.length;
        }

        private int getMin(int[] values) {
            int min = Integer.MAX_VALUE;
            int i = 0;
            while (i < values.length) {
                if (values[i] < min) {
                    min = values[i];
                }
                ++i;
            }
            return min;
        }

        private int[] convertToInt(String[] values) {
            int[] intValues = new int[values.length];
            int i = 0;
            while (i < values.length) {
                intValues[i] = Integer.parseInt(values[i]);
                ++i;
            }
            return intValues;
        }

        private int getTranslatedLengthX(int length) {
            return length * 1000 / this.resolutionX * 72;
        }

        private int getTranslatedLengthY(int length) {
            return length * 1000 / this.resolutionY * 72;
        }

        private String getBookmark(String url) {
            int start = url.indexOf(BOOKMARK_URL_PREFIX);
            int end = -1;
            if (start != -1) {
                end = url.indexOf("&", start += BOOKMARK_URL_PREFIX.length());
                if (end == -1) {
                    end = url.length();
                }
                return url.substring(start, end);
            }
            if (url.startsWith(BOOKMARK_ANCHOR_PREFIX)) {
                start = BOOKMARK_ANCHOR_PREFIX.length();
                end = url.length();
                return url.substring(start, end);
            }
            if (url.startsWith(BOOKMARK_JAVASCRIPT_PREFIX) && url.endsWith("')")) {
                start = BOOKMARK_JAVASCRIPT_PREFIX.length();
                end = url.length() - 2;
                return url.substring(start, end);
            }
            return null;
        }

        protected void close() {
        }
    }
}

