/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.rules;

import java.util.AbstractCollection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.sse.ui.internal.Logger;

class PresentationCollector
extends AbstractCollection {
    private final TextPresentation fPresentation;
    private int lastOffset;

    PresentationCollector(TextPresentation presentation) {
        Assert.isNotNull((Object)presentation);
        this.fPresentation = presentation;
        this.lastOffset = 0;
    }

    @Override
    public boolean add(Object o) {
        StyleRange range = (StyleRange)o;
        if (this.lastOffset > range.start) {
            Logger.log(4, "Overlapping start in StyleRange " + range.start + ":" + range.length);
            return false;
        }
        if (range.length < 0) {
            Logger.log(4, "StyleRange with negative length" + range.start + ":" + range.length);
            return false;
        }
        this.lastOffset = range.start + range.length;
        this.fPresentation.addStyleRange(range);
        return true;
    }

    @Override
    public Iterator iterator() {
        return this.fPresentation.getNonDefaultStyleRangeIterator();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }
}

