/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.nls.AvailableFilter;
import org.eclipse.pde.internal.ui.nls.InternationalizationWizardPage;
import org.eclipse.pde.internal.ui.nls.InternationalizeModelTable;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.WorkbenchJob;

public class InternationalizeWizardLocalePage
extends InternationalizationWizardPage
implements IModelProviderListener {
    public static final String PAGE_NAME = "InternationalizeWizardLocalePage";
    protected Locale[] fModels = new Locale[0];
    private String fLocation;
    protected TableViewer fSelectedListViewer;
    private boolean fRefreshNeeded = true;
    private Label fCountLabel;
    private TableViewer fAvailableListViewer;
    private WorkbenchJob fFilterJob;
    private Text fFilterText;
    private AvailableFilter fFilter;
    private Set<Object> fSelected;
    private boolean fBlockSelectionListeners;
    private Button fAddButton;
    private Button fAddAllButton;
    private Button fRemoveButton;
    private Button fRemoveAllButton;
    private InternationalizeModelTable<Locale> fInternationalizeModelTable;
    private ILabelProvider fLabelProvider = PDEPlugin.getDefault().getLabelProvider();

    public InternationalizeWizardLocalePage(InternationalizeModelTable<Locale> modelTable, String pageName) {
        super(pageName);
        this.setTitle(PDEUIMessages.InternationalizeWizard_LocalePage_pageTitle);
        this.setDescription(PDEUIMessages.InternationalizeWizard_LocalePage_pageDescription);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        PDECore.getDefault().getModelManager().getExternalModelManager().addModelProviderListener((IModelProviderListener)this);
        this.fInternationalizeModelTable = modelTable;
        this.fSelected = new HashSet<Object>();
        IWizardContainer container = this.getContainer();
        if (container != null) {
            container.updateButtons();
        }
    }

    private void addFilter() {
        this.fFilter = new AvailableFilter(this.fSelected, this.fLabelProvider);
        this.fAvailableListViewer.addFilter((ViewerFilter)this.fFilter);
        this.fFilterJob = new WorkbenchJob("FilterJob"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                InternationalizeWizardLocalePage.this.handleFilter();
                return Status.OK_STATUS;
            }
        };
        this.fFilterJob.setSystem(true);
    }

    private void handleFilter() {
        boolean changed;
        String newFilter;
        if (this.fFilterText == null || (newFilter = this.fFilterText.getText().trim()).length() == 0) {
            newFilter = "*";
        }
        if (changed = this.fFilter.setPattern(newFilter)) {
            this.fAvailableListViewer.getTable().setRedraw(false);
            this.fAvailableListViewer.refresh();
            this.fAvailableListViewer.getTable().setRedraw(true);
            this.updateButtonEnablement(false, false);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 20;
        container.setLayout((Layout)layout);
        this.createScrollArea(container);
        this.createAvailableList(container).setLayoutData((Object)new GridData(1808));
        this.createButtonArea(container);
        this.createLocaleList(container).setLayoutData((Object)new GridData(1808));
        this.updateCount();
        this.addViewerListeners();
        this.addFilter();
        this.initialize();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    protected Composite createLocaleList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.InternationalizeWizard_LocalePage_internationalizeList);
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.fSelectedListViewer = new TableViewer(table);
        this.fSelectedListViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fSelectedListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fSelectedListViewer.setComparator(ListUtil.NAME_COMPARATOR);
        return container;
    }

    protected boolean isRefreshNeeded() {
        if (this.fRefreshNeeded) {
            this.fRefreshNeeded = false;
            return true;
        }
        return this.fLocation == null;
    }

    protected void addLocale(Locale model, ArrayList<Locale> selected) {
        if (!selected.contains(model)) {
            selected.add(model);
        }
    }

    public List<Locale> getLocalesForInternationalization() {
        return InternationalizeWizardLocalePage.getModels(this.fSelectedListViewer, Locale.class);
    }

    public void storeSettings() {
    }

    public void modelsChanged(IModelProviderEvent event) {
        this.fRefreshNeeded = true;
    }

    private void initialize() {
        this.updateButtonEnablement(true, true);
        this.setPageComplete(false);
    }

    private void addViewerListeners() {
        this.fAvailableListViewer.addDoubleClickListener(event -> this.handleAdd());
        this.fSelectedListViewer.addDoubleClickListener(event -> this.handleRemove());
        this.fAvailableListViewer.addSelectionChangedListener(event -> {
            if (!this.fBlockSelectionListeners) {
                this.updateSelectionBasedEnablement(event.getSelection(), true);
            }
        });
        this.fSelectedListViewer.addSelectionChangedListener(event -> {
            if (!this.fBlockSelectionListeners) {
                this.updateSelectionBasedEnablement(event.getSelection(), false);
            }
        });
        this.fFilterText.addModifyListener(e -> {
            this.fFilterJob.cancel();
            this.fFilterJob.schedule(200L);
        });
    }

    private Composite createAvailableList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData());
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.InternationalizeWizard_LocalePage_availableList);
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        gd.heightHint = 400;
        table.setLayoutData((Object)gd);
        this.fAvailableListViewer = new TableViewer(table);
        this.fAvailableListViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fAvailableListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fAvailableListViewer.setInput(this.fInternationalizeModelTable);
        this.fAvailableListViewer.setComparator(ListUtil.NAME_COMPARATOR);
        return container;
    }

    private Composite createButtonArea(Composite parent) {
        ScrolledComposite comp = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayoutData((Object)new GridData(1040));
        Composite container = new Composite((Composite)comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginTop = 50;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1040);
        gd.verticalIndent = 15;
        container.setLayoutData((Object)gd);
        this.fAddButton = new Button(container, 8);
        this.fAddButton.setText(PDEUIMessages.ImportWizard_DetailedPage_add);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        this.fAddButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAdd()));
        SWTUtil.setButtonDimensionHint(this.fAddButton);
        this.fAddAllButton = new Button(container, 8);
        this.fAddAllButton.setText(PDEUIMessages.ImportWizard_DetailedPage_addAll);
        this.fAddAllButton.setLayoutData((Object)new GridData(768));
        this.fAddAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAddAll()));
        SWTUtil.setButtonDimensionHint(this.fAddAllButton);
        this.fRemoveButton = new Button(container, 8);
        this.fRemoveButton.setText(PDEUIMessages.ImportWizard_DetailedPage_remove);
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        this.fRemoveButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemove()));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveAllButton = new Button(container, 8);
        this.fRemoveAllButton.setText(PDEUIMessages.ImportWizard_DetailedPage_removeAll);
        this.fRemoveAllButton.setLayoutData((Object)new GridData(768));
        this.fRemoveAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemoveAll()));
        SWTUtil.setButtonDimensionHint(this.fRemoveAllButton);
        this.fCountLabel = new Label(container, 0);
        this.fCountLabel.setLayoutData((Object)new GridData(64));
        comp.setContent((Control)container);
        comp.setMinHeight(250);
        comp.setExpandHorizontal(true);
        comp.setExpandVertical(true);
        return container;
    }

    private Composite createScrollArea(Composite parent) {
        Group container = this.createFilterContainer(parent, PDEUIMessages.InternationalizeWizard_LocalePage_filter, PDEUIMessages.ImportWizard_DetailedPage_search);
        this.fFilterText = this.createFilterText((Composite)container, "");
        return container;
    }

    protected void refreshPage() {
        this.fSelectedListViewer.getTable().removeAll();
        this.fSelected = new HashSet<Object>();
        this.fAvailableListViewer.refresh();
        this.pageChanged();
    }

    protected void pageChanged() {
        this.pageChanged(false, false);
    }

    protected void pageChanged(boolean doAddEnablement, boolean doRemoveEnablement) {
        if (this.fSelectedListViewer.getTable().getItemCount() == 0) {
            this.setErrorMessage(PDEUIMessages.InternationalizeWizard_LocalePage_selectionError);
        } else {
            this.setErrorMessage(null);
        }
        this.updateCount();
        this.updateButtonEnablement(doAddEnablement, doRemoveEnablement);
        this.setPageComplete(this.fSelectedListViewer.getTable().getItemCount() > 0);
    }

    private void updateCount() {
        this.fCountLabel.setText(NLS.bind((String)PDEUIMessages.ImportWizard_DetailedPage_count, (Object)Integer.toString(this.fSelectedListViewer.getTable().getItemCount()), (Object)Integer.toString(this.fAvailableListViewer.getTable().getItemCount() + this.fSelectedListViewer.getTable().getItemCount())));
        this.fCountLabel.getParent().layout();
    }

    private void updateButtonEnablement(boolean doAddEnablement, boolean doRemoveEnablement) {
        int availableCount = this.fAvailableListViewer.getTable().getItemCount();
        int importCount = this.fSelectedListViewer.getTable().getItemCount();
        if (doAddEnablement) {
            this.updateSelectionBasedEnablement((ISelection)this.fAvailableListViewer.getStructuredSelection(), true);
        }
        if (doRemoveEnablement) {
            this.updateSelectionBasedEnablement((ISelection)this.fSelectedListViewer.getStructuredSelection(), false);
        }
        this.fAddAllButton.setEnabled(availableCount > 0);
        this.fRemoveAllButton.setEnabled(importCount > 0);
    }

    private void updateSelectionBasedEnablement(ISelection theSelection, boolean available) {
        if (available) {
            this.fAddButton.setEnabled(!theSelection.isEmpty());
        } else {
            this.fRemoveButton.setEnabled(!theSelection.isEmpty());
        }
    }

    private void handleAdd() {
        Iterator<Locale> selectedLocals = InternationalizeWizardLocalePage.getSelectedModels(this.fAvailableListViewer, Locale.class);
        if (selectedLocals.hasNext()) {
            Table table = this.fAvailableListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            selectedLocals.forEachRemaining(this::doAdd);
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged(true, false);
        }
    }

    private void handleAddAll() {
        List<Locale> data = InternationalizeWizardLocalePage.getModels(this.fAvailableListViewer, Locale.class);
        if (!data.isEmpty()) {
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            for (Locale dataObject : data) {
                this.doAdd(dataObject);
            }
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            this.pageChanged(true, false);
        }
    }

    private void handleRemove() {
        Iterator<Locale> selectedLocals = InternationalizeWizardLocalePage.getSelectedModels(this.fSelectedListViewer, Locale.class);
        if (selectedLocals.hasNext()) {
            Table table = this.fSelectedListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            selectedLocals.forEachRemaining(this::doRemove);
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged(false, true);
        }
    }

    private void doAdd(Locale o) {
        this.fInternationalizeModelTable.removeModel(o);
        this.fSelectedListViewer.add((Object)o);
        this.fAvailableListViewer.remove((Object)o);
        this.fSelected.add(o);
    }

    private void doRemove(Locale o) {
        this.fInternationalizeModelTable.addModel(o);
        this.fSelected.remove(o);
        this.fSelectedListViewer.remove((Object)o);
        this.fAvailableListViewer.add((Object)o);
    }

    private void setRedraw(boolean redraw) {
        this.fAvailableListViewer.getTable().setRedraw(redraw);
        this.fSelectedListViewer.getTable().setRedraw(redraw);
    }

    private void handleRemoveAll() {
        List<Locale> data = InternationalizeWizardLocalePage.getModels(this.fSelectedListViewer, Locale.class);
        if (!data.isEmpty()) {
            this.setBlockSelectionListeners(true);
            this.setRedraw(false);
            for (Locale dataObject : data) {
                this.doRemove(dataObject);
            }
            this.setRedraw(true);
            this.setBlockSelectionListeners(false);
            this.pageChanged(false, true);
        }
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        PDECore.getDefault().getModelManager().getExternalModelManager().removeModelProviderListener((IModelProviderListener)this);
    }

    private void setBlockSelectionListeners(boolean blockSelectionListeners) {
        this.fBlockSelectionListeners = blockSelectionListeners;
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((InternationalizeModelTable)inputElement).getModels();
        }
    }
}

