/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.io.File;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunReportActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class BirtGetReportletActionHandler
extends AbstractBaseActionHandler {
    protected BaseAttributeBean __bean;
    protected String __reportDesignName;
    protected String __docName;
    protected String __reportletId;
    OutputStream os = null;

    public BirtGetReportletActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response, OutputStream os) {
        super(context, operation, response);
        this.os = os;
    }

    @Override
    protected void __execute() throws Exception {
        this.prepareParameters();
        this.doExecution();
        this.prepareResponse();
    }

    protected void prepareParameters() throws Exception, RemoteException {
        this.__bean = this.context.getBean();
        this.__reportDesignName = this.__bean.getReportDesignName();
        this.__docName = this.__bean.getReportDocumentName();
        this.__reportletId = this.__bean.getReportletId();
        if (this.__docName == null && this.__reportDesignName != null) {
            this.__docName = ParameterAccessor.getReportDocument(this.context.getRequest(), null, true);
            this.__bean.setReportDocumentName(this.__docName);
        }
        this.__checkDocumentExists();
    }

    protected void doExecution() throws ReportServiceException, RemoteException {
        Oprand[] operand = null;
        if (this.operation != null) {
            operand = this.operation.getOprand();
        }
        boolean svgFlag = this.getSVGFlag(operand);
        InputOptions options = this.createInputOptions(this.__bean, svgFlag);
        ArrayList activeIds = new ArrayList();
        this.getReportService().renderReportlet(this.__docName, this.__reportletId, options, activeIds, this.os);
    }

    protected void __checkDocumentExists() throws Exception {
        File file = new File(this.__docName);
        if (!file.exists()) {
            BirtRunReportActionHandler handler = new BirtRunReportActionHandler(this.context, this.operation, this.response);
            handler.__execute();
        }
        if (!(file = new File(this.__docName)).exists()) {
            AxisFault fault = new AxisFault();
            fault.setFaultReason(BirtResources.getMessage("birt.viewer.actionException.NO_REPORT_DOCUMENT"));
            throw fault;
        }
    }

    protected void prepareResponse() throws ReportServiceException, RemoteException {
    }

    @Override
    public IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }
}

