/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.core.util.LocaleUtil;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.IProgressMonitor;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IStatusHandler;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.UnsupportedFormatException;
import org.eclipse.birt.report.engine.api.impl.EngineLogger;
import org.eclipse.birt.report.engine.api.impl.IInternalReportDocument;
import org.eclipse.birt.report.engine.api.impl.ParameterValidationException;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ScriptedDesignHandler;
import org.eclipse.birt.report.engine.api.impl.ScriptedDesignSearcher;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.css.dom.AbstractStyle;
import org.eclipse.birt.report.engine.data.dte.DocumentDataSource;
import org.eclipse.birt.report.engine.emitter.EngineEmitterServices;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.executor.ReportExtensionExecutor;
import org.eclipse.birt.report.engine.extension.engine.IContentProcessor;
import org.eclipse.birt.report.engine.extension.engine.IGenerateExtension;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v3.ReportContentReaderV3;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.LayoutEngineFactory;
import org.eclipse.birt.report.engine.script.internal.ReportContextImpl;
import org.eclipse.birt.report.engine.script.internal.ReportScriptExecutor;
import org.eclipse.birt.report.engine.util.ResourceLocatorWrapper;
import org.eclipse.birt.report.engine.util.SecurityUtil;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DynamicFilterParameterHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.IncludeScriptHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.elements.ScalarParameter;

public abstract class EngineTask
implements IEngineTask {
    public static final String TASK_TYPE = "task_type";
    private static int id = 0;
    protected String pagination;
    protected static final String FORMAT_HTML = "html";
    protected static final String FORMAT_XHTML = "xhtml";
    protected boolean cancelFlag;
    protected EngineException fatalError = null;
    protected int runningStatus;
    protected ReportEngine engine;
    protected Logger log;
    protected ULocale ulocale = ULocale.getDefault();
    protected TimeZone timeZone = TimeZone.getDefault();
    protected ExecutionContext executionContext;
    protected int taskID;
    protected IRenderOption renderOptions;
    protected String emitterID;
    protected String format;
    protected boolean parameterChanged = true;
    protected HashMap inputValues = new HashMap();
    protected HashMap runValues = new HashMap();
    protected HashMap defaultValues = new HashMap();
    protected int taskType = -1;
    private Object platformContext;
    protected IPageHandler pageHandler;
    protected IProgressMonitor progressMonitor;
    protected IStatusHandler statusHandler;
    protected String[] userAcls;
    protected String cancelReason;
    private ResourceLocatorWrapper resourceLocator;
    protected IDocArchiveReader dataSource;
    private String dataSourceReportlet;

    protected EngineTask(ReportEngine engine, IReportRunnable runnable, int taskType) {
        this(engine, taskType);
        this.setReportRunnable(runnable);
    }

    protected EngineTask(ReportEngine engine, int taskType) {
        this.engine = engine;
        this.taskType = taskType;
        this.taskID = id++;
        this.log = engine.getLogger();
        this.setupExecutionContext();
        this.setAppContext(null);
        this.cancelFlag = false;
        this.resourceLocator = new ResourceLocatorWrapper();
        this.runningStatus = 0;
    }

    protected void setupExecutionContext() {
        this.executionContext = new ExecutionContext(this);
        this.executionContext.setReportContext(new ReportContextImpl(this.executionContext));
    }

    protected IReportRunnable getOnPreparedRunnable(IReportDocument doc) {
        IInternalReportDocument internalReportDoc = (IInternalReportDocument)doc;
        return internalReportDoc.getOnPreparedRunnable();
    }

    @Override
    public Locale getLocale() {
        return this.ulocale.toLocale();
    }

    @Override
    public ULocale getULocale() {
        return this.ulocale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.log.log(Level.FINE, "EngineTask.setLocale: locale={0}", locale.getDisplayName());
        this.doSetLocale(LocaleUtil.forLocale((Locale)locale));
    }

    private void doSetLocale(ULocale locale) {
        this.ulocale = locale;
        this.executionContext.setLocale(this.ulocale);
        EngineException.setULocale(this.ulocale);
    }

    @Override
    public void setLocale(ULocale ulocale) {
        if (ulocale == null) {
            throw new NullPointerException();
        }
        this.log.log(Level.FINE, "EngineTask.setLocale: uLocale={0}", ulocale.getDisplayName());
        this.doSetLocale(ulocale);
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException();
        }
        this.timeZone = timeZone;
        this.executionContext.setTimeZone(timeZone);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setAppContext(Map context) {
        HashMap<String, Object> appContext = new HashMap<String, Object>();
        HashMap sysAppContext = this.engine.getConfig().getAppContext();
        if (sysAppContext != null) {
            appContext.putAll(sysAppContext);
        }
        this.addAppContext(context, appContext);
        if (this.userAcls != null) {
            appContext.put("USER_ACL", this.userAcls);
        }
        appContext.put("EngineTask", this);
        this.executionContext.setAppContext(appContext);
        StringBuffer logStr = null;
        if (this.log.isLoggable(Level.FINE)) {
            logStr = new StringBuffer();
        }
        if (!appContext.isEmpty()) {
            Set entries = appContext.entrySet();
            for (Map.Entry entry : entries) {
                if (entry.getKey() instanceof String) {
                    this.executionContext.registerBean((String)entry.getKey(), entry.getValue());
                    if (logStr == null) continue;
                    logStr.append(entry.getKey());
                    logStr.append("=");
                    logStr.append(entry.getValue());
                    logStr.append(";");
                    continue;
                }
                this.log.log(Level.WARNING, "Map entry {0} is invalid and ignored, because its key is a not string.", entry.getKey().toString());
            }
        }
        if (logStr != null) {
            this.log.log(Level.FINE, "EngineTask.setAppContext: context={0}", logStr);
        }
    }

    private void addAppContext(Map from, Map to) {
        if (from == null || to == null) {
            return;
        }
        for (Map.Entry entry : from.entrySet()) {
            if (this.isDeprecatedEntry(entry)) continue;
            to.put(entry.getKey(), entry.getValue());
        }
    }

    private boolean isDeprecatedEntry(Map.Entry entry) {
        Object key = entry.getKey();
        if (("PARENT_CLASSLOADER".equals(key) || "webapplication.projectclasspath".equals(key) || "user.projectclasspath".equals(key) || "workspace.projectclasspath".equals(key)) && entry.getValue() != this.getAppContext().get(key)) {
            this.log.log(Level.WARNING, key + " could not be set in appContext of IEngineTask, please set it in appContext of IReportEngine");
            return true;
        }
        return false;
    }

    @Override
    public Map getAppContext() {
        return this.executionContext.getAppContext();
    }

    @Override
    public IReportEngine getEngine() {
        return this.engine;
    }

    public void setReportRunnable(IReportRunnable runnable) {
        if (runnable != null) {
            Properties systemProperties = SecurityUtil.getSystemProperties();
            this.executionContext.setRunnable(runnable);
            this.executionContext.registerBeans(systemProperties);
            this.executionContext.registerBeans(runnable.getTestConfig());
            this.executionContext.getConfigs().putAll(systemProperties);
            this.executionContext.getConfigs().putAll(runnable.getTestConfig());
        }
    }

    @Override
    public IReportRunnable getReportRunnable() {
        return this.executionContext.getOriginalRunnable();
    }

    public void setRenderOption(IRenderOption options) {
        if (options == null) {
            throw new NullPointerException("options can not be null");
        }
        this.renderOptions = options;
    }

    public IRenderOption getRenderOption() {
        return this.renderOptions;
    }

    @Deprecated
    public void setEmitterID(String id) {
        this.emitterID = id;
    }

    @Deprecated
    public String getEmitterID() {
        return this.emitterID;
    }

    public DataRequestSession getDataSession() throws EngineException {
        return this.executionContext.getDataEngine().getDTESession();
    }

    @Override
    public void addScriptableJavaObject(String jsName, Object obj) {
        this.executionContext.registerBean(jsName, obj);
    }

    @Override
    public int getID() {
        return this.taskID;
    }

    protected Object convertToType(Object value, String type) {
        try {
            return EngineTask.convertParameterType(value, type);
        }
        catch (BirtException e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static Object convertParameterType(Object value, String type) throws BirtException {
        if ("boolean".equals(type)) {
            return DataTypeUtil.toBoolean((Object)value);
        }
        if ("dateTime".equals(type)) {
            return DataTypeUtil.toDate((Object)value);
        }
        if ("date".equals(type)) {
            return DataTypeUtil.toSqlDate((Object)value);
        }
        if ("time".equals(type)) {
            return DataTypeUtil.toSqlTime((Object)value);
        }
        if ("decimal".equals(type)) {
            return DataTypeUtil.toBigDecimal((Object)value);
        }
        if ("float".equals(type)) {
            return DataTypeUtil.toDouble((Object)value);
        }
        if ("string".equals(type)) {
            return DataTypeUtil.toLocaleNeutralString((Object)value);
        }
        if ("integer".equals(type)) {
            return DataTypeUtil.toInteger((Object)value);
        }
        return value;
    }

    @Override
    public boolean validateParameters() {
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable == null) {
            return false;
        }
        try {
            return this.doValidateParameters();
        }
        catch (ParameterValidationException ex) {
            this.log.log(Level.SEVERE, ex.getMessage(), (Throwable)((Object)ex));
            return false;
        }
    }

    protected boolean doValidateParameters() throws ParameterValidationException {
        this.usingParameterValues();
        if (this.log.isLoggable(Level.FINE)) {
            this.loggerParamters();
        }
        ParameterValidationVisitor pv = new ParameterValidationVisitor();
        boolean result = pv.visit(this.executionContext.getDesign(), null, this.executionContext);
        if (pv.engineException != null) {
            throw pv.engineException;
        }
        return result;
    }

    protected void loggerParamters() {
        if (this.log.isLoggable(Level.FINE)) {
            final StringBuffer buffer = new StringBuffer();
            new ParameterVisitor(){

                @Override
                boolean visitScalarParameter(ScalarParameterHandle param, Object value) {
                    String paramName = param.getName();
                    Object paramValue = EngineTask.this.runValues.get(paramName);
                    buffer.append(paramName);
                    buffer.append(":");
                    buffer.append(paramValue);
                    buffer.append("\n");
                    return true;
                }

                @Override
                boolean visitDynamicFilterParameter(DynamicFilterParameterHandle param, Object userData) {
                    String paramName = param.getName();
                    Object paramValue = EngineTask.this.runValues.get(paramName);
                    buffer.append(paramName);
                    buffer.append(":");
                    buffer.append(paramValue);
                    buffer.append("\n");
                    return true;
                }

                @Override
                boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
                    return this.visitParametersInGroup(group, value);
                }
            }.visit(this.executionContext.getDesign(), null, this.executionContext);
            this.log.log(Level.FINE, "Running the report with paramters: {0}", buffer);
        }
    }

    private boolean validateAbstractScalarParameter(AbstractScalarParameterHandle paramHandle) throws ParameterValidationException {
        String paramName = paramHandle.getName();
        Object paramValue = this.runValues.get(paramName);
        if (paramValue == null) {
            if (!paramHandle.isRequired()) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterValueIsNull", new String[]{paramName});
        }
        String source = paramHandle.getValidate();
        if (source != null && source.length() != 0) {
            try {
                Object result = this.executionContext.evaluate(source);
                if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) {
                    throw new ParameterValidationException("Error.ParamValidationFailure", new String[]{paramName});
                }
            }
            catch (ParameterValidationException pve) {
                throw pve;
            }
            catch (BirtException ex) {
                throw new ParameterValidationException(ex);
            }
        }
        if (paramHandle instanceof ScalarParameterHandle) {
            ScalarParameterHandle sparam = (ScalarParameterHandle)paramHandle;
            String type = paramHandle.getDataType();
            String paramType = sparam.getParamType();
            if ("multi-value".equals(paramType)) {
                if (paramValue instanceof Object[]) {
                    boolean isValid = true;
                    Object[] paramValueList = (Object[])paramValue;
                    int i = 0;
                    while (i < paramValueList.length) {
                        if (paramValueList[i] != null && !this.validateParameterValueType(paramName, paramValueList[i], type, (AbstractScalarParameterHandle)sparam)) {
                            isValid = false;
                        }
                        ++i;
                    }
                    return isValid;
                }
                throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, "Object[]", paramValue.getClass().getName()});
            }
            return this.validateParameterValueType(paramName, paramValue, type, paramHandle);
        }
        if (paramHandle instanceof DynamicFilterParameterHandle) {
            return this.validateParameterValueType(paramName, paramValue, "string", paramHandle);
        }
        return false;
    }

    private boolean validateParameterValueType(String paramName, Object paramValue, String type, AbstractScalarParameterHandle paramHandle) throws ParameterValidationException {
        if ("decimal".equals(type) || "float".equals(type)) {
            if (paramValue instanceof Number) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
        }
        if ("dateTime".equals(type)) {
            if (paramValue instanceof Date) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
        }
        if ("date".equals(type)) {
            if (paramValue instanceof java.sql.Date) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
        }
        if ("time".equals(type)) {
            if (paramValue instanceof Time) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
        }
        if ("string".equals(type)) {
            if (!(paramValue instanceof String)) {
                throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
            }
            this.validateStringParameter(paramName, paramValue, paramHandle);
            return true;
        }
        if ("boolean".equals(type)) {
            if (paramValue instanceof Boolean) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
        }
        if ("integer".equals(type)) {
            if (paramValue instanceof Integer) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
        }
        return true;
    }

    protected void validateStringParameter(String paramName, Object paramValue, AbstractScalarParameterHandle paramHandle) throws ParameterValidationException {
        String value;
        if (paramHandle.isRequired() && (value = paramValue.toString().trim()).length() == 0) {
            throw new ParameterValidationException("Error.ParameterValueIsBlank", new String[]{paramName});
        }
    }

    @Override
    public void setParameterValues(Map params) {
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.setParameterValue(name, value);
        }
    }

    protected void setParameters(Map<String, ParameterAttribute> parameters) {
        for (Map.Entry<String, ParameterAttribute> entry : parameters.entrySet()) {
            this.inputValues.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setParameterValue(String name, Object value) {
        this.log.log(Level.FINE, "EngineTask.setParameterValue: {0}={1} [{2}]", new Object[]{name, value, value == null ? null : value.getClass().getName()});
        this.parameterChanged = true;
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            assert (parameter instanceof ParameterAttribute);
            ((ParameterAttribute)parameter).setValue(value);
        } else {
            this.inputValues.put(name, new ParameterAttribute(value, null));
        }
    }

    @Override
    public void setParameterValue(String name, Object[] values) {
        this.log.log(Level.FINE, "EngineTask.setParameterValue: {0}={1} [{2}]", new Object[]{name, values, values == null ? null : values.getClass().getName()});
        this.parameterChanged = true;
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            assert (parameter instanceof ParameterAttribute);
            ((ParameterAttribute)parameter).setValue((Object)values);
        } else {
            this.inputValues.put(name, new ParameterAttribute(values, new String[1]));
        }
    }

    public void setValue(String name, Object value) {
        this.setParameterValue(name, value);
    }

    public void setValue(String name, Object[] values) {
        this.setParameterValue(name, values);
    }

    @Override
    public HashMap getParameterValues() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.inputValues.entrySet()) {
            ParameterAttribute parameter = (ParameterAttribute)entry.getValue();
            result.put(entry.getKey(), parameter.getValue());
        }
        return result;
    }

    @Override
    public Object getParameterValue(String name) {
        Object parameter = this.inputValues.get(name);
        if (parameter == null) {
            return null;
        }
        assert (parameter instanceof ParameterAttribute);
        return ((ParameterAttribute)parameter).getValue();
    }

    @Override
    public void setParameter(String name, Object value, String displayText) {
        this.parameterChanged = true;
        this.inputValues.put(name, new ParameterAttribute(value, displayText));
    }

    @Override
    public void setParameter(String name, Object[] values, String[] displayText) {
        this.parameterChanged = true;
        this.inputValues.put(name, new ParameterAttribute(values, displayText));
    }

    @Override
    public Object getParameterDisplayText(String name) {
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            assert (parameter instanceof ParameterAttribute);
            return ((ParameterAttribute)parameter).getDisplayText();
        }
        return null;
    }

    public void setParameterDisplayTexts(Map params) {
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            Object text = entry.getValue();
            if (text == null) continue;
            if (text instanceof String[]) {
                this.setParameterDisplayText(name, (String[])text);
                continue;
            }
            this.setParameterDisplayText(name, text.toString());
        }
    }

    @Override
    public void setParameterDisplayText(String name, String displayText) {
        this.parameterChanged = true;
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            assert (parameter instanceof ParameterAttribute);
            ((ParameterAttribute)parameter).setDisplayText(displayText);
        } else {
            this.inputValues.put(name, new ParameterAttribute(null, displayText));
        }
    }

    @Override
    public void setParameterDisplayText(String name, String[] displayText) {
        this.parameterChanged = true;
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            assert (parameter instanceof ParameterAttribute);
            ((ParameterAttribute)parameter).setDisplayText(displayText);
        } else {
            this.inputValues.put(name, new ParameterAttribute(null, displayText));
        }
    }

    protected Object evaluateDefaultValue(AbstractScalarParameterHandle parameter) {
        String valueExpr;
        String name;
        if (parameter != null && this.defaultValues.containsKey(name = parameter.getName())) {
            return this.defaultValues.get(name);
        }
        ScalarParameterHandle sparameter = null;
        if (parameter instanceof ScalarParameterHandle && (valueExpr = (sparameter = (ScalarParameterHandle)parameter).getDefaultValueListMethod()) != null) {
            Object result;
            block19: {
                result = this.executionContext.evaluate(valueExpr);
                if (result != null) break block19;
                return null;
            }
            try {
                if ("multi-value".equals(sparameter.getParamType())) {
                    ArrayList<Object> results = new ArrayList<Object>();
                    String dataType = sparameter.getDataType();
                    if (result instanceof Collection) {
                        Iterator itr = ((Collection)result).iterator();
                        while (itr.hasNext()) {
                            results.add(this.convertToType(itr.next(), dataType));
                        }
                    } else if (result.getClass().isArray()) {
                        int count = Array.getLength(result);
                        int index = 0;
                        while (index < count) {
                            Object origValue = Array.get(result, index);
                            results.add(this.convertToType(origValue, dataType));
                            ++index;
                        }
                    } else {
                        results.add(this.convertToType(result, dataType));
                    }
                    return results.toArray();
                }
                return this.convertToType(result, sparameter.getDataType());
            }
            catch (BirtException e) {
                this.executionContext.addException(e);
                this.log.log(Level.FINE, e.getLocalizedMessage(), e);
                return null;
            }
        }
        List values = null;
        if (parameter != null) {
            values = parameter.getDefaultValueList();
        }
        if (values == null || values.size() == 0) {
            return null;
        }
        if (sparameter != null) {
            if (!"multi-value".equals(sparameter.getParamType())) {
                Expression expr = (Expression)values.get(0);
                if (expr != null) {
                    return this.evaluateExpression(expr, parameter.getDataType());
                }
                return null;
            }
            ArrayList<Object> results = new ArrayList<Object>();
            for (Expression expr : values) {
                if (expr == null) continue;
                Object value = this.evaluateExpression(expr, parameter.getDataType());
                results.add(value);
            }
            return results.toArray();
        }
        Expression expr = (Expression)values.get(0);
        if (expr != null) {
            return this.evaluateExpression(expr, "string");
        }
        return null;
    }

    private Object evaluateExpression(Expression expr, String type) {
        try {
            org.eclipse.birt.report.engine.ir.Expression irExpr = this.createExpression(expr);
            Object value = this.executionContext.evaluate(irExpr);
            return this.convertToType(value, type);
        }
        catch (BirtException e) {
            this.executionContext.addException(e);
            this.log.log(Level.FINE, e.getLocalizedMessage(), e);
            return null;
        }
    }

    private org.eclipse.birt.report.engine.ir.Expression createExpression(Expression expr) {
        if (expr != null) {
            String type = expr.getType();
            if ("constant".equals(type)) {
                String text = expr.getStringExpression();
                return org.eclipse.birt.report.engine.ir.Expression.newConstant(-1, text);
            }
            String text = expr.getStringExpression();
            if (text != null && (text = text.trim()).length() > 0) {
                return org.eclipse.birt.report.engine.ir.Expression.newScript(type, text);
            }
        }
        return null;
    }

    protected org.eclipse.birt.report.engine.ir.Expression createExpression(ExpressionHandle expressionHandle) {
        if (expressionHandle != null && expressionHandle.isSet()) {
            String type = expressionHandle.getType();
            if ("constant".equals(type)) {
                String text = expressionHandle.getStringExpression();
                return org.eclipse.birt.report.engine.ir.Expression.newConstant(-1, text);
            }
            String text = expressionHandle.getStringExpression();
            if (text != null && (text = text.trim()).length() > 0) {
                return org.eclipse.birt.report.engine.ir.Expression.newScript(type, text);
            }
        }
        return null;
    }

    @Override
    public void cancel() {
        this.cancelFlag = true;
        if (this.executionContext != null) {
            this.executionContext.cancel();
        }
        this.disposeResourceLocator();
        this.changeStatusToStopped();
    }

    @Override
    public void cancel(String reason) {
        this.cancelReason = reason;
        this.cancel();
    }

    @Override
    public boolean getCancelFlag() {
        return this.cancelFlag;
    }

    @Override
    public void setErrorHandlingOption(int option) {
        if (option == 1) {
            this.executionContext.setCancelOnError(true);
        } else {
            this.executionContext.setCancelOnError(false);
        }
    }

    public ResourceLocatorWrapper getResourceLocatorWrapper() {
        return this.resourceLocator;
    }

    protected IQueryResults executeDataSet(DataSetHandle hDataSet, HashMap parameters) {
        return null;
    }

    protected Object refineParameterValue(String name, Object value) {
        return value;
    }

    protected void usingParameterValues() {
        if (!this.parameterChanged) {
            return;
        }
        this.parameterChanged = false;
        this.executionContext.clearParameters();
        this.runValues.clear();
        for (Map.Entry entry : this.inputValues.entrySet()) {
            Object key = entry.getKey();
            ParameterAttribute attribute = (ParameterAttribute)entry.getValue();
            Object value = this.refineParameterValue((String)key, attribute.getValue());
            this.runValues.put(key, value);
            this.executionContext.setParameter((String)key, value, attribute.getDisplayText());
        }
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable == null) {
            return;
        }
        new ParameterVisitor(){

            @Override
            boolean visitScalarParameter(ScalarParameterHandle param, Object userData) {
                String name = param.getName();
                if (!EngineTask.this.inputValues.containsKey(name)) {
                    Object value = EngineTask.this.evaluateDefaultValue((AbstractScalarParameterHandle)param);
                    EngineTask.this.runValues.put(name, value);
                    EngineTask.this.defaultValues.put(name, value);
                    ScalarParameter spd = (ScalarParameter)param.getElement();
                    List selectList = (List)spd.getProperty(param.getModule(), "selectionList");
                    String paramType = (String)spd.getFactoryProperty(param.getModule(), "paramType");
                    if ("multi-value".equals(paramType)) {
                        Object[] values = (Object[])value;
                        ArrayList<String> displayTextList = new ArrayList<String>();
                        if (values != null && selectList != null && selectList.size() > 0) {
                            Object[] objectArray = values;
                            int n = values.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                for (SelectionChoice select : selectList) {
                                    if (o == null) {
                                        if (select.getValue() != null) continue;
                                        displayTextList.add(select.getLabel());
                                        continue;
                                    }
                                    if (!o.equals(select.getValue())) continue;
                                    displayTextList.add(select.getLabel());
                                }
                                ++n2;
                            }
                        }
                        String[] displayTexts = new String[displayTextList.size()];
                        EngineTask.this.executionContext.setParameter(name, value, displayTextList.toArray(displayTexts));
                    } else {
                        String displayText = null;
                        if (selectList != null && selectList.size() > 0) {
                            for (SelectionChoice select : selectList) {
                                if (value == null) {
                                    if (select.getValue() != null) continue;
                                    displayText = select.getLabel();
                                    break;
                                }
                                if (!value.equals(select.getValue())) continue;
                                displayText = select.getLabel();
                                break;
                            }
                        }
                        EngineTask.this.executionContext.setParameter(name, value, displayText);
                    }
                }
                return true;
            }

            @Override
            boolean visitDynamicFilterParameter(DynamicFilterParameterHandle param, Object userData) {
                String name = param.getName();
                if (!EngineTask.this.inputValues.containsKey(name)) {
                    Object value = EngineTask.this.evaluateDefaultValue((AbstractScalarParameterHandle)param);
                    EngineTask.this.executionContext.setParameterValue(name, value);
                    EngineTask.this.runValues.put(name, value);
                    EngineTask.this.defaultValues.put(name, value);
                }
                return true;
            }

            @Override
            boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
                return this.visitParametersInGroup(group, value);
            }
        }.visit((ModuleHandle)runnable.getDesignHandle(), this.executionContext);
    }

    @Override
    public void close() {
        this.executionContext.close();
        this.disposeResourceLocator();
        EngineLogger.setThreadLogger(null);
    }

    private void disposeResourceLocator() {
        if (this.resourceLocator != null) {
            this.resourceLocator.dispose();
            this.resourceLocator = null;
        }
    }

    protected IContentEmitter createContentEmitter() throws EngineException {
        ExtensionManager extManager = ExtensionManager.getInstance();
        this.pagination = extManager.getPagination(this.emitterID);
        IRenderOption executionRenderOptions = this.executionContext.getRenderOption();
        if (!this.renderOptions.hasOption("org.eclipse.birt.report.engine.api.IRenderOption.outputDisplayNone")) {
            Boolean outputDisplayNone = extManager.getOutputDisplayNone(this.emitterID);
            this.renderOptions.setOption("org.eclipse.birt.report.engine.api.IRenderOption.outputDisplayNone", outputDisplayNone);
            executionRenderOptions.setOption("org.eclipse.birt.report.engine.api.IRenderOption.outputDisplayNone", outputDisplayNone);
        }
        if (!this.renderOptions.hasOption("supportedImageFormats")) {
            String supportedImageFormats = extManager.getSupportedImageFormats(this.emitterID);
            this.renderOptions.setOption("supportedImageFormats", supportedImageFormats);
            executionRenderOptions.setOption("supportedImageFormats", supportedImageFormats);
        }
        this.executionContext.setNeedOutputResultSet(extManager.needOutputResultSet(this.emitterID));
        IContentEmitter emitter = null;
        try {
            emitter = extManager.createEmitter(this.emitterID);
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, "Report engine can not create emitter {0}.", this.emitterID);
            throw new EngineException("Error.CannotCreateExtensionInstance", this.emitterID, t);
        }
        if (emitter == null) {
            this.log.log(Level.SEVERE, "Report engine can not create emitter {0}.", this.emitterID);
            throw new EngineException("Error.CannotCreateExtensionInstance", this.emitterID);
        }
        return emitter;
    }

    protected IReportLayoutEngine createReportLayoutEngine(String pagination, IRenderOption options) {
        IReportLayoutEngine layoutEngine = LayoutEngineFactory.createLayoutEngine(pagination);
        if (options != null) {
            Object userAgent;
            Object repaginateForPDF;
            Object reserveDocumentPageNumbers;
            Object dpi;
            Object pdfWordbreak;
            Object pdfFontSubstitution;
            Object pdfTextWrapping;
            Object outputDisplayNone;
            Object pageOverflow;
            Object pagebreakOnly;
            Object fitToPage = this.renderOptions.getOption("pdfRenderOption.fitToPage");
            if (fitToPage != null) {
                layoutEngine.setOption("pdfRenderOption.fitToPage", fitToPage);
            }
            if ((pagebreakOnly = this.renderOptions.getOption("pdfRenderOption.pagebreakPaginationOnly")) != null) {
                layoutEngine.setOption("pdfRenderOption.pagebreakPaginationOnly", pagebreakOnly);
            }
            if ((pageOverflow = this.renderOptions.getOption("pdfRenderOption.pageOverflow")) != null) {
                layoutEngine.setOption("pdfRenderOption.pageOverflow", pageOverflow);
            }
            if ((outputDisplayNone = this.renderOptions.getOption("org.eclipse.birt.report.engine.api.IRenderOption.outputDisplayNone")) != null) {
                layoutEngine.setOption("org.eclipse.birt.report.engine.api.IRenderOption.outputDisplayNone", outputDisplayNone);
            }
            if ((pdfTextWrapping = this.renderOptions.getOption("pdfRenderOption.textWrapping")) != null) {
                layoutEngine.setOption("pdfRenderOption.textWrapping", pdfTextWrapping);
            }
            if ((pdfFontSubstitution = this.renderOptions.getOption("pdfRenderOption.fontSubstitution")) != null) {
                layoutEngine.setOption("pdfRenderOption.fontSubstitution", pdfFontSubstitution);
            }
            layoutEngine.setOption("RTLFlag", this.renderOptions.getOption("RTLFlag"));
            Object pdfBidiProcessing = this.renderOptions.getOption("pdfRenderOption.bidiProcessing");
            if (pdfBidiProcessing != null) {
                layoutEngine.setOption("pdfRenderOption.bidiProcessing", pdfBidiProcessing);
            }
            if ((pdfWordbreak = this.renderOptions.getOption("pdfRenderOption.wordBreak")) != null) {
                layoutEngine.setOption("pdfRenderOption.wordBreak", pdfWordbreak);
            }
            if ((dpi = this.renderOptions.getOption("RenderDpi")) != null) {
                layoutEngine.setOption("RenderDpi", dpi);
            }
            if ((reserveDocumentPageNumbers = this.renderOptions.getOption("pdfRenderOption.reserveDocumentPageNumbers")) != null) {
                layoutEngine.setOption("pdfRenderOption.reserveDocumentPageNumbers", reserveDocumentPageNumbers);
            }
            if ((repaginateForPDF = this.renderOptions.getOption("pdfRenderOption.repaginateForPDF")) != null) {
                layoutEngine.setOption("pdfRenderOption.repaginateForPDF", repaginateForPDF);
            }
            if ((userAgent = this.renderOptions.getOption("user-agent")) != null) {
                layoutEngine.setOption("user-agent", userAgent);
            }
        }
        layoutEngine.setOption(TASK_TYPE, this.taskType);
        return layoutEngine;
    }

    protected void initReportVariable() {
        ReportDesignHandle reportDesign = this.executionContext.getReportDesign();
        if (reportDesign != null) {
            List varElements = reportDesign.getPageVariables();
            for (VariableElementHandle varElement : varElements) {
                String scope = varElement.getType();
                String name = varElement.getVariableName();
                PageVariable var = new PageVariable(name, scope);
                this.executionContext.addPageVariable(var);
                ExpressionHandle exprHandle = varElement.getExpressionProperty("value");
                org.eclipse.birt.report.engine.ir.Expression defaultValue = this.createExpression(exprHandle);
                if (defaultValue == null) continue;
                try {
                    Object value = this.executionContext.evaluate(defaultValue);
                    var.setDefaultValue(value);
                    var.setValue(value);
                }
                catch (BirtException ex) {
                    this.executionContext.addException(ex);
                }
            }
        }
    }

    protected void loadScript(Iterator iter) {
        while (iter.hasNext()) {
            IncludeScriptHandle includeScript = (IncludeScriptHandle)iter.next();
            String language = "javascript";
            String fileName = includeScript.getFileName();
            this.executionContext.loadScript(language, fileName);
        }
    }

    protected void loadScripts() {
        ReportDesignHandle reportDesign;
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable != null && (reportDesign = this.executionContext.getReportDesign()) != null) {
            Iterator iter = reportDesign.includeLibraryScriptsIterator();
            this.loadScript(iter);
            iter = reportDesign.includeScriptsIterator();
            this.loadScript(iter);
        }
    }

    protected void loadDesign() {
        ReportDesignHandle reportDesign;
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable != null && (reportDesign = this.executionContext.getReportDesign()) != null) {
            ReportScriptExecutor.handleInitialize((ModuleHandle)reportDesign, this.executionContext);
        }
    }

    protected void prepareDesign() {
        ReportDesignHandle reportDesign;
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (!runnable.prepared && (reportDesign = this.executionContext.getReportDesign()) != null) {
            ScriptedDesignSearcher searcher = new ScriptedDesignSearcher(reportDesign);
            searcher.apply((DesignElementHandle)reportDesign);
            boolean hasOnprepare = searcher.hasOnPrepareScript();
            if (hasOnprepare) {
                ReportRunnable newRunnable = this.executionContext.getRunnable().cloneRunnable();
                this.executionContext.updateRunnable(newRunnable);
                ReportDesignHandle newDesign = newRunnable.getReport();
                HashMap options = new HashMap(this.getAppContext());
                newDesign.setOptions(options);
                ScriptedDesignHandler visitor = new ScriptedDesignHandler(newDesign, this.executionContext);
                visitor.apply((DesignElementHandle)newDesign.getRoot());
                newRunnable.setPrepared(true);
            }
        }
        this.updateOptions();
    }

    protected void updateOptions() {
        Map appContext = this.getAppContext();
        ReportDesignHandle handle = this.executionContext.getReportDesign();
        if (handle != null) {
            Map options = handle.getOptions();
            HashMap newOptions = new HashMap(options);
            if (!newOptions.isEmpty()) {
                Set keyset = newOptions.keySet();
                for (Object key : keyset) {
                    if (!appContext.containsKey(key)) continue;
                    newOptions.put(key, appContext.get(key));
                }
            }
            handle.setOptions(newOptions);
        }
    }

    protected void startFactory() {
        ReportDesignHandle reportDesign = this.executionContext.getReportDesign();
        if (reportDesign != null) {
            ReportScriptExecutor.handleBeforeFactory(reportDesign, this.executionContext);
        }
    }

    protected void closeFactory() {
        ReportDesignHandle reportDesign = this.executionContext.getReportDesign();
        if (reportDesign != null) {
            ReportScriptExecutor.handleAfterFactory(reportDesign, this.executionContext);
        }
    }

    protected void startRender() {
        ReportDesignHandle reportDesign = this.executionContext.getReportDesign();
        ReportScriptExecutor.handleBeforeRender(reportDesign, this.executionContext);
    }

    protected void closeRender() {
        ReportDesignHandle reportDesign = this.executionContext.getReportDesign();
        ReportScriptExecutor.handleAfterRender(reportDesign, this.executionContext);
    }

    @Override
    public void setDataSource(IDocArchiveReader dataSource) {
        this.setDataSource(dataSource, null);
    }

    @Override
    public void setDataSource(IDocArchiveReader dataSource, String reportlet) {
        this.dataSource = dataSource;
        this.dataSourceReportlet = reportlet;
    }

    @Override
    public int getStatus() {
        return this.runningStatus;
    }

    @Override
    public List getErrors() {
        ArrayList<EngineException> errorList = new ArrayList<EngineException>();
        if (this.fatalError != null) {
            errorList.add(this.fatalError);
        }
        if (this.cancelReason != null) {
            errorList.add(new EngineException(this.cancelReason));
        }
        errorList.addAll(this.executionContext.getErrors());
        return errorList;
    }

    public IReportContext getReportContext() {
        return this.executionContext.getReportContext();
    }

    private void mergeOption(IRenderOption options, String name, Object value) {
        if (options != null && value != null && !options.hasOption(name)) {
            options.setOption(name, value);
        }
    }

    protected void setupRenderOption() throws EngineException {
        IRenderOption emitterOptions;
        IRenderOption formatOptions;
        Object renderContext;
        ExtensionManager extManager = ExtensionManager.getInstance();
        if (this.renderOptions != null) {
            this.format = this.renderOptions.getOutputFormat();
            this.emitterID = this.renderOptions.getEmitterID();
            if (this.emitterID == null && this.format == null) {
                this.format = FORMAT_HTML;
            }
            if (this.emitterID != null) {
                if (!extManager.isValidEmitterID(this.emitterID)) {
                    this.log.log(Level.SEVERE, "Error.InvalidEmitterID", this.emitterID);
                    throw new EngineException("Error.InvalidEmitterID", this.emitterID);
                }
                String emitterFormat = extManager.getFormat(this.emitterID);
                if (this.format != null && !emitterFormat.equalsIgnoreCase(this.format)) {
                    throw new EngineException("Error.OutputFormatNotSupported", this.format);
                }
                this.format = emitterFormat;
            } else {
                String innerFormat = extManager.getSupportedFormat(this.format);
                if (innerFormat == null) {
                    this.log.log(Level.SEVERE, "Error.OutputFormatNotSupported", this.format);
                    throw new UnsupportedFormatException("Error.OutputFormatNotSupported", this.format);
                }
                this.format = innerFormat;
                this.emitterID = this.engine.getConfig().getDefaultEmitter(this.format);
                if (this.emitterID == null || !extManager.isValidEmitterID(this.emitterID)) {
                    this.emitterID = extManager.getEmitterID(this.format);
                }
            }
            this.renderOptions.setEmitterID(this.emitterID);
            this.renderOptions.setOutputFormat(this.format);
        }
        Map appContext = this.executionContext.getAppContext();
        if ("org.eclipse.birt.report.engine.emitter.pdf".equals(this.emitterID)) {
            renderContext = appContext.get("PDF_RENDER_CONTEXT");
            if (renderContext instanceof PDFRenderContext) {
                PDFRenderContext pdfContext = (PDFRenderContext)renderContext;
                this.mergeOption(this.renderOptions, "baseUrl", pdfContext.getBaseURL());
                this.mergeOption(this.renderOptions, "pdfRenderOption.fontDirectory", pdfContext.getFontDirectory());
                this.mergeOption(this.renderOptions, "supportedImageFormats", pdfContext.getSupportedImageFormats());
                this.mergeOption(this.renderOptions, "pdfRenderOption.embeddedFonts", pdfContext.isEmbededFont());
            }
        } else {
            renderContext = appContext.get("HTML_RENDER_CONTEXT");
            if (renderContext instanceof HTMLRenderContext) {
                HTMLRenderContext htmlContext = (HTMLRenderContext)renderContext;
                this.mergeOption(this.renderOptions, "baseImageURL", htmlContext.getBaseImageURL());
                this.mergeOption(this.renderOptions, "baseUrl", htmlContext.getBaseURL());
                this.mergeOption(this.renderOptions, "imageDirectory", htmlContext.getImageDirectory());
                if (FORMAT_HTML.equals(this.format)) {
                    this.mergeOption(this.renderOptions, "supportedImageFormats", htmlContext.getSupportedImageFormats());
                }
            }
        }
        HashMap options = new HashMap();
        HashMap configs = this.engine.getConfig().getEmitterConfigs();
        IRenderOption defaultOptions = (IRenderOption)configs.get("org.eclipse.birt.report.engine.api.EngineConfig.defaultRenderOption");
        if (defaultOptions == null) {
            defaultOptions = (IRenderOption)configs.get(FORMAT_HTML);
        }
        if (defaultOptions != null) {
            options.putAll(defaultOptions.getOptions());
        }
        if ((formatOptions = (IRenderOption)configs.get(this.format)) != null) {
            options.putAll(formatOptions.getOptions());
        }
        if (this.emitterID != null && (emitterOptions = (IRenderOption)configs.get(this.emitterID)) != null) {
            options.putAll(emitterOptions.getOptions());
        }
        if (this.renderOptions != null) {
            options.putAll(this.renderOptions.getOptions());
        }
        RenderOption allOptions = new RenderOption(options);
        this.executionContext.setRenderOption(allOptions);
        if ("org.eclipse.birt.report.engine.emitter.pdf".equals(this.emitterID)) {
            Object renderContext2 = appContext.get("PDF_RENDER_CONTEXT");
            if (renderContext2 == null) {
                PDFRenderOption pdfOptions = new PDFRenderOption(allOptions);
                PDFRenderContext pdfContext = new PDFRenderContext();
                pdfContext.setBaseURL(pdfOptions.getBaseURL());
                pdfContext.setEmbededFont(pdfOptions.isEmbededFont());
                pdfContext.setFontDirectory(pdfOptions.getFontDirectory());
                pdfContext.setSupportedImageFormats(pdfOptions.getSupportedImageFormats());
                appContext.put("PDF_RENDER_CONTEXT", pdfContext);
            }
        } else {
            Object renderContext3 = appContext.get("HTML_RENDER_CONTEXT");
            if (renderContext3 == null) {
                HTMLRenderContext htmlContext = new HTMLRenderContext();
                HTMLRenderOption htmlOptions = new HTMLRenderOption(allOptions);
                htmlContext.setBaseImageURL(htmlOptions.getBaseImageURL());
                htmlContext.setBaseURL(htmlOptions.getBaseURL());
                htmlContext.setImageDirectory(htmlOptions.getImageDirectory());
                htmlContext.setSupportedImageFormats(htmlOptions.getSupportedImageFormats());
                htmlContext.setRenderOption(allOptions);
                appContext.put("HTML_RENDER_CONTEXT", htmlContext);
            }
        }
    }

    protected void initializeContentEmitter(IContentEmitter emitter) throws BirtException {
        HashMap configs = this.engine.getConfig().getEmitterConfigs();
        IReportContext reportContext = this.executionContext.getReportContext();
        IRenderOption options = this.executionContext.getRenderOption();
        EngineEmitterServices services = new EngineEmitterServices(reportContext, options, configs);
        emitter.initialize(services);
    }

    @Override
    public int getTaskType() {
        return this.taskType;
    }

    protected void changeStatusToRunning() {
        this.runningStatus = 1;
    }

    protected void changeStatusToStopped() {
        this.runningStatus = this.cancelFlag ? 4 : (this.fatalError != null || this.executionContext.hasErrors() ? 3 : 2);
    }

    protected void handleFatalExceptions(Throwable t) throws EngineException {
        if (t instanceof EngineException) {
            this.log.log(Level.SEVERE, "An error happened while running the report. Cause:", t);
            this.fatalError = (EngineException)((Object)t);
            throw this.fatalError;
        }
        if (t instanceof Exception) {
            this.log.log(Level.SEVERE, "An error happened while running the report. Cause:", t);
            this.fatalError = new EngineException("Error.ReportRunError", t);
            throw this.fatalError;
        }
        if (t instanceof OutOfMemoryError) {
            this.log.log(Level.SEVERE, "There is insufficient memory to execute this report.");
            this.fatalError = new EngineException("Error.ReportRunError", t);
            throw (OutOfMemoryError)t;
        }
        this.log.log(Level.SEVERE, "Error happened while running the report.", t);
        this.fatalError = new EngineException("Error.ReportRunError", t);
        throw this.fatalError;
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    @Override
    public void setLogger(Logger logger) {
        if (logger == null || EngineLogger.isValidLogger(logger)) {
            throw new IllegalArgumentException("the logger can not be NULL or children or in namespace of org.eclipse.birt");
        }
        EngineLogger.setThreadLogger(logger);
        this.log = logger;
        this.executionContext.setLogger(logger);
    }

    public void setPageHandler(IPageHandler callback) {
        this.pageHandler = callback;
    }

    protected void switchToOsgiClassLoader() {
        this.platformContext = Platform.enterPlatformContext();
    }

    protected void switchClassLoaderBack() {
        if (this.platformContext != null) {
            Platform.exitPlatformContext((Object)this.platformContext);
            this.platformContext = null;
        }
    }

    protected IResourceLocator getResourceLocator() {
        ModuleOption opts;
        ModuleHandle handle = this.executionContext.getDesign();
        if (handle != null && (opts = handle.getModule().getOptions()) != null) {
            return opts.getResourceLocator();
        }
        return null;
    }

    protected void loadDataSource() throws EngineException {
        boolean refreshData = false;
        Object obj = this.getAppContext().get("REFRESH_DATA");
        if (obj != null && obj.equals(Boolean.TRUE)) {
            refreshData = true;
        }
        if (this.dataSource == null || refreshData) {
            return;
        }
        try {
            HashMap<String, IResourceLocator> options = new HashMap<String, IResourceLocator>();
            IResourceLocator resourceLocator = this.getResourceLocator();
            if (resourceLocator != null) {
                options.put("resourceLocator", resourceLocator);
            }
            try (ReportDocumentReader document = new ReportDocumentReader(null, this.engine, this.dataSource, true, options);){
                String buildNumber = document.getProperty("BIRT ENGINE BUILD NUMBER");
                Map appContext = this.getAppContext();
                if (appContext != null) {
                    appContext.put("BIRT ENGINE BUILD NUMBER", buildNumber);
                }
                Map values = document.getParameterValues(this.executionContext.getApplicationClassLoader());
                Map texts = document.getParameterDisplayTexts();
                this.setParameterValues(values);
                this.setParameterDisplayTexts(texts);
                if (this.dataSourceReportlet == null) {
                    this.executionContext.setDataSource(new DocumentDataSource(this.dataSource));
                    return;
                }
                this.loadReportletDataSource(document, this.dataSource, this.dataSourceReportlet);
            }
        }
        catch (IOException ioex) {
            throw new EngineException(ioex.getMessage(), ioex);
        }
    }

    private void loadReportletDataSource(ReportDocumentReader document, IDocArchiveReader dataSource, String reportletBookmark) throws EngineException, IOException {
        InstanceID reportletIid = null;
        if (document.isReporltetDocument()) {
            String bookmark = document.getReportletBookmark();
            if (!reportletBookmark.equals(bookmark)) {
                throw new EngineException("The user must specify the same reportlet with the one used to generate the document");
            }
            reportletIid = document.getReportletInstanceID();
        } else {
            long offset = document.getBookmarkOffset(reportletBookmark);
            if (offset == -1L) {
                throw new EngineException("The user specified reportlet {0} doesn''t exits in the report document", new Object[]{reportletBookmark});
            }
            ClassLoader loader = document.getClassLoader();
            RAInputStream in = dataSource.getInputStream("/content/content.dat");
            Throwable throwable = null;
            Object var10_11 = null;
            try {
                try (ReportContentReaderV3 reader = new ReportContentReaderV3(new ReportContent(), in, loader);){
                    LinkedList<InstanceID> iids = new LinkedList<InstanceID>();
                    while (offset != -1L) {
                        IContent content = reader.readContent(offset);
                        iids.addFirst(content.getInstanceID());
                        offset = ((DocumentExtension)content.getExtension(0)).getParent();
                    }
                    for (InstanceID iid : iids) {
                        reportletIid = reportletIid == null ? iid : new InstanceID(reportletIid, iid);
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.executionContext.setDataSource(new DocumentDataSource(dataSource, reportletBookmark, reportletIid));
    }

    protected void updateRtLFlag() throws EngineException {
        if (this.renderOptions == null) {
            return;
        }
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable == null) {
            return;
        }
        ReportDesignHandle handle = (ReportDesignHandle)runnable.getDesignHandle();
        if (handle != null) {
            Object bidiFlag = this.renderOptions.getOption("RTLFlag");
            if (Boolean.TRUE.equals(bidiFlag)) {
                if (!handle.isDirectionRTL()) {
                    this.updateBidiStyle(true);
                }
            } else if (Boolean.FALSE.equals(bidiFlag) && handle.isDirectionRTL()) {
                this.updateBidiStyle(false);
            }
        }
    }

    private void updateBidiStyle(boolean isRtl) {
        Report report = this.executionContext.getReport();
        AbstractStyle rootStyle = (AbstractStyle)report.getStyles().get(report.getRootStyleName());
        if (rootStyle != null) {
            rootStyle.setDirection(isRtl ? "rtl" : "ltr");
        }
    }

    protected IReportExecutor createReportExtensionExecutor(IReportExecutor executor) throws EngineException {
        String[] extensions = this.executionContext.getEngineExtensions();
        if (extensions != null) {
            ArrayList<IContentProcessor> processors = new ArrayList<IContentProcessor>();
            EngineExtensionManager manager = this.executionContext.getEngineExtensionManager();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IContentProcessor processor;
                String extName = stringArray[n2];
                IGenerateExtension genExt = manager.getGenerateExtension(extName);
                if (genExt != null && (processor = genExt.createGenerateProcessor()) != null) {
                    processors.add(processor);
                }
                ++n2;
            }
            if (!processors.isEmpty()) {
                return new ReportExtensionExecutor(this.executionContext, executor, processors.toArray(new IContentProcessor[processors.size()]));
            }
        }
        return executor;
    }

    @Override
    public void setUserACL(String[] acls) {
        if (acls != null) {
            String[] strippedAcls = this.strip(acls);
            this.userAcls = strippedAcls;
            this.executionContext.getAppContext().put("USER_ACL", strippedAcls);
        } else {
            this.userAcls = null;
            this.executionContext.getAppContext().put("USER_ACL", null);
        }
    }

    protected String[] strip(String[] acls) {
        ArrayList<String> strippedAcls = new ArrayList<String>();
        int i = 0;
        while (i < acls.length) {
            String strippedAcl;
            String acl = acls[i];
            if (acl != null && (strippedAcl = acl.trim()).length() > 0) {
                strippedAcls.add(strippedAcl);
            }
            ++i;
        }
        return strippedAcls.toArray(new String[strippedAcls.size()]);
    }

    @Override
    public void setProgressMonitor(IProgressMonitor monitor) {
        this.progressMonitor = monitor;
        this.executionContext.setProgressMonitor(monitor);
    }

    @Override
    public void setStatusHandler(IStatusHandler handler) {
        this.statusHandler = handler;
    }

    public IStatusHandler getStatusHandler() {
        return this.statusHandler;
    }

    private class ParameterValidationVisitor
    extends ParameterVisitor {
        private ParameterValidationVisitor() {
        }

        @Override
        boolean visitScalarParameter(ScalarParameterHandle param, Object value) {
            try {
                return EngineTask.this.validateAbstractScalarParameter((AbstractScalarParameterHandle)param);
            }
            catch (ParameterValidationException pe) {
                this.engineException = pe;
                return false;
            }
        }

        @Override
        boolean visitDynamicFilterParameter(DynamicFilterParameterHandle param, Object value) {
            try {
                return EngineTask.this.validateAbstractScalarParameter((AbstractScalarParameterHandle)param);
            }
            catch (ParameterValidationException pe) {
                this.engineException = pe;
                return false;
            }
        }

        @Override
        boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
            return this.visitParametersInGroup(group, value);
        }
    }

    static abstract class ParameterVisitor {
        ParameterValidationException engineException;

        ParameterVisitor() {
        }

        boolean visitParametersInGroup(ParameterGroupHandle group, Object value) {
            SlotHandle parameters = group.getParameters();
            for (Object param : parameters) {
                if (!(param instanceof CascadingParameterGroupHandle ? !this.visitCascadingParamterGroup((CascadingParameterGroupHandle)param, value) : (param instanceof ParameterGroupHandle ? !this.visitParameterGroup((ParameterGroupHandle)param, value) : (param instanceof ScalarParameterHandle ? !this.visitScalarParameter((ScalarParameterHandle)param, value) : param instanceof DynamicFilterParameterHandle && !this.visitDynamicFilterParameter((DynamicFilterParameterHandle)param, value))))) continue;
                return false;
            }
            return true;
        }

        boolean visitCascadingParamterGroup(CascadingParameterGroupHandle group, Object value) {
            return this.visitParameterGroup((ParameterGroupHandle)group, value);
        }

        boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
            return false;
        }

        boolean visitScalarParameter(ScalarParameterHandle param, Object value) {
            return false;
        }

        boolean visitDynamicFilterParameter(DynamicFilterParameterHandle param, Object value) {
            return false;
        }

        boolean visit(ModuleHandle report, ExecutionContext executionContext) {
            return this.visit(report, null, executionContext);
        }

        boolean visit(ModuleHandle report, Object value, ExecutionContext executionContext) {
            executionContext.clearExceptions();
            SlotHandle parameters = report.getParameters();
            if (parameters != null) {
                for (Object param : parameters) {
                    if (param instanceof CascadingParameterGroupHandle) {
                        if (this.visitCascadingParamterGroup((CascadingParameterGroupHandle)param, value)) continue;
                        executionContext.addException((DesignElementHandle)((CascadingParameterGroupHandle)param), (BirtException)this.engineException);
                        continue;
                    }
                    if (param instanceof ParameterGroupHandle) {
                        if (this.visitParameterGroup((ParameterGroupHandle)param, value)) continue;
                        executionContext.addException((DesignElementHandle)((ParameterGroupHandle)param), (BirtException)this.engineException);
                        continue;
                    }
                    if (param instanceof ScalarParameterHandle) {
                        if (this.visitScalarParameter((ScalarParameterHandle)param, value)) continue;
                        executionContext.addException((DesignElementHandle)((ScalarParameterHandle)param), (BirtException)this.engineException);
                        continue;
                    }
                    if (!(param instanceof DynamicFilterParameterHandle) || this.visitDynamicFilterParameter((DynamicFilterParameterHandle)param, value)) continue;
                    executionContext.addException((DesignElementHandle)((DynamicFilterParameterHandle)param), (BirtException)this.engineException);
                }
            }
            return !executionContext.hasErrors();
        }
    }
}

