/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.structures.DimensionCondition;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.olap.TabularCube;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ReportElementState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TabularCubeState
extends ReportElementState {
    protected TabularCube element = null;

    public TabularCubeState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler, theContainer, slot);
    }

    @Override
    public DesignElement getElement() {
        return this.element;
    }

    @Override
    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.element = new TabularCube();
        this.initElement(attrs, true);
    }

    @Override
    public void end() throws SAXException {
        ArrayList conditionList;
        List dimensionConditions = (List)this.element.getLocalProperty(this.handler.module, "dimensionConditions");
        LinkedHashMap<String, DimensionCondition> mergedConditions = new LinkedHashMap<String, DimensionCondition>();
        if (dimensionConditions != null) {
            int i = 0;
            while (i < dimensionConditions.size()) {
                DimensionCondition condition = (DimensionCondition)dimensionConditions.get(i);
                ElementRefValue hierarchyRef = (ElementRefValue)condition.getLocalProperty(this.handler.module, "hierarchy");
                String hierarchyName = hierarchyRef.getQualifiedReference();
                if (hierarchyName != null) {
                    DimensionCondition temp = (DimensionCondition)mergedConditions.get(hierarchyName);
                    if (temp == null) {
                        mergedConditions.put(hierarchyName, condition);
                    } else {
                        List joinConditions;
                        ArrayList tempJoinConditions = (ArrayList)temp.getLocalProperty(this.handler.module, "joinConditions");
                        if (tempJoinConditions == null) {
                            tempJoinConditions = new ArrayList();
                        }
                        if ((joinConditions = (List)condition.getLocalProperty(this.handler.module, "joinConditions")) != null) {
                            tempJoinConditions.addAll(joinConditions);
                        }
                        if (!tempJoinConditions.isEmpty()) {
                            temp.setProperty("joinConditions", tempJoinConditions);
                        }
                    }
                }
                ++i;
            }
        }
        if (!(conditionList = new ArrayList(mergedConditions.values())).isEmpty()) {
            this.element.setProperty("dimensionConditions", conditionList);
        } else {
            this.element.setProperty("dimensionConditions", null);
        }
        super.end();
    }
}

