/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ReportImageDescriptor
extends CompositeImageDescriptor {
    private ImageDescriptor fBaseImage;

    public ReportImageDescriptor(ImageDescriptor baseImage) {
        this.fBaseImage = baseImage;
    }

    public boolean equals(Object object) {
        if (object == null || !ReportImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        ReportImageDescriptor other = (ReportImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.fBaseImage.getImageData();
        ImageData data = this.getImageData(ReportPlatformUIImages.getImageDescriptor("Report Project Over"));
        this.drawImage(bg, 0, 0);
        Point pos = new Point(this.getSize().x, 0);
        this.addTopRightImage(data, pos);
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
        }
        return data;
    }

    protected Point getSize() {
        return new Point(this.fBaseImage.getImageData().width, this.fBaseImage.getImageData().height);
    }

    private void addTopRightImage(ImageData data, Point pos) {
        int x = pos.x - data.width;
        if (x >= 0) {
            this.drawImage(data, x, pos.y);
            pos.x = x;
        }
    }
}

