/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.ui.internal.sqb;

import org.eclipse.birt.report.data.oda.jdbc.dbprofile.model.CustomQuerySourceFormat;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.ui.internal.sqb.SQLBuilderDesignState;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.sqltools.sqlbuilder.IContentChangeListener;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilder;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.sqlbuilderdialog.SQLBuilderDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLSourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CustomSQLBuilderDialog
extends SQLBuilderDialog
implements IContentChangeListener {
    private static final String DIRTY_STATUS_MARK = "*";
    private SQLBuilderDesignState m_savedSQBState;

    public CustomSQLBuilderDialog(Shell parentShell) {
        super(parentShell);
    }

    public Control createDialogArea(Composite parent) {
        this.setParentShell(parent.getShell());
        String origDialogTitle = parent.getShell().getText();
        Control dialogArea = super.createDialogArea(parent);
        parent.getShell().setText(origDialogTitle);
        this.getSQLBuilder().addContentChangeListener((IContentChangeListener)this);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void buttonPressed(int buttonId) {
    }

    public boolean setInput(ISQLBuilderEditorInput editorInput) {
        try {
            boolean isInputLoaded = super.setInput(editorInput);
            if (isInputLoaded) {
                this.setDbDefinitionInSqlSourceFormat(this.getSQLBuilder().getDomainModel());
            }
            return isInputLoaded;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void setDbDefinitionInSqlSourceFormat(SQLDomainModel sqm) {
        if (sqm == null) {
            return;
        }
        DatabaseDefinition dbDefn = sqm.getDatabaseDefinition();
        if (dbDefn == null) {
            return;
        }
        CustomQuerySourceFormat extendedSourceFormat = new CustomQuerySourceFormat(sqm.getSqlSourceFormat(), dbDefn);
        sqm.setSqlSourceFormat((SQLQuerySourceFormat)extendedSourceFormat);
        QueryStatement queryStmt = sqm.getSQLStatement();
        queryStmt.getSourceInfo().setSqlFormat((SQLQuerySourceFormat)extendedSourceFormat);
    }

    SQLBuilderDesignState getSavedSQBState() {
        return this.m_savedSQBState;
    }

    SQLBuilderDesignState saveSQBState(String sqbInputName) {
        this.m_savedSQBState = this.getSQLBuilderState(sqbInputName);
        return this.m_savedSQBState;
    }

    private SQLBuilderDesignState getSQLBuilderState(String sqbInputName) {
        SQLBuilder sqlBuilder = this.getSQLBuilder();
        if (sqlBuilder == null) {
            return null;
        }
        return new SQLBuilderDesignState(sqbInputName, sqlBuilder);
    }

    QueryStatement getSQLQueryStatement() {
        this.refreshSQLQueryStatement();
        return this.getSQLBuilder().getDomainModel().getSQLStatement();
    }

    private void refreshSQLQueryStatement() {
        if (!this.isDirty()) {
            return;
        }
        SQLBuilder sqlBuilder = this.getSQLBuilder();
        SQLSourceViewer sourceViewer = sqlBuilder.getSourceViewer();
        boolean currentTextModified = sourceViewer.isTextChanged();
        sourceViewer.setTextChanged(true);
        sourceViewer.setParseRequired(true);
        sqlBuilder.reparseIfRequired();
        sourceViewer.setTextChanged(currentTextModified);
    }

    public void setDirty(boolean dirty) {
        this.getSQLBuilder().setDirty(dirty);
    }

    public boolean isDirty() {
        return this.getSQLBuilder().isDirty();
    }

    public void notifyContentChange() {
        this.updateDirtyStatus();
    }

    private void updateDirtyStatus() {
        Shell dialogShell = this.getParentShell();
        if (dialogShell == null || dialogShell.getText() == null) {
            return;
        }
        String currentTitle = dialogShell.getText();
        if (this.isDirty()) {
            if (!currentTitle.startsWith(DIRTY_STATUS_MARK)) {
                dialogShell.setText(DIRTY_STATUS_MARK + currentTitle);
            }
        } else if (currentTitle.startsWith(DIRTY_STATUS_MARK)) {
            dialogShell.setText(currentTitle.substring(1));
        }
    }

    public boolean close() {
        this.getSQLBuilder().removeContentChangeListener((IContentChangeListener)this);
        return super.close();
    }
}

