/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.romdoc;

import java.io.FileNotFoundException;
import org.eclipse.birt.doc.romdoc.DocParser;
import org.eclipse.birt.doc.romdoc.DocPropertyType;
import org.eclipse.birt.doc.romdoc.Generator;
import org.eclipse.birt.doc.util.HtmlDocReader;

public class DataTypeParser
extends HtmlDocReader {
    Generator generator;

    public DataTypeParser(Generator gen) {
        this.generator = gen;
    }

    public void parse() throws DocParser.ParseException {
        String templateDir = this.generator.templateDir;
        String fileName = String.valueOf(templateDir) + "/" + "data-types.html";
        try {
            this.parser.open(fileName);
        }
        catch (FileNotFoundException e1) {
            System.out.println("No documentation file for " + fileName);
            return;
        }
        this.parseHeader();
        try {
            this.parseTypes();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        this.parser.close();
    }

    private void parseHeader() {
        this.skipTo("/h1");
        this.generator.setTypeHeader(this.getTextTo("h2"));
        this.pushToken(3);
    }

    private void parseTypes() throws ParserException {
        int token;
        while ((token = this.getToken()) != -1) {
            if (this.isElement(token, "h1") || this.isElement(token, "/body") || this.isElement(token, "/html")) {
                this.pushToken(token);
                return;
            }
            this.parseType();
        }
        return;
    }

    private void parseType() throws ParserException {
        int token = this.getToken();
        if (token != 1) {
            String msg = "Type name missing from h2 block.";
            System.out.println(msg);
            throw new ParserException(msg);
        }
        String name = this.parser.getTokenText();
        DocPropertyType type = this.generator.findType(name);
        if (type == null) {
            System.err.println("Property type " + name + " is not defined in rom.def!");
            type = new DocPropertyType(null);
        }
        if (!this.isElement(token = this.getToken(), "/h2")) {
            String msg = "Missing /h2 element.";
            System.out.println(msg);
            throw new ParserException(msg);
        }
        type.setSummary(this.stripPara(this.copySection()));
        while ((token = this.getToken()) != -1) {
            if (this.isElement(token, "h2") || this.isElement(token, "/body") || this.isElement(token, "/html")) {
                this.pushToken(token);
                return;
            }
            assert (this.isElement(token, "h3"));
            token = this.getToken();
            if (this.isElement(token, "/h3")) {
                System.out.println("Blank section header");
            } else if (token != 1) {
                String msg = "Unexpected element inside section header";
                System.out.println(msg);
                throw new ParserException(msg);
            }
            String header = this.parser.getTokenText();
            token = this.getToken();
            if (!this.isElement(token, "/h3")) {
                this.pushToken(token);
            }
            if (header.equalsIgnoreCase("Description")) {
                type.setDescription(this.copySection());
                continue;
            }
            if (header.equalsIgnoreCase("See Also")) {
                type.setSeeAlso(this.copySection());
                continue;
            }
            if (header.equalsIgnoreCase("Issues")) {
                this.copySection();
                continue;
            }
            System.out.println("Unexpected Element header: " + header);
            this.copySection();
        }
        return;
    }

    static class ParserException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParserException(String msg) {
            super(msg);
        }
    }
}

