/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.List;
import me.prettyprint.cassandra.model.ExecutionResult;
import me.prettyprint.cassandra.model.QueryResultImpl;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.SubColumnQuery;
import me.prettyprint.hector.api.query.SubSliceQuery;

public class AbstractSubColumnQuery<K, SN, N, V>
implements SubColumnQuery<K, SN, N, V> {
    protected final SubSliceQuery<K, SN, N, V> subSliceQuery;

    public AbstractSubColumnQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        this.subSliceQuery = HFactory.createSubSliceQuery(keyspace, keySerializer, sNameSerializer, nameSerializer, valueSerializer);
    }

    @Override
    public SubColumnQuery<K, SN, N, V> setKey(K key) {
        this.subSliceQuery.setKey(key);
        return this;
    }

    @Override
    public SubColumnQuery<K, SN, N, V> setSuperColumn(SN superName) {
        this.subSliceQuery.setSuperColumn(superName);
        return this;
    }

    @Override
    public SubColumnQuery<K, SN, N, V> setColumn(N columnName) {
        this.subSliceQuery.setColumnNames(columnName);
        return this;
    }

    public String toString() {
        return "SubColumnQuery(" + this.subSliceQuery + ")";
    }

    @Override
    public SubColumnQuery<K, SN, N, V> setColumnFamily(String cf) {
        this.subSliceQuery.setColumnFamily(cf);
        return this;
    }

    @Override
    public QueryResult<HColumn<N, V>> execute() {
        Assert.isTrue(this.subSliceQuery.getColumnNames().size() == 1, "There should be exactly one column name set. Call setColumn");
        QueryResult r = this.subSliceQuery.execute();
        ColumnSlice slice = (ColumnSlice)r.get();
        List columns = slice.getColumns();
        HColumn column = columns.size() == 0 ? null : columns.get(0);
        return new QueryResultImpl(new ExecutionResult(column, r.getExecutionTimeNano(), r.getHostUsed()), this);
    }
}

