/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.document;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.internal.document.IDocumentCharsetDetector;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.TextUtilities;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.CodedReaderCreator;
import org.eclipse.wst.sse.core.internal.encoding.ContentTypeEncodingPreferences;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedInputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;

public abstract class AbstractDocumentLoader
implements IDocumentLoader {
    private CodedReaderCreator fCodedReaderCreator;
    protected IDocumentCharsetDetector fDocumentEncodingDetector;
    protected EncodingMemento fEncodingMemento;
    protected Reader fFullPreparedReader;

    protected final StringBuffer convertLineDelimiters(StringBuffer allTextBuffer, String lineDelimiterToUse) {
        String allText = allTextBuffer.toString();
        Document tempDoc = new Document(allText);
        if (lineDelimiterToUse == null) {
            lineDelimiterToUse = System.getProperty("line.separator");
        }
        StringBuffer newText = new StringBuffer();
        int lineCount = tempDoc.getNumberOfLines();
        int i = 0;
        while (i < lineCount) {
            try {
                IRegion lineInfo = tempDoc.getLineInformation(i);
                int lineStartOffset = lineInfo.getOffset();
                int lineLength = lineInfo.getLength();
                int lineEndOffset = lineStartOffset + lineLength;
                newText.append(allText.substring(lineStartOffset, lineEndOffset));
                if (i < lineCount - 1 && tempDoc.getLineDelimiter(i) != null) {
                    newText.append(lineDelimiterToUse);
                }
            }
            catch (BadLocationException exception) {
                throw new RuntimeException(exception);
            }
            ++i;
        }
        return newText;
    }

    @Override
    public IEncodedDocument createNewStructuredDocument() {
        IEncodedDocument structuredDocument = this.newEncodedDocument();
        String charset = ContentTypeEncodingPreferences.useDefaultNameRules(this.getDocumentEncodingDetector());
        String specDefaultCharset = this.getDocumentEncodingDetector().getSpecDefaultEncoding();
        structuredDocument.setEncodingMemento(CodedIO.createEncodingMemento(charset, "DefaultsAssumedForEmptyInput", specDefaultCharset));
        String lineDelimiter = this.getPreferredNewLineDelimiter(null);
        if (lineDelimiter != null) {
            structuredDocument.setPreferredLineDelimiter(lineDelimiter);
        }
        IDocumentPartitioner defaultPartitioner = this.getDefaultDocumentPartitioner();
        if (structuredDocument instanceof IDocumentExtension3) {
            ((IDocumentExtension3)structuredDocument).setDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning", defaultPartitioner);
        } else {
            structuredDocument.setDocumentPartitioner(defaultPartitioner);
        }
        defaultPartitioner.connect((IDocument)structuredDocument);
        return structuredDocument;
    }

    @Override
    public IEncodedDocument createNewStructuredDocument(IFile iFile) throws IOException, CoreException {
        IEncodedDocument structuredDocument = this.createNewStructuredDocument();
        String lineDelimiter = this.getPreferredNewLineDelimiter(iFile);
        if (lineDelimiter != null) {
            structuredDocument.setPreferredLineDelimiter(lineDelimiter);
        }
        try {
            CodedReaderCreator creator = this.getCodedReaderCreator();
            creator.set(iFile);
            this.fEncodingMemento = creator.getEncodingMemento();
            structuredDocument.setEncodingMemento(this.fEncodingMemento);
            this.fFullPreparedReader = this.getCodedReaderCreator().getCodedReader();
            this.setDocumentContentsFromReader(structuredDocument, this.fFullPreparedReader);
        }
        finally {
            if (this.fFullPreparedReader != null) {
                this.fFullPreparedReader.close();
            }
        }
        return structuredDocument;
    }

    @Override
    public IEncodedDocument createNewStructuredDocument(String filename, InputStream inputStream) throws UnsupportedEncodingException, IOException {
        return this.createNewStructuredDocument(filename, inputStream, EncodingRule.CONTENT_BASED);
    }

    @Override
    public IEncodedDocument createNewStructuredDocument(String filename, InputStream inputStream, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException {
        if (filename == null && inputStream == null) {
            throw new IllegalArgumentException("can not have both null filename and inputstream");
        }
        IEncodedDocument structuredDocument = this.createNewStructuredDocument();
        CodedReaderCreator codedReaderCreator = this.getCodedReaderCreator();
        try {
            try {
                codedReaderCreator.set(filename, inputStream);
                codedReaderCreator.setEncodingRule(encodingRule);
                this.fEncodingMemento = codedReaderCreator.getEncodingMemento();
                this.fFullPreparedReader = codedReaderCreator.getCodedReader();
                structuredDocument.setEncodingMemento(this.fEncodingMemento);
                this.setDocumentContentsFromReader(structuredDocument, this.fFullPreparedReader);
            }
            catch (CoreException e) {
                throw new Error(e);
            }
        }
        finally {
            if (this.fFullPreparedReader != null) {
                this.fFullPreparedReader.close();
            }
        }
        return structuredDocument;
    }

    private int getCharPostionOfFailure(BufferedReader inputStream) {
        int charPosition = 1;
        int charRead = -1;
        boolean errorFound = false;
        do {
            try {
                charRead = inputStream.read();
                ++charPosition;
            }
            catch (IOException iOException) {
                errorFound = true;
                break;
            }
        } while (charRead != -1 && !errorFound);
        if (errorFound) {
            return charPosition + 1;
        }
        return -1;
    }

    protected CodedReaderCreator getCodedReaderCreator() {
        if (this.fCodedReaderCreator == null) {
            this.fCodedReaderCreator = new CodedReaderCreator();
        }
        return this.fCodedReaderCreator;
    }

    @Override
    public abstract IDocumentPartitioner getDefaultDocumentPartitioner();

    public EncodingMemento getEncodingMemento() {
        if (this.fEncodingMemento == null) {
            throw new IllegalStateException("Program Error: encodingMemento was accessed before it was set");
        }
        return this.fEncodingMemento;
    }

    protected Reader getFullPreparedReader() throws UnsupportedEncodingException, CoreException, IOException {
        if (this.fFullPreparedReader == null) {
            this.fFullPreparedReader = this.getCodedReaderCreator().getCodedReader();
        }
        return this.fFullPreparedReader;
    }

    private String getPlatformLineDelimiterPreference(IFile file) {
        IScopeContext[] scopeContext;
        if (file != null && file.getProject() != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(file.getProject())};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
    }

    protected String getPreferredNewLineDelimiter() {
        return this.getPreferredNewLineDelimiter(null);
    }

    protected String getPreferredNewLineDelimiter(IFile file) {
        return this.getPlatformLineDelimiterPreference(file);
    }

    @Override
    public StringBuffer handleLineDelimiter(StringBuffer originalString, IEncodedDocument theFlatModel) {
        StringBuffer convertedText = null;
        String probableLineDelimiter = TextUtilities.determineLineDelimiter(originalString, theFlatModel.getLegalLineDelimiters(), System.getProperty("line.separator"));
        String preferredLineDelimiter = this.getPreferredNewLineDelimiter(null);
        if (preferredLineDelimiter == null) {
            if (!theFlatModel.getPreferredLineDelimiter().equals(probableLineDelimiter)) {
                theFlatModel.setPreferredLineDelimiter(probableLineDelimiter);
            }
            convertedText = originalString;
        } else if (!preferredLineDelimiter.equals(probableLineDelimiter)) {
            convertedText = this.convertLineDelimiters(originalString, preferredLineDelimiter);
            theFlatModel.setPreferredLineDelimiter(preferredLineDelimiter);
        } else {
            theFlatModel.setPreferredLineDelimiter(preferredLineDelimiter);
            convertedText = originalString;
        }
        return convertedText;
    }

    protected abstract IEncodedDocument newEncodedDocument();

    private StringBuffer readInputStream(Reader reader) throws IOException {
        int fBlocksRead = 0;
        StringBuffer buffer = new StringBuffer();
        int numRead = 0;
        try {
            char[] tBuff = new char[8192];
            while (numRead != -1) {
                numRead = reader.read(tBuff, 0, tBuff.length);
                if (numRead <= 0) continue;
                buffer.append(tBuff, 0, numRead);
                ++fBlocksRead;
            }
        }
        catch (MalformedInputException e) {
            throw new MalformedInputExceptionWithDetail(this.fEncodingMemento.getJavaCharsetName(), fBlocksRead * 8192 + numRead + e.getInputLength());
        }
        catch (UnmappableCharacterException e) {
            throw new MalformedInputExceptionWithDetail(this.fEncodingMemento.getJavaCharsetName(), fBlocksRead * 8192 + numRead + e.getInputLength());
        }
        return buffer;
    }

    @Override
    public void reload(IEncodedDocument encodedDocument, Reader inputStreamReader) throws IOException {
        if (inputStreamReader == null) {
            throw new IllegalArgumentException("stream reader can not be null");
        }
        int READ_BUFFER_SIZE = 8192;
        int MAX_BUFFERED_SIZE_FOR_RESET_MARK = 200000;
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader, MAX_BUFFERED_SIZE_FOR_RESET_MARK);
        bufferedReader.mark(MAX_BUFFERED_SIZE_FOR_RESET_MARK);
        StringBuffer buffer = new StringBuffer();
        try {
            int numRead = 0;
            char[] tBuff = new char[READ_BUFFER_SIZE];
            while ((numRead = bufferedReader.read(tBuff, 0, tBuff.length)) != -1) {
                buffer.append(tBuff, 0, numRead);
            }
        }
        catch (MalformedInputException malformedInputException) {
            EncodingMemento localEncodingMemento = this.getEncodingMemento();
            boolean couldReset = true;
            String encodingNameInError = localEncodingMemento.getJavaCharsetName();
            if (encodingNameInError == null) {
                encodingNameInError = localEncodingMemento.getDetectedCharsetName();
            }
            try {
                bufferedReader.reset();
            }
            catch (IOException iOException) {
                couldReset = false;
            }
            int charPostion = -1;
            if (couldReset) {
                charPostion = this.getCharPostionOfFailure(bufferedReader);
            }
            throw new MalformedInputExceptionWithDetail(encodingNameInError, CodedIO.getAppropriateJavaCharset(encodingNameInError), charPostion, !couldReset, MAX_BUFFERED_SIZE_FOR_RESET_MARK);
        }
        StringBuffer stringbuffer = buffer;
        encodedDocument.set(stringbuffer.toString());
    }

    protected void setDocumentContentsFromReader(IEncodedDocument structuredDocument, Reader reader) throws IOException {
        StringBuffer allText = this.readInputStream(reader);
        structuredDocument.set(allText.toString());
    }
}

