/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.SQLService;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.actions.Messages;
import org.eclipse.datatools.sqltools.sqleditor.result.GroupSQLResultRunnable;
import org.eclipse.osgi.util.NLS;

public class MultiGroupExecuteJob
extends Job {
    private DatabaseIdentifier _databaseIdentifier;
    private String[] _sqls;
    private String[] _targets;

    public MultiGroupExecuteJob(String name, DatabaseIdentifier databaseIdentifier, String[] sqls, String[] targets) {
        super(name);
        this._databaseIdentifier = databaseIdentifier;
        this._sqls = sqls;
        this._targets = targets;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this._databaseIdentifier == null || this._sqls == null) {
            return Status.CANCEL_STATUS;
        }
        IJobManager manager = Job.getJobManager();
        if (monitor == null) {
            monitor = manager.createProgressGroup();
        }
        String task = Messages.GroupSQLResultRunnable_name;
        if (this._sqls.length > 1) {
            task = String.valueOf(task) + NLS.bind((String)Messages.GroupSQLResultRunnable_groups, (Object[])new Object[]{"" + this._sqls.length});
        }
        monitor.beginTask(task, this._sqls.length);
        try {
            SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)this._databaseIdentifier.getProfileName());
            SQLService sqlService = f.getSQLService();
            int i = 0;
            while (i < this._sqls.length) {
                if (this._sqls.length > 1) {
                    monitor.subTask(NLS.bind((String)Messages.GroupSQLResultRunnable_group, (Object[])new Object[]{"" + i, this._targets[i]}));
                }
                String[] groups = new String[]{this._sqls[i]};
                if (sqlService != null) {
                    groups = sqlService.splitSQL(this._sqls[i]);
                }
                GroupSQLResultRunnable job = new GroupSQLResultRunnable(null, groups, null, null, this._databaseIdentifier, false, null, Messages.BaseExecuteAction_group_exec_title, this._targets[i]);
                job.setName(Messages.BaseExecuteAction_job_title);
                job.setProgressGroup(monitor, 1);
                job.schedule();
                Runnable parallelRunnable = f.getExecutionService().createExecuteParallelRunnable(this._sqls[i], this._databaseIdentifier);
                if (parallelRunnable != null) {
                    new Thread(parallelRunnable).start();
                }
                job.join();
                if (monitor.isCanceled() || Status.CANCEL_STATUS.equals(job.getResult())) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    monitor.worked(1);
                    ++i;
                }
                catch (Exception e) {
                    Status status;
                    Status status2 = status = new Status(4, "org.eclipse.datatools.sqltools.sqlscrapbook", 0, e.getMessage(), (Throwable)e);
                    return status2;
                }
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

