/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.IODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.ODADesignFactory;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedPropertyHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ExtendedProperty;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.PropertyValueValidationUtil;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.emf.common.util.EList;

abstract class AbstractDataAdapter {
    private static final String RESOURCE_FILE_SUFFIX = ".properties";
    protected final IODADesignFactory designFactory = ODADesignFactory.getFactory();

    AbstractDataAdapter() {
    }

    protected Properties newOdaPrivateProperties(Iterator props) {
        if (props == null || !props.hasNext()) {
            return null;
        }
        Properties retProps = this.designFactory.createProperties();
        while (props.hasNext()) {
            ExtendedPropertyHandle propHandle = (ExtendedPropertyHandle)props.next();
            retProps.setProperty(propHandle.getName(), propHandle.getValue());
        }
        return retProps;
    }

    protected Properties newOdaPublicProperties(List propDefns, ReportElementHandle element) {
        if (propDefns == null) {
            return null;
        }
        Properties retProps = null;
        int i = 0;
        while (i < propDefns.size()) {
            if (retProps == null) {
                retProps = this.designFactory.createProperties();
            }
            IPropertyDefn propDefn = (IPropertyDefn)propDefns.get(i);
            String propName = propDefn.getName();
            String propValue = element.getStringProperty(propName);
            retProps.setProperty(propName, propValue);
            ++i;
        }
        return retProps;
    }

    protected List newROMPrivateProperties(Properties props) {
        if (props == null) {
            return null;
        }
        ArrayList<ExtendedProperty> list = new ArrayList<ExtendedProperty>();
        EList designProps = props.getProperties();
        int i = 0;
        while (i < designProps.size()) {
            Property prop = (Property)designProps.get(i);
            ExtendedProperty extendedProperty = StructureFactory.createExtendedProperty();
            extendedProperty.setName(prop.getName());
            extendedProperty.setValue(prop.getValue());
            list.add(extendedProperty);
            ++i;
        }
        return list;
    }

    protected void updateROMPublicProperties(Properties designProps, ReportElementHandle sourceHandle) throws SemanticException {
        if (designProps == null) {
            return;
        }
        EList publicProps = designProps.getProperties();
        int i = 0;
        while (i < publicProps.size()) {
            Property prop = (Property)publicProps.get(i);
            String propName = prop.getName();
            String propValue = prop.getValue();
            propValue = (String)PropertyValueValidationUtil.validateProperty((DesignElementHandle)sourceHandle, (String)propName, (Object)propValue);
            sourceHandle.getElement().setProperty(propName, (Object)propValue);
            ++i;
        }
    }

    protected void updateROMMessageFile(DataSourceDesign dsDesign, ModuleHandle root) throws SemanticException {
        if (dsDesign == null || root == null) {
            return;
        }
        String resourceFile = root.getIncludeResource();
        if (resourceFile != null) {
            return;
        }
        resourceFile = dsDesign.getResourceFile();
        if (resourceFile == null) {
            return;
        }
        if (!resourceFile.endsWith(RESOURCE_FILE_SUFFIX)) {
            throw new IllegalArgumentException("The DTP resource file must end with .properties");
        }
        int index = resourceFile.indexOf(RESOURCE_FILE_SUFFIX);
        resourceFile = resourceFile.substring(0, index);
        root.setIncludeResource(resourceFile);
    }

    protected void updateODAMessageFile(DataSourceDesign dsDesign, ModuleHandle root) {
        String resourceFile = root.getIncludeResource();
        if (resourceFile == null) {
            return;
        }
        resourceFile = String.valueOf(resourceFile) + RESOURCE_FILE_SUFFIX;
        dsDesign.setResourceFile(resourceFile);
    }
}

