/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import me.prettyprint.cassandra.serializers.AbstractSerializer;
import me.prettyprint.hector.api.exceptions.HectorSerializationException;

public class JaxbSerializer
extends AbstractSerializer<Object> {
    private ThreadLocal<Marshaller> marshaller;
    private ThreadLocal<Unmarshaller> unmarshaller;
    private static XMLOutputFactory outputFactory;
    private static XMLInputFactory inputFactory;

    public JaxbSerializer(final Class<?> ... serializableClasses) {
        this.marshaller = new ThreadLocal<Marshaller>(){

            @Override
            protected Marshaller initialValue() {
                try {
                    return JAXBContext.newInstance((Class[])serializableClasses).createMarshaller();
                }
                catch (JAXBException e) {
                    throw new IllegalArgumentException("Classes to serialize are not JAXB compatible.", e);
                }
            }
        };
        this.unmarshaller = new ThreadLocal<Unmarshaller>(){

            @Override
            protected Unmarshaller initialValue() {
                try {
                    return JAXBContext.newInstance((Class[])serializableClasses).createUnmarshaller();
                }
                catch (JAXBException e) {
                    throw new IllegalArgumentException("Classes to serialize are not JAXB compatible.", e);
                }
            }
        };
    }

    @Override
    public ByteBuffer toByteBuffer(Object obj) {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            XMLStreamWriter writer = this.createStreamWriter(buffer);
            this.marshaller.get().marshal(obj, writer);
            writer.flush();
            writer.close();
        }
        catch (JAXBException e) {
            throw new HectorSerializationException("Object to serialize " + obj + " does not seem compatible with the configured JaxbContext;" + " note this Serializer works only with JAXBable objects.", e);
        }
        catch (XMLStreamException e) {
            throw new HectorSerializationException("Exception occurred writing XML stream.", e);
        }
        return ByteBuffer.wrap(buffer.toByteArray());
    }

    @Override
    public Object fromByteBuffer(ByteBuffer bytes) {
        if (bytes == null || !bytes.hasRemaining()) {
            return null;
        }
        int l = bytes.remaining();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes.array(), bytes.arrayOffset() + bytes.position(), l);
        try {
            XMLStreamReader reader = this.createStreamReader(bais);
            Object ret = this.unmarshaller.get().unmarshal(reader);
            reader.close();
            return ret;
        }
        catch (JAXBException e) {
            throw new HectorSerializationException("Jaxb exception occurred during deserialization.", e);
        }
        catch (XMLStreamException e) {
            throw new HectorSerializationException("Exception reading XML stream.", e);
        }
    }

    protected XMLStreamWriter createStreamWriter(OutputStream output) throws XMLStreamException {
        if (outputFactory == null) {
            outputFactory = XMLOutputFactory.newInstance();
        }
        return outputFactory.createXMLStreamWriter(output);
    }

    protected XMLStreamReader createStreamReader(InputStream input) throws XMLStreamException {
        if (inputFactory == null) {
            inputFactory = XMLInputFactory.newInstance();
        }
        return inputFactory.createXMLStreamReader(input);
    }
}

