/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.service.ThriftCfDef;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.KsDef;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.NumberUtils;

public class ThriftKsDef
implements KeyspaceDefinition {
    private static final String REPLICATION_FACTOR = "replication_factor";
    public static final String DEF_STRATEGY_CLASS = "org.apache.cassandra.locator.SimpleStrategy";
    public static final String NETWORK_TOPOLOGY_STRATEGY = "org.apache.cassandra.locator.NetworkTopologyStrategy";
    private final String name;
    private String strategyClass;
    private Map<String, String> strategyOptions = new HashMap<String, String>();
    private final List<ColumnFamilyDefinition> cfDefs;
    private boolean durableWrites = true;

    public ThriftKsDef(KsDef k) {
        Assert.notNull(k, "KsDef is null");
        this.name = k.name;
        this.strategyClass = k.strategy_class;
        this.strategyOptions = k.strategy_options != null ? k.strategy_options : new HashMap();
        this.durableWrites = k.durable_writes;
        this.setReplicationFactor(NumberUtils.toInt((String)this.strategyOptions.get(REPLICATION_FACTOR), (int)1));
        this.cfDefs = ThriftCfDef.fromThriftList(k.cf_defs);
    }

    public ThriftKsDef(String keyspaceName, String strategyClass, int replicationFactor, List<ColumnFamilyDefinition> cfDefs) {
        this.name = keyspaceName;
        this.strategyClass = strategyClass;
        this.setReplicationFactor(replicationFactor);
        this.cfDefs = cfDefs;
    }

    public ThriftKsDef(String keyspaceName) {
        this.name = keyspaceName;
        this.cfDefs = new ArrayList<ColumnFamilyDefinition>();
        this.strategyClass = DEF_STRATEGY_CLASS;
        this.setReplicationFactor(1);
    }

    public ThriftKsDef(KeyspaceDefinition keyspaceDefinition) {
        this.name = keyspaceDefinition.getName();
        this.strategyClass = keyspaceDefinition.getStrategyClass();
        this.strategyOptions = keyspaceDefinition.getStrategyOptions();
        this.setReplicationFactor(keyspaceDefinition.getReplicationFactor());
        this.cfDefs = keyspaceDefinition.getCfDefs();
    }

    public static List<KeyspaceDefinition> fromThriftList(List<KsDef> ks) {
        if (ks == null || ks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KeyspaceDefinition> l = new ArrayList<KeyspaceDefinition>(ks.size());
        for (KsDef k : ks) {
            l.add(new ThriftKsDef(k));
        }
        return l;
    }

    public void addCfDef(CfDef cfDef) {
        this.cfDefs.add(new ThriftCfDef(cfDef));
    }

    public void addColumnFamilyDefinition(ColumnFamilyDefinition columnFamilyDefinition) {
        this.cfDefs.add(new ThriftCfDef(columnFamilyDefinition));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStrategyClass() {
        return this.strategyClass;
    }

    @Override
    public Map<String, String> getStrategyOptions() {
        return Collections.unmodifiableMap(this.strategyOptions);
    }

    @Override
    public int getReplicationFactor() {
        return NumberUtils.toInt((String)this.strategyOptions.get(REPLICATION_FACTOR), (int)1);
    }

    @Override
    public List<ColumnFamilyDefinition> getCfDefs() {
        return Collections.unmodifiableList(this.cfDefs);
    }

    public KsDef toThrift() {
        KsDef def = new KsDef(this.name, this.strategyClass, ThriftCfDef.toThriftList(this.cfDefs));
        def.setStrategy_options(this.strategyOptions);
        def.setDurable_writes(this.durableWrites);
        return def;
    }

    public void setStrategyClass(String strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setStrategyOptions(Map<String, String> strategyOptions) {
        this.strategyOptions = strategyOptions;
    }

    public void setReplicationFactor(int replicationFactor) {
        if (!StringUtils.equals((String)this.strategyClass, (String)NETWORK_TOPOLOGY_STRATEGY)) {
            this.strategyOptions.put(REPLICATION_FACTOR, Integer.toString(replicationFactor));
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public boolean isDurableWrites() {
        return this.durableWrites;
    }

    public void setDurableWrites(boolean durableWrites) {
        this.durableWrites = durableWrites;
    }
}

