/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.properties;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;

public class SetPropertyValueCommand
extends Command {
    protected static final Object DEFAULT_VALUE = new Object();
    private Object newValue;
    private Object oldValue;
    private Object propertyId;
    private IPropertySource propertySource;

    public SetPropertyValueCommand(String propertyLabel, IPropertySource propertySource, Object propertyId, Object newValue) {
        super(MessageFormat.format((String)GEFMessages.SetPropertyValueCommand_Label, (Object[])new Object[]{propertyLabel}).trim());
        this.propertySource = propertySource;
        this.propertyId = propertyId;
        this.newValue = newValue;
    }

    @Override
    public boolean canExecute() {
        if (this.propertySource == null || this.propertyId == null) {
            return false;
        }
        if (this.newValue == DEFAULT_VALUE) {
            boolean canExecute = this.propertySource.isPropertySet(this.propertyId);
            if (this.propertySource instanceof IPropertySource2) {
                canExecute &= ((IPropertySource2)this.propertySource).isPropertyResettable(this.propertyId);
            }
            return canExecute;
        }
        return true;
    }

    @Override
    public void execute() {
        boolean wasPropertySet = this.propertySource.isPropertySet(this.propertyId);
        this.oldValue = this.unwrapValue(this.propertySource.getPropertyValue(this.propertyId));
        if (this.newValue == DEFAULT_VALUE) {
            this.propertySource.resetPropertyValue(this.propertyId);
        } else {
            this.propertySource.setPropertyValue(this.propertyId, this.unwrapValue(this.newValue));
        }
        if (this.propertySource instanceof IPropertySource2) {
            if (!wasPropertySet && ((IPropertySource2)this.propertySource).isPropertyResettable(this.propertyId)) {
                this.oldValue = DEFAULT_VALUE;
            }
        } else if (!wasPropertySet && this.propertySource.isPropertySet(this.propertyId)) {
            this.oldValue = DEFAULT_VALUE;
        }
    }

    protected Object getNewValue() {
        return this.newValue;
    }

    protected Object getOldValue() {
        return this.oldValue;
    }

    protected Object getPropertyId() {
        return this.propertyId;
    }

    protected IPropertySource getPropertySource() {
        return this.propertySource;
    }

    @Override
    public void redo() {
        this.execute();
    }

    @Override
    public void undo() {
        if (this.oldValue == DEFAULT_VALUE) {
            this.propertySource.resetPropertyValue(this.propertyId);
        } else {
            this.propertySource.setPropertyValue(this.propertyId, this.oldValue);
        }
    }

    private Object unwrapValue(Object value) {
        if (value instanceof IPropertySource) {
            return ((IPropertySource)value).getEditableValue();
        }
        return value;
    }
}

