/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import me.prettyprint.cassandra.connection.ConcurrentHClientPool;
import me.prettyprint.cassandra.connection.HClientPool;
import me.prettyprint.cassandra.connection.LoadBalancingPolicy;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.service.CassandraHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeastActiveBalancingPolicy
implements LoadBalancingPolicy {
    private static final long serialVersionUID = 329849818218657061L;
    private static final Logger log = LoggerFactory.getLogger(LeastActiveBalancingPolicy.class);

    @Override
    public HClientPool getPool(Collection<HClientPool> pools, Set<CassandraHost> excludeHosts) {
        ArrayList vals = Lists.newArrayList(pools);
        Collections.shuffle(vals);
        Collections.sort(vals, new ShufflingCompare());
        Iterator iterator = vals.iterator();
        HClientPool concurrentHClientPool = (HClientPool)iterator.next();
        if (excludeHosts != null && excludeHosts.size() > 0) {
            while (iterator.hasNext() && excludeHosts.contains(concurrentHClientPool.getCassandraHost())) {
                concurrentHClientPool = (ConcurrentHClientPool)iterator.next();
            }
        }
        return concurrentHClientPool;
    }

    @Override
    public HClientPool createConnection(HClientFactory clientFactory, CassandraHost host) {
        return new ConcurrentHClientPool(clientFactory, host);
    }

    private final class ShufflingCompare
    implements Comparator<HClientPool> {
        private ShufflingCompare() {
        }

        @Override
        public int compare(HClientPool o1, HClientPool o2) {
            if (log.isDebugEnabled()) {
                log.debug("comparing 1: {} and count {} with 2: {} and count {}", new Object[]{o1.getCassandraHost(), o1.getNumActive(), o2.getCassandraHost(), o2.getNumActive()});
            }
            return o1.getNumActive() - o2.getNumActive();
        }
    }
}

