/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.handlers;

import java.util.HashMap;
import java.util.Optional;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.handlers.AbstractFileHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleHandleImpl;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.resources.IFile;

public final class RunReportHandler
extends AbstractFileHandler {
    @Override
    protected void execute(IFile file) throws Exception {
        String url = file.getLocation().toOSString();
        ReportDesignHandle handle = null;
        try {
            handle = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(url);
            if (!UIUtil.canPreviewWithErrors((ModuleHandle)handle)) {
                return;
            }
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("FORMAT_KEY", "html");
            options.put("RESOURCE_FOLDER_KEY", ReportPlugin.getDefault().getResourceFolder(file.getProject()));
            WebViewer.display((String)url, options);
        }
        finally {
            Optional.ofNullable(handle).ifPresent(ModuleHandleImpl::close);
        }
    }
}

