/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.impl.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.oda.pojo.api.IPojoDataSet;
import org.eclipse.birt.data.oda.pojo.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class PojoDataSetFromCustomClass
implements IPojoDataSet {
    private static Logger logger = Logger.getLogger(PojoDataSetFromCustomClass.class.getName());
    private Class dataSetClass;
    private Object instance;
    private Method openMethod;
    private Method nextMethod;
    private Method closeMethod;

    public PojoDataSetFromCustomClass(Class dataSetClass) throws OdaException {
        assert (dataSetClass != null);
        this.dataSetClass = dataSetClass;
        try {
            this.openMethod = this.dataSetClass.getMethod("open", Object.class, Map.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.log(Level.WARNING, "failed to locate open(Object appContext) method ", e);
        }
        try {
            this.nextMethod = this.dataSetClass.getMethod("next", null);
            if (this.nextMethod.getReturnType().isPrimitive()) {
                throw new OdaException(Messages.getString("PojoDataSetFromCustomerClass.WrongReturnTypeForNextMethod"));
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new OdaException((Throwable)e);
        }
        try {
            this.closeMethod = this.dataSetClass.getMethod("close", null);
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.log(Level.WARNING, "failed to locate close( ) method ", e);
        }
        try {
            this.instance = dataSetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OdaException((Throwable)e);
        }
    }

    @Override
    public void close() throws OdaException {
        if (this.closeMethod != null) {
            try {
                this.closeMethod.invoke(this.instance, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new OdaException((Throwable)e);
            }
        }
    }

    @Override
    public Object next() throws OdaException {
        try {
            return this.nextMethod.invoke(this.instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new OdaException((Throwable)e);
        }
    }

    @Override
    public void open(Object appContext, Map<String, Object> dataSetParamValues) throws OdaException {
        if (this.openMethod != null) {
            try {
                this.openMethod.invoke(this.instance, appContext, dataSetParamValues);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new OdaException((Throwable)e);
            }
        }
    }
}

