/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.YieldStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.text.edits.TextEditGroup;

public class SwitchExpressionsFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static SwitchExpressionsFixCore createConvertToSwitchExpressionFix(SwitchStatement switchStatement) {
        CompilationUnit root = (CompilationUnit)switchStatement.getRoot();
        if (!JavaModelUtil.is14OrHigher(root.getJavaElement().getJavaProject())) {
            return null;
        }
        ArrayList<SwitchExpressionsFixOperation> operations = new ArrayList<SwitchExpressionsFixOperation>();
        SwitchStatementsFinder finder = new SwitchStatementsFinder(operations);
        switchStatement.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        return new SwitchExpressionsFixCore(FixMessages.SwitchExpressionsFix_convert_to_switch_expression, root, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{(CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation)operations.get(0)});
    }

    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit) {
        if (!JavaModelUtil.is14OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        ArrayList<SwitchExpressionsFixOperation> operations = new ArrayList<SwitchExpressionsFixOperation>();
        SwitchStatementsFinder finder = new SwitchStatementsFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[operations.size()]);
        return new SwitchExpressionsFixCore(FixMessages.SwitchExpressionsFix_convert_to_switch_expression, compilationUnit, ops);
    }

    protected SwitchExpressionsFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static class SwitchExpressionsFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final SwitchStatement switchStatement;
        private final Map<SwitchCase, List<Statement>> caseMap;
        private final boolean createReturnStatement;
        private final String varName;
        private final IBinding assignmentBinding;

        public SwitchExpressionsFixOperation(SwitchStatement switchStatement, Map<SwitchCase, List<Statement>> caseMap, boolean createReturnStatement, String varName, IBinding assignmentBinding) {
            this.switchStatement = switchStatement;
            this.caseMap = caseMap;
            this.createReturnStatement = createReturnStatement;
            this.varName = varName;
            this.assignmentBinding = assignmentBinding;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            SwitchCase oldSwitchCase;
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = rewrite.getAST();
            TextEditGroup group = this.createTextEditGroup(FixMessages.SwitchExpressionsFix_convert_to_switch_expression, cuRewrite);
            SwitchExpression newSwitchExpression = ast.newSwitchExpression();
            Expression newSwitchExpressionExpression = (Expression)rewrite.createCopyTarget((ASTNode)this.switchStatement.getExpression());
            newSwitchExpression.setExpression(newSwitchExpressionExpression);
            SwitchCase lastSwitchCase = null;
            boolean forceOldStyle = false;
            for (Map.Entry<SwitchCase, List<Statement>> entry : this.caseMap.entrySet()) {
                oldSwitchCase = entry.getKey();
                List<Comment> trailingComments = ASTNodes.getTrailingComments((ASTNode)oldSwitchCase);
                if (trailingComments == null || trailingComments.isEmpty()) continue;
                forceOldStyle = true;
                break;
            }
            block1: for (Map.Entry<SwitchCase, List<Statement>> entry : this.caseMap.entrySet()) {
                SwitchCase newSwitchCase;
                oldSwitchCase = entry.getKey();
                List oldStatements = entry.getValue();
                if (oldStatements.isEmpty()) {
                    if (forceOldStyle) {
                        SwitchCase newSwitchCase2 = (SwitchCase)rewrite.createCopyTarget((ASTNode)oldSwitchCase);
                        newSwitchExpression.statements().add(newSwitchCase2);
                        continue;
                    }
                    if (lastSwitchCase == null) {
                        lastSwitchCase = ast.newSwitchCase();
                        lastSwitchCase.setSwitchLabeledRule(true);
                        newSwitchExpression.statements().add(lastSwitchCase);
                    }
                    for (Object obj : oldSwitchCase.expressions()) {
                        Expression oldExpression = (Expression)obj;
                        Expression newExpression = (Expression)rewrite.createCopyTarget((ASTNode)oldExpression);
                        lastSwitchCase.expressions().add(newExpression);
                    }
                    continue;
                }
                SwitchCase switchCase = null;
                boolean needDuplicateDefault = false;
                if (forceOldStyle) {
                    newSwitchCase = (SwitchCase)rewrite.createCopyTarget((ASTNode)oldSwitchCase);
                    newSwitchExpression.statements().add(newSwitchCase);
                } else {
                    if (lastSwitchCase == null) {
                        newSwitchCase = ast.newSwitchCase();
                        newSwitchExpression.statements().add(newSwitchCase);
                        newSwitchCase.setSwitchLabeledRule(true);
                        switchCase = newSwitchCase;
                    } else {
                        switchCase = lastSwitchCase;
                    }
                    if (lastSwitchCase != null && oldSwitchCase.expressions().isEmpty()) {
                        needDuplicateDefault = true;
                    }
                    lastSwitchCase = null;
                    for (Object obj : oldSwitchCase.expressions()) {
                        Expression oldExpression = (Expression)obj;
                        Expression newExpression = (Expression)rewrite.createCopyTarget((ASTNode)oldExpression);
                        switchCase.expressions().add(newExpression);
                    }
                }
                while (true) {
                    if (oldStatements.size() == 1 && oldStatements.get(0) instanceof Block) {
                        oldStatements = ((Block)oldStatements.get(0)).statements();
                    }
                    if (oldStatements.size() == 1) {
                        Statement oldStatement = oldStatements.get(0);
                        Object newStatement = null;
                        if (oldStatement instanceof ThrowStatement) {
                            ThrowStatement throwStatement = (ThrowStatement)oldStatement;
                            newStatement = (Statement)rewrite.createCopyTarget((ASTNode)throwStatement);
                        } else {
                            newStatement = oldStatement instanceof ReturnStatement && this.createReturnStatement ? this.getNewStatementFromReturn(cuRewrite, rewrite, (ReturnStatement)oldStatement) : (forceOldStyle ? this.getNewYieldStatement(cuRewrite, rewrite, (ExpressionStatement)oldStatement) : this.getNewStatementForCase(cuRewrite, rewrite, oldStatement));
                        }
                        newSwitchExpression.statements().add(newStatement);
                    } else {
                        Block newBlock = ast.newBlock();
                        int statementsLen = oldStatements.size();
                        int i = 0;
                        while (i < statementsLen - 1) {
                            Statement oldSwitchCaseStatement = (Statement)oldStatements.get(i);
                            newBlock.statements().add(rewrite.createCopyTarget((ASTNode)oldSwitchCaseStatement));
                            ++i;
                        }
                        Statement lastStatement = (Statement)oldStatements.get(statementsLen - 1);
                        YieldStatement newYield = null;
                        newYield = lastStatement instanceof ReturnStatement ? this.getNewYieldStatementFromReturn(cuRewrite, rewrite, (ReturnStatement)oldStatements.get(statementsLen - 1)) : this.getNewYieldStatement(cuRewrite, rewrite, (ExpressionStatement)oldStatements.get(statementsLen - 1));
                        newBlock.statements().add(newYield);
                        newSwitchExpression.statements().add(newBlock);
                    }
                    if (!needDuplicateDefault) continue block1;
                    needDuplicateDefault = false;
                    newSwitchCase = ast.newSwitchCase();
                    newSwitchExpression.statements().add(newSwitchCase);
                    newSwitchCase.setSwitchLabeledRule(true);
                    switchCase = newSwitchCase;
                }
            }
            ReturnStatement newExpressionStatement = null;
            if (this.createReturnStatement) {
                ReturnStatement newReturnStatement = ast.newReturnStatement();
                newReturnStatement.setExpression((Expression)newSwitchExpression);
                newExpressionStatement = newReturnStatement;
            } else {
                if (this.assignmentBinding instanceof IVariableBinding) {
                    ASTNode parent;
                    VariableDeclarationStatement varDeclarationStatement = null;
                    int varIndex = -2;
                    IVariableBinding binding = (IVariableBinding)this.assignmentBinding;
                    if (!binding.isField() && !binding.isParameter() && !binding.isSynthetic() && (parent = this.switchStatement.getParent()) instanceof Block) {
                        Block block = (Block)parent;
                        List statements = block.statements();
                        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                        int i = 0;
                        while (i < statements.size()) {
                            Statement statement = (Statement)statements.get(i);
                            if (statement instanceof VariableDeclarationStatement) {
                                IVariableBinding fragBinding;
                                VariableDeclarationFragment fragment;
                                VariableDeclarationStatement decl = (VariableDeclarationStatement)statement;
                                List fragments = decl.fragments();
                                if (fragments.size() == 1 && (fragment = (VariableDeclarationFragment)fragments.get(0)).getInitializer() == null && (fragBinding = fragment.resolveBinding()) != null && fragBinding.isEqualTo((IBinding)binding)) {
                                    varDeclarationStatement = decl;
                                    varIndex = i;
                                }
                            } else if (statement instanceof SwitchStatement && statement.subtreeMatch(new ASTMatcher(), (Object)this.switchStatement)) {
                                if (varIndex != i - 1) break;
                                VariableDeclarationFragment newVarFragment = ast.newVariableDeclarationFragment();
                                newVarFragment.setName(ast.newSimpleName(this.varName));
                                newVarFragment.setInitializer((Expression)newSwitchExpression);
                                VariableDeclarationStatement newVar = ast.newVariableDeclarationStatement(newVarFragment);
                                ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                                newVar.setType(importRewrite.addImport(((IVariableBinding)this.assignmentBinding).getType(), ast));
                                if (varDeclarationStatement != null && Modifier.isFinal(varDeclarationStatement.getModifiers())) {
                                    newVar.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
                                }
                                this.replaceWithLeadingComments(cuRewrite, listRewrite, (ASTNode)varDeclarationStatement, group, (ASTNode)newVar);
                                listRewrite.remove((ASTNode)this.switchStatement, group);
                                return;
                            }
                            ++i;
                        }
                    }
                }
                Assignment newAssignment = ast.newAssignment();
                newExpressionStatement = ast.newExpressionStatement((Expression)newAssignment);
                newAssignment.setLeftHandSide((Expression)ast.newName(this.varName));
                newAssignment.setRightHandSide((Expression)newSwitchExpression);
            }
            ASTNode parent = this.switchStatement.getParent();
            if (parent instanceof Block) {
                ListRewrite listRewrite = rewrite.getListRewrite(parent, Block.STATEMENTS_PROPERTY);
                this.replaceWithLeadingComments(cuRewrite, listRewrite, (ASTNode)this.switchStatement, group, (ASTNode)newExpressionStatement);
            } else {
                rewrite.replace((ASTNode)this.switchStatement, (ASTNode)newExpressionStatement, group);
            }
        }

        private Statement getNewStatementFromReturn(CompilationUnitRewrite cuRewrite, ASTRewrite rewrite, ReturnStatement oldStatement) throws JavaModelException {
            Expression exp = oldStatement.getExpression();
            IBuffer buffer = cuRewrite.getCu().getBuffer();
            StringBuilder b = new StringBuilder();
            List<Comment> leadingComments = ASTNodes.getLeadingComments((ASTNode)oldStatement);
            for (Comment comment : leadingComments) {
                if (comment.isLineComment()) {
                    b.append("/*" + buffer.getText(comment.getStartPosition() + 2, comment.getLength() - 2) + " */ ");
                    continue;
                }
                b.append(String.valueOf(buffer.getText(comment.getStartPosition(), comment.getLength())) + " ");
            }
            b.append(String.valueOf(buffer.getText(exp.getStartPosition(), exp.getLength())) + ";");
            List<Comment> trailingComments = ASTNodes.getTrailingComments((ASTNode)oldStatement);
            for (Comment comment : trailingComments) {
                b.append(" " + buffer.getText(comment.getStartPosition(), comment.getLength()));
            }
            Statement newStatement = (Statement)rewrite.createStringPlaceholder(b.toString(), 21);
            return newStatement;
        }

        private Statement getNewStatementForCase(CompilationUnitRewrite cuRewrite, ASTRewrite rewrite, Statement oldStatement) throws JavaModelException {
            ExpressionStatement oldExpStatement = (ExpressionStatement)oldStatement;
            Assignment oldAssignment = (Assignment)oldExpStatement.getExpression();
            Expression rhs = oldAssignment.getRightHandSide();
            IBuffer buffer = cuRewrite.getCu().getBuffer();
            StringBuilder b = new StringBuilder();
            List<Comment> leadingComments = ASTNodes.getLeadingComments((ASTNode)oldExpStatement);
            for (Comment comment : leadingComments) {
                if (comment.isLineComment()) {
                    b.append("/*" + buffer.getText(comment.getStartPosition() + 2, comment.getLength() - 2) + " */ ");
                    continue;
                }
                b.append(String.valueOf(buffer.getText(comment.getStartPosition(), comment.getLength())) + " ");
            }
            b.append(String.valueOf(buffer.getText(rhs.getStartPosition(), rhs.getLength())) + ";");
            List<Comment> trailingComments = ASTNodes.getTrailingComments((ASTNode)oldExpStatement);
            for (Comment comment : trailingComments) {
                b.append(" " + buffer.getText(comment.getStartPosition(), comment.getLength()));
            }
            Statement newStatement = (Statement)rewrite.createStringPlaceholder(b.toString(), 21);
            return newStatement;
        }

        private YieldStatement getNewYieldStatement(CompilationUnitRewrite cuRewrite, ASTRewrite rewrite, ExpressionStatement oldExpStatement) throws JavaModelException {
            Assignment oldAssignment = (Assignment)oldExpStatement.getExpression();
            Expression rhs = oldAssignment.getRightHandSide();
            IBuffer buffer = cuRewrite.getCu().getBuffer();
            StringBuilder b = new StringBuilder();
            List<Comment> leadingComments = ASTNodes.getLeadingComments((ASTNode)oldExpStatement);
            for (Comment comment : leadingComments) {
                b.append(String.valueOf(buffer.getText(comment.getStartPosition(), comment.getLength())) + "\n");
            }
            b.append("yield ");
            List<Comment> trailingComments = ASTNodes.getTrailingComments((ASTNode)oldExpStatement);
            b.append(String.valueOf(buffer.getText(rhs.getStartPosition(), rhs.getLength())) + ";");
            for (Comment comment : trailingComments) {
                b.append(" " + buffer.getText(comment.getStartPosition(), comment.getLength()));
            }
            YieldStatement newYield = (YieldStatement)rewrite.createStringPlaceholder(b.toString(), 101);
            Expression newYieldExpression = (Expression)rewrite.createStringPlaceholder(b.toString(), rhs.getNodeType());
            newYield.setExpression(newYieldExpression);
            return newYield;
        }

        private YieldStatement getNewYieldStatementFromReturn(CompilationUnitRewrite cuRewrite, ASTRewrite rewrite, ReturnStatement oldStatement) throws JavaModelException {
            Expression exp = oldStatement.getExpression();
            IBuffer buffer = cuRewrite.getCu().getBuffer();
            StringBuilder b = new StringBuilder();
            List<Comment> leadingComments = ASTNodes.getLeadingComments((ASTNode)oldStatement);
            for (Comment comment : leadingComments) {
                b.append(String.valueOf(buffer.getText(comment.getStartPosition(), comment.getLength())) + "\n");
            }
            b.append("yield ");
            List<Comment> trailingComments = ASTNodes.getTrailingComments((ASTNode)oldStatement);
            b.append(String.valueOf(buffer.getText(exp.getStartPosition(), exp.getLength())) + ";");
            for (Comment comment : trailingComments) {
                b.append(" " + buffer.getText(comment.getStartPosition(), comment.getLength()));
            }
            YieldStatement newYield = (YieldStatement)rewrite.createStringPlaceholder(b.toString(), 101);
            Expression newYieldExpression = (Expression)rewrite.createStringPlaceholder(b.toString(), exp.getNodeType());
            newYield.setExpression(newYieldExpression);
            return newYield;
        }

        private void replaceWithLeadingComments(CompilationUnitRewrite cuRewrite, ListRewrite listRewrite, ASTNode oldNode, TextEditGroup group, ASTNode newNode) throws JavaModelException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            List<Comment> comments = ASTNodes.getLeadingComments(oldNode);
            if (!comments.isEmpty()) {
                Comment firstComment = comments.get(0);
                String commentString = cuRewrite.getCu().getBuffer().getText(firstComment.getStartPosition(), firstComment.getLength());
                ASTNode lastComment = rewrite.createStringPlaceholder(commentString, firstComment.isBlockComment() ? 64 : 63);
                listRewrite.replace(oldNode, lastComment, group);
                int j = 1;
                while (j < comments.size()) {
                    Comment comment = comments.get(j);
                    commentString = cuRewrite.getCu().getBuffer().getText(comment.getStartPosition(), comment.getLength());
                    ASTNode newComment = rewrite.createStringPlaceholder(commentString, comment.isBlockComment() ? 64 : 63);
                    listRewrite.insertAfter(newComment, lastComment, group);
                    lastComment = newComment;
                    ++j;
                }
                listRewrite.insertAfter(newNode, lastComment, group);
            } else {
                listRewrite.replace(oldNode, newNode, group);
            }
        }
    }

    public static final class SwitchStatementsFinder
    extends ASTVisitor {
        private List<SwitchExpressionsFixOperation> fResult;

        public SwitchStatementsFinder(List<SwitchExpressionsFixOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(SwitchStatement node) {
            SwitchExpressionsFixOperation operation = this.getOperation(node);
            if (operation != null) {
                this.fResult.add(operation);
            }
            return true;
        }

        private boolean isInvalidStatement(Statement statement) {
            return statement instanceof ContinueStatement || statement instanceof ForStatement || statement instanceof IfStatement || statement instanceof DoStatement || statement instanceof EnhancedForStatement || statement instanceof SwitchStatement || statement instanceof YieldStatement || statement instanceof TryStatement || statement instanceof WhileStatement;
        }

        private SwitchExpressionsFixOperation getOperation(SwitchStatement switchStatement) {
            ITypeBinding binding;
            List entryStatements;
            ArrayList<SwitchCase> throwList = new ArrayList<SwitchCase>();
            ArrayList<SwitchCase> returnList = new ArrayList<SwitchCase>();
            boolean defaultFound = false;
            ArrayList<Statement> currentBlock = null;
            SwitchCase currentCase = null;
            LinkedHashMap<SwitchCase, List<Statement>> caseMap = new LinkedHashMap<SwitchCase, List<Statement>>();
            for (Statement statement : switchStatement.statements()) {
                if (statement instanceof SwitchCase) {
                    SwitchCase switchCase = (SwitchCase)statement;
                    if (switchCase.isDefault()) {
                        defaultFound = true;
                    }
                    if (currentBlock != null && !currentBlock.isEmpty()) {
                        return null;
                    }
                    if (currentCase != null) {
                        caseMap.put(currentCase, currentBlock);
                    }
                    currentBlock = new ArrayList<Statement>();
                    currentCase = switchCase;
                    continue;
                }
                if (statement instanceof ReturnStatement) {
                    returnList.add(currentCase);
                    if (currentBlock == null) {
                        return null;
                    }
                    currentBlock.add(statement);
                    caseMap.put(currentCase, currentBlock);
                    currentBlock = null;
                    currentCase = null;
                    continue;
                }
                if (this.isInvalidStatement(statement)) {
                    return null;
                }
                if (statement instanceof BreakStatement) {
                    if (currentBlock != null && currentBlock.isEmpty()) {
                        return null;
                    }
                    if (currentCase != null) {
                        caseMap.put(currentCase, currentBlock);
                    }
                    currentBlock = null;
                    currentCase = null;
                    continue;
                }
                if (statement instanceof ThrowStatement) {
                    throwList.add(currentCase);
                    if (currentBlock == null) {
                        return null;
                    }
                    currentBlock.add(statement);
                    caseMap.put(currentCase, currentBlock);
                    currentBlock = null;
                    currentCase = null;
                    continue;
                }
                if (currentBlock == null) {
                    return null;
                }
                boolean blockComplete = false;
                if (statement instanceof Block) {
                    Block block = (Block)statement;
                    Iterator blockIter = block.statements().iterator();
                    while (blockIter.hasNext()) {
                        Statement blockStatement = (Statement)blockIter.next();
                        if (this.isInvalidStatement(blockStatement) || blockStatement instanceof Block) {
                            return null;
                        }
                        if (blockStatement instanceof ThrowStatement) {
                            if (blockIter.hasNext()) {
                                return null;
                            }
                            blockComplete = true;
                            throwList.add(currentCase);
                        }
                        if (!(blockStatement instanceof ReturnStatement)) continue;
                        if (blockIter.hasNext()) {
                            return null;
                        }
                        blockComplete = true;
                        returnList.add(currentCase);
                    }
                }
                currentBlock.add(statement);
                if (!blockComplete) continue;
                caseMap.put(currentCase, currentBlock);
                currentBlock = null;
                currentCase = null;
            }
            if (currentCase != null) {
                if (currentBlock != null && currentBlock.isEmpty()) {
                    return null;
                }
                caseMap.put(currentCase, currentBlock);
            }
            String commonAssignmentName = null;
            IBinding assignmentBinding = null;
            boolean createReturnStatement = false;
            if (returnList.size() > 0) {
                createReturnStatement = true;
                int caseCount = 0;
                for (Map.Entry entry : caseMap.entrySet()) {
                    entryStatements = (List)entry.getValue();
                    if (entryStatements.size() <= 0) continue;
                    ++caseCount;
                }
                if (returnList.size() + throwList.size() < caseCount) {
                    return null;
                }
            } else {
                for (Map.Entry entry : caseMap.entrySet()) {
                    Expression exp;
                    SwitchCase entryCase = (SwitchCase)entry.getKey();
                    entryStatements = (List)entry.getValue();
                    if (throwList.contains(entryCase) || entryStatements.size() == 0) continue;
                    Statement lastStatement = (Statement)entryStatements.get(entryStatements.size() - 1);
                    if (lastStatement instanceof Block) {
                        List blockStatements = ((Block)lastStatement).statements();
                        if (blockStatements.isEmpty()) continue;
                        lastStatement = (Statement)blockStatements.get(blockStatements.size() - 1);
                    }
                    if (!(lastStatement instanceof ExpressionStatement) || !(((ExpressionStatement)lastStatement).getExpression() instanceof Assignment)) {
                        return null;
                    }
                    Assignment assignment = (Assignment)((ExpressionStatement)lastStatement).getExpression();
                    if (assignment.getOperator() != Assignment.Operator.ASSIGN) {
                        return null;
                    }
                    if (commonAssignmentName == null) {
                        exp = assignment.getLeftHandSide();
                        if (exp instanceof Name) {
                            commonAssignmentName = ((Name)exp).getFullyQualifiedName();
                            assignmentBinding = ((Name)exp).resolveBinding();
                            continue;
                        }
                        return null;
                    }
                    exp = assignment.getLeftHandSide();
                    if (exp instanceof Name) {
                        Name name = (Name)exp;
                        if (name.getFullyQualifiedName().equals(commonAssignmentName)) continue;
                        return null;
                    }
                    return null;
                }
                if (assignmentBinding == null) {
                    return null;
                }
            }
            if ((binding = switchStatement.getExpression().resolveTypeBinding()) != null && binding.isEnum()) {
                IVariableBinding[] fields = binding.getDeclaredFields();
                int enumCount = 0;
                IVariableBinding[] iVariableBindingArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariableBinding field = iVariableBindingArray[n2];
                    if (field.isEnumConstant()) {
                        ++enumCount;
                    }
                    ++n2;
                }
                if (enumCount != caseMap.size() && !defaultFound) {
                    return null;
                }
            } else if (!defaultFound) {
                return null;
            }
            return new SwitchExpressionsFixOperation(switchStatement, caseMap, createReturnStatement, commonAssignmentName, assignmentBinding);
        }
    }
}

