/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views;

import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValues;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.delete.DeleteViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect.FullSelectViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect.ValuesRowViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect.ValuesViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.insert.InsertViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.select.SelectViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.update.UpdateViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.with.WithStatementViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.with.WithTableViewer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class DesignViewer
extends PageBook {
    Control fullSelect;
    Control valuesRowPage;
    Control valuesClause;
    Control withStatement;
    Control withTable;
    Control split;
    SelectViewer selectViewer;
    InsertViewer insertViewer;
    UpdateViewer updateViewer;
    DeleteViewer deleteViewer;
    WithStatementViewer withStatementViewer;
    WithTableViewer withTableViewer;
    FullSelectViewer fullSelectViewer;
    ValuesRowViewer valuesRowViewer;
    ValuesViewer valuesViewer;
    SQLDomainModel sqlDomainModel;
    private Object previousObject;

    public DesignViewer(SQLDomainModel domainModel, Composite parent) {
        super(parent, 0);
        this.sqlDomainModel = domainModel;
        this.createControl((Composite)this);
    }

    public SQLDomainModel getDomainModel() {
        return this.sqlDomainModel;
    }

    void createControl(Composite parent) {
        this.selectViewer = new SelectViewer(this.sqlDomainModel);
        this.selectViewer.createControl(parent);
        this.insertViewer = new InsertViewer(this.sqlDomainModel);
        this.insertViewer.createControl(parent);
        this.insertViewer.setDesignViewer(this);
        this.updateViewer = new UpdateViewer(this.sqlDomainModel);
        this.updateViewer.createControl(parent);
        this.deleteViewer = new DeleteViewer(this.sqlDomainModel);
        this.deleteViewer.createControl(parent);
        this.withStatementViewer = new WithStatementViewer(this.sqlDomainModel);
        this.withStatement = this.withStatementViewer.createControl(parent);
        this.withTableViewer = new WithTableViewer(this.sqlDomainModel);
        this.withTable = this.withTableViewer.createControl(parent);
        this.fullSelectViewer = new FullSelectViewer(this.sqlDomainModel);
        this.fullSelect = this.fullSelectViewer.createControl(parent);
        this.valuesRowViewer = new ValuesRowViewer(this.sqlDomainModel);
        this.valuesRowPage = this.valuesRowViewer.createControl(parent);
        this.valuesViewer = new ValuesViewer(this.sqlDomainModel);
        this.valuesClause = this.valuesViewer.createControl(parent);
    }

    public void inputChanged(Object input) {
        this.previousObject = input;
        if (input instanceof QueryInsertStatement) {
            this.showPage(this.insertViewer.getControl());
            this.insertViewer.setInput(input);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0010");
        } else if (input instanceof QueryUpdateStatement) {
            this.showPage(this.updateViewer.getControl());
            this.updateViewer.setInput(input);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0100");
        } else if (input instanceof QueryDeleteStatement) {
            this.showPage(this.deleteViewer.getControl());
            this.deleteViewer.setInput(input);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0200");
        } else if (input instanceof QuerySelectStatement) {
            QueryExpressionBody queryBody = SelectHelper.getQueryExpressionBody((QuerySelectStatement)input);
            if (queryBody instanceof QuerySelect) {
                this.selectViewer.setInput(input);
                this.showPage(this.selectViewer.getControl());
                QuerySelectStatement sqlSelectStatement = (QuerySelectStatement)input;
                EList withClause = sqlSelectStatement.getQueryExpr().getWithClause();
                if (withClause.isEmpty()) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0300");
                } else {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0500");
                }
            } else if (queryBody instanceof QueryCombined) {
                this.showPage(this.fullSelect);
                this.fullSelectViewer.setInput(queryBody);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0400");
            } else if (queryBody instanceof QueryValues) {
                this.showPage(this.valuesRowPage);
                this.valuesRowViewer.setInput(queryBody);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0600");
            } else {
                this.selectViewer.setInput(input);
                this.showPage(this.selectViewer.getControl());
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0300");
            }
        } else if (input instanceof WithTableSpecification) {
            this.showPage(this.withTable);
            this.withTableViewer.setInput(input);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0800");
        } else if (input instanceof QuerySelect) {
            this.selectViewer.setInput(input);
            this.showPage(this.selectViewer.getControl());
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0300");
        } else if (input instanceof QueryCombined) {
            this.showPage(this.fullSelect);
            this.fullSelectViewer.setInput(input);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0400");
        } else if (input instanceof QueryValues) {
            this.showPage(this.valuesClause);
            this.valuesViewer.setInput(input);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0600");
        } else if (input instanceof ValuesRow) {
            this.showPage(this.valuesRowPage);
            this.valuesRowViewer.setInput(input);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0700");
        }
    }

    public void forceRefresh() {
        this.inputChanged(this.previousObject);
    }

    public void setEnabled(boolean enable) {
        this.selectViewer.setEnabled(enable);
        this.insertViewer.setEnabled(enable);
        this.updateViewer.setEnabled(enable);
        this.deleteViewer.setEnabled(enable);
        this.withStatementViewer.setEnabled(enable);
        this.fullSelectViewer.setEnabled(enable);
        super.setEnabled(enable);
    }
}

