/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.designer.ui.dialogs.BindingExpressionProvider;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.swt.graphics.Image;

public class CrosstabExpressionProvider
extends BindingExpressionProvider {
    public CrosstabExpressionProvider(DesignElementHandle handle, ComputedColumnHandle computedColumnHandle) {
        super(handle, computedColumnHandle);
        this.addFilterToProvider();
    }

    protected void addFilterToProvider() {
    }

    protected List getChildrenList(Object parent) {
        if (parent instanceof DimensionHandle) {
            ArrayList<LevelHandle> children = new ArrayList<LevelHandle>();
            try {
                DimensionViewHandle dimensionHandle;
                DimensionHandle handle = (DimensionHandle)parent;
                CrosstabReportItemHandle xtabHandle = this.getCrosstabReportItemHandle();
                int i = 0;
                while (i < xtabHandle.getDimensionCount(0)) {
                    dimensionHandle = xtabHandle.getDimension(0, i);
                    if (dimensionHandle.getCubeDimension().equals(handle)) {
                        children.add(dimensionHandle.getLevel(0).getCubeLevel());
                    }
                    ++i;
                }
                i = 0;
                while (i < xtabHandle.getDimensionCount(1)) {
                    dimensionHandle = xtabHandle.getDimension(1, i);
                    if (dimensionHandle.getCubeDimension().equals(handle)) {
                        children.add(dimensionHandle.getLevel(0).getCubeLevel());
                    }
                    ++i;
                }
            }
            catch (ExtendedElementException handle) {
                // empty catch block
            }
            return children;
        }
        if (parent instanceof LevelHandle) {
            ArrayList<LevelHandle> children = new ArrayList<LevelHandle>();
            LevelHandle levelHandle = (LevelHandle)parent;
            try {
                LevelViewHandle levelViewHandle;
                DimensionViewHandle dimensionHandle;
                CrosstabReportItemHandle xtabHandle = this.getCrosstabReportItemHandle();
                int i = 0;
                while (i < xtabHandle.getDimensionCount(0)) {
                    dimensionHandle = xtabHandle.getDimension(0, i);
                    levelViewHandle = dimensionHandle.getLevel(levelHandle.getQualifiedName());
                    if (levelViewHandle != null && dimensionHandle.getLevelCount() > levelViewHandle.getIndex() + 1) {
                        children.add(dimensionHandle.getLevel(levelViewHandle.getIndex() + 1).getCubeLevel());
                    }
                    ++i;
                }
                i = 0;
                while (i < xtabHandle.getDimensionCount(1)) {
                    dimensionHandle = xtabHandle.getDimension(1, i);
                    levelViewHandle = dimensionHandle.getLevel(levelHandle.getQualifiedName());
                    if (levelViewHandle != null && dimensionHandle.getLevelCount() > levelViewHandle.getIndex() + 1) {
                        children.add(dimensionHandle.getLevel(levelViewHandle.getIndex() + 1).getCubeLevel());
                    }
                    ++i;
                }
            }
            catch (ExtendedElementException extendedElementException) {
                // empty catch block
            }
            return children;
        }
        return super.getChildrenList(parent);
    }

    protected CrosstabReportItemHandle getCrosstabReportItemHandle() throws ExtendedElementException {
        return (CrosstabReportItemHandle)((ExtendedItemHandle)this.elementHandle).getReportItem();
    }

    public String getDisplayText(Object element) {
        if (element instanceof LevelViewHandle) {
            return ((LevelViewHandle)element).getCubeLevel().getName();
        }
        return super.getDisplayText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof LevelViewHandle) {
            return UIHelper.getImage((String)"icons/obj16/level.gif");
        }
        return super.getImage(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof LevelHandle) {
            return this.getChildrenList(element).size() > 0;
        }
        return super.hasChildren(element);
    }
}

