/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;

public abstract class AbstractSyntaxColoringPage
extends PreferencePage {
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fSelectionForegroundColor;
    private Color fSelectionBackgroundColor;
    private final IPropertyChangeListener fListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionForeground".equals(property) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionBackground".equals(property) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(property)) {
                AbstractSyntaxColoringPage.this.initializeSourcePreviewColors(AbstractSyntaxColoringPage.this.getSourcePreviewViewer());
            }
        }
    };

    public AbstractSyntaxColoringPage() {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (store != null) {
            store.addPropertyChangeListener(this.fListener);
        }
    }

    protected void initializeSourcePreviewColors(ISourceViewer viewer) {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (store != null && viewer != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = store.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.fForegroundColor != null) {
                this.fForegroundColor.dispose();
            }
            this.fForegroundColor = color;
            color = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
            color = store.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.SelectionForeground", styledText.getDisplay());
            styledText.setSelectionForeground(color);
            if (this.fSelectionForegroundColor != null) {
                this.fSelectionForegroundColor.dispose();
            }
            this.fSelectionForegroundColor = color;
            color = store.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.SelectionBackground", styledText.getDisplay());
            styledText.setSelectionBackground(color);
            if (this.fSelectionBackgroundColor != null) {
                this.fSelectionBackgroundColor.dispose();
            }
            this.fSelectionBackgroundColor = color;
        }
    }

    protected ISourceViewer getSourcePreviewViewer() {
        return null;
    }

    public void dispose() {
        IPreferenceStore store;
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fSelectionForegroundColor != null) {
            this.fSelectionForegroundColor.dispose();
            this.fSelectionForegroundColor = null;
        }
        if (this.fSelectionBackgroundColor != null) {
            this.fSelectionBackgroundColor.dispose();
            this.fSelectionBackgroundColor = null;
        }
        if (this.fListener != null && (store = EditorsUI.getPreferenceStore()) != null) {
            store.removePropertyChangeListener(this.fListener);
        }
        super.dispose();
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }
}

