/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.birt.core.format.IFormatter;
import org.eclipse.birt.core.i18n.CoreMessages;

public class StringFormatter
implements IFormatter {
    protected static Logger logger = Logger.getLogger(StringFormatter.class.getName());
    protected String formatPattern;
    private ULocale locale = ULocale.getDefault();
    private char chcase;
    private int nand;
    private int natt;
    private boolean dir;
    private boolean trim;

    private void init() {
        this.formatPattern = "";
        this.chcase = (char)32;
        this.nand = 0;
        this.natt = 0;
        this.dir = false;
        this.trim = true;
    }

    public StringFormatter() {
        this.applyPattern(null);
    }

    public StringFormatter(ULocale locale) {
        this.locale = locale;
        this.applyPattern(null);
    }

    @Deprecated
    public StringFormatter(Locale locale) {
        this(ULocale.forLocale((Locale)locale));
    }

    public StringFormatter(String format) {
        this.applyPattern(format);
    }

    public StringFormatter(String format, ULocale locale) {
        this.locale = locale;
        this.applyPattern(format);
    }

    @Deprecated
    public StringFormatter(String format, Locale locale) {
        this(format, ULocale.forLocale((Locale)locale));
    }

    public void applyPattern(String format) {
        this.init();
        if (format == null) {
            return;
        }
        int c = 32;
        StringBuilder scan = new StringBuilder(format);
        int len = scan.length();
        int i = 0;
        while (i < len) {
            c = scan.charAt(i);
            switch (c) {
                case 64: {
                    ++this.natt;
                    break;
                }
                case 38: {
                    ++this.nand;
                    break;
                }
                case 60: 
                case 62: {
                    this.chcase = (char)c;
                    break;
                }
                case 33: {
                    this.dir = true;
                    break;
                }
                case 94: {
                    this.trim = false;
                }
            }
            ++i;
        }
        if ("Zip Code + 4".equalsIgnoreCase(format)) {
            this.applyPattern("@@@@@-@@@@");
            return;
        }
        if ("Phone Number".equalsIgnoreCase(format)) {
            this.applyPattern("(@@@)@@@-@@@@");
            return;
        }
        if ("Social Security Number".equalsIgnoreCase(format)) {
            this.applyPattern("@@@-@@-@@@@");
            return;
        }
        this.formatPattern = format;
    }

    public String getPattern() {
        return this.formatPattern;
    }

    public ULocale getULocale() {
        return this.locale;
    }

    @Deprecated
    public Locale getLocale() {
        return this.getULocale().toLocale();
    }

    public void setLocale(ULocale theLocale) {
        this.locale = theLocale;
    }

    @Deprecated
    public void setLocale(Locale theLocale) {
        this.setLocale(ULocale.forLocale((Locale)theLocale));
    }

    private String handleCase(String val, char option) {
        if (option == '<') {
            return UCharacter.toLowerCase((ULocale)this.locale, (String)val);
        }
        if (option == '>') {
            return UCharacter.toUpperCase((ULocale)this.locale, (String)val);
        }
        return val;
    }

    public String format(String str) {
        if (this.trim && str != null) {
            str = str.trim();
        }
        if (this.formatPattern == null || this.formatPattern.length() == 0 || this.formatPattern.equals("Unformatted")) {
            return str;
        }
        int len = str.length();
        int col = this.natt + this.nand;
        int ext = 0;
        StringBuilder orig = new StringBuilder(str);
        StringBuilder fstr = new StringBuilder(this.formatPattern);
        StringBuilder ret = new StringBuilder("");
        int i = 0;
        int pos = 0;
        char fc = ' ';
        String sc = null;
        if (!this.dir) {
            if (len > col) {
                ret.append(this.handleCase(orig.substring(0, len - col), this.chcase));
                pos = len - col;
                len = col;
            }
            ext = col - len;
        }
        int len2 = this.formatPattern.length();
        i = 0;
        while (i < len2) {
            fc = fstr.charAt(i);
            switch (fc) {
                case '&': 
                case '@': {
                    if (ext > 0 || len == 0) {
                        if (fc == '@') {
                            ret.append(' ');
                        }
                        --ext;
                        break;
                    }
                    sc = orig.substring(pos, pos + 1);
                    ret.append(this.handleCase(sc, this.chcase));
                    ++pos;
                    --len;
                    break;
                }
                case '!': 
                case '<': 
                case '>': 
                case '^': {
                    break;
                }
                default: {
                    ret.append(fc);
                }
            }
            ++i;
        }
        while (--len >= 0) {
            sc = orig.substring(pos, pos + 1);
            ret.append(this.handleCase(sc, this.chcase));
            ++pos;
        }
        return ret.toString();
    }

    public String parser(String str) throws ParseException {
        int k;
        int lenFormatStr;
        if (this.formatPattern == null || "".equals(this.formatPattern) || this.formatPattern.indexOf(">") > -1 || this.formatPattern.indexOf("<") > -1) {
            return str;
        }
        StringBuilder orig = new StringBuilder(str);
        StringBuilder fstr = new StringBuilder("");
        StringBuilder ret = new StringBuilder("");
        int i = 0;
        while (i < this.formatPattern.length()) {
            if (this.formatPattern.charAt(i) != '!' && this.formatPattern.charAt(i) != '>' && this.formatPattern.charAt(i) != '<' && this.formatPattern.charAt(i) != '^') {
                fstr.append(this.formatPattern.charAt(i));
            }
            ++i;
        }
        int fc = 32;
        int lenPattern = fstr.length();
        if (lenPattern > (lenFormatStr = orig.length())) {
            if (this.dir) {
                k = lenFormatStr;
                while (k < lenPattern) {
                    if (fstr.charAt(k) != '&') {
                        throw new ParseException(CoreMessages.getFormattedString("error.UnparseableString", orig.toString()), k);
                    }
                    orig.append(" ");
                    ++k;
                }
            } else {
                k = 0;
                while (k < lenPattern - lenFormatStr) {
                    if (fstr.charAt(lenPattern - lenFormatStr - k - 1) != '&') {
                        throw new ParseException(CoreMessages.getFormattedString("error.UnparseableString", orig.toString()), 0);
                    }
                    orig.insert(0, " ");
                    ++k;
                }
            }
        } else if (lenPattern < lenFormatStr) {
            if (this.dir) {
                k = lenPattern;
                while (k < lenFormatStr) {
                    fstr.append('&');
                    ++k;
                }
            } else {
                k = lenPattern;
                while (k < lenFormatStr) {
                    fstr.insert(0, '&');
                    ++k;
                }
            }
        }
        int index = 0;
        int count = lenPattern > lenFormatStr ? lenPattern : lenFormatStr;
        int i2 = 0;
        while (i2 < count) {
            fc = fstr.charAt(i2);
            switch (fc) {
                case 64: {
                    if (orig.charAt(index) != ' ') {
                        ret.append(orig.charAt(index));
                    }
                    ++index;
                    break;
                }
                case 38: {
                    ret.append(orig.charAt(index));
                    ++index;
                    break;
                }
                case 60: 
                case 62: {
                    return str;
                }
                default: {
                    if (orig.charAt(index) != fstr.charAt(i2)) {
                        throw new ParseException(CoreMessages.getFormattedString("error.UnparseableString", orig.toString()), index);
                    }
                    ++index;
                }
            }
            ++i2;
        }
        return ret.toString();
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    @Override
    public String formatValue(Object value) {
        assert (value instanceof String);
        return this.format((String)value);
    }
}

