/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.net.URL;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IResourceKeyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;

public class ResourceKeyDescriptorProvider
extends PropertyDescriptorProvider
implements IResourceKeyDescriptorProvider {
    private int groupIndex;

    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    public ResourceKeyDescriptorProvider(String property, String element) {
        super(property, element);
    }

    @Override
    public String[] getBaseNames() {
        List resources = SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResources();
        if (resources == null) {
            return null;
        }
        return resources.toArray(new String[0]);
    }

    @Override
    public URL[] getResourceURLs() {
        String[] baseNames = this.getBaseNames();
        if (baseNames == null) {
            return null;
        }
        URL[] urls = new URL[baseNames.length];
        int i = 0;
        while (i < baseNames.length) {
            urls[i] = SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(baseNames[i], 5);
            ++i;
        }
        return urls;
    }

    @Override
    public String getBrowseText() {
        return this.groupIndex == 0 ? Messages.getString((String)"ResourceKeyDescriptor.text.Browse") : Messages.getString((String)"ResourceKeyDescriptor.text.Browse.Alt");
    }

    @Override
    public String getResetText() {
        return this.groupIndex == 0 ? Messages.getString((String)"ResourceKeyDescriptor.text.Reset") : Messages.getString((String)"ResourceKeyDescriptor.text.Reset.Alt");
    }

    @Override
    public boolean isEnable() {
        return DEUtil.getInputSize((Object)this.input) <= 1;
    }

    @Override
    public String getBrowseTooltipText() {
        return Messages.getString((String)"ResourceKeyDescriptor.button.browse.tooltip");
    }

    @Override
    public String getResetTooltipText() {
        return Messages.getString((String)"ResourceKeyDescriptor.button.reset.tooltip");
    }
}

