/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.inchron.hw;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.PortType;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="Inchron-HW-Memory-PortTypeResponder", checks={"HW ports of memory should be of type responder"})
public class InchronHWMemoryPortTypeCheck
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getMemory();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof Memory) {
            Memory mem = (Memory)eObject;
            EList listPorts = mem.getPorts();
            for (HwPort port : listPorts) {
                if (port.getPortType() == PortType.RESPONDER) continue;
                this.addIssue(results, (EObject)mem, (EStructuralFeature)ePackage.getHwModule_Ports(), "Memory " + this.name((INamed)mem) + " has a HW port " + this.name((INamed)port) + " of type not equal to RESPONDER");
            }
        }
    }
}

