/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.svg;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwModule;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.visualizations.svg.Context;
import org.eclipse.app4mc.amalthea.visualizations.svg.HardwareStructureConfig;
import org.eclipse.app4mc.visualization.util.svg.PlantUmlDiagram;

public class HardwareStructureGenerator {
    private HardwareStructureGenerator() {
        throw new IllegalStateException("Utility class");
    }

    public static void updateDiagram(Context context) {
        LocalContext lc = HardwareStructureGenerator.createLocalContext(context);
        if (lc == null) {
            return;
        }
        lc.diagram.resetDiagramData();
        lc.diagram.append("' Created by HardwareStructureGenerator (" + HardwareStructureGenerator.timestamp() + ")");
        HardwareStructureGenerator.buildContent(lc);
    }

    private static void buildContent(LocalContext lc) {
        lc.diagram.append("\n\n@startuml");
        lc.diagram.append("\n\n' ===== Hardware Structure (as PlantUML frames/components) =====");
        HardwareStructureGenerator.generateStructures(lc);
        lc.diagram.append("\n\n@enduml");
    }

    private static void generateStructures(LocalContext lc) {
        if (!lc.structures.isEmpty()) {
            lc.diagram.append("\n\n' ===== FRAMES (structures and modules) =====");
            for (HwStructure hwStruct : lc.structures) {
                HardwareStructureGenerator.generateLevels(lc, "", hwStruct);
            }
            lc.diagram.append("\n\n' ===== ROUTES (physical and logical connections) =====");
            for (HwStructure hwStruct : lc.structures) {
                HardwareStructureGenerator.generateRoutes(lc, "", hwStruct);
            }
        }
        lc.diagram.append("\n\nskinparam component {");
        lc.diagram.append("\n\tbackgroundColor<<ProcessingUnit>> #8CACFF");
        lc.diagram.append("\n\tborderColor<<ProcessingUnit>> #000000");
        lc.diagram.append("\n\tbackgroundColor<<ConnectionHandler>> #FFFFA0");
        lc.diagram.append("\n\tborderColor<<ConnectionHandler>> #000000");
        lc.diagram.append("\n\tbackgroundColor<<Memory>> #60FF82");
        lc.diagram.append("\n\tborderColor<<Memory>> #000000");
        lc.diagram.append("\n\tbackgroundColor<<Cache>> #C8FFA6");
        lc.diagram.append("\n\tborderColor<<Cache>> #000000");
        lc.diagram.append("\n\tArrowFontColor #C0C0C0");
        lc.diagram.append("\n}");
    }

    private static void generateLevels(LocalContext lc, String prefix, HwStructure s) {
        if (s == null) {
            return;
        }
        String id = lc.diagram.getOrCreateId((Object)s);
        lc.components.add(id);
        lc.diagram.append("\n\n");
        lc.diagram.append(prefix);
        lc.diagram.append("frame ");
        lc.diagram.appendName(s.getName());
        lc.diagram.append(" as ");
        lc.diagram.append(id);
        lc.diagram.append(" {");
        if (lc.config.isShowModules()) {
            for (HwModule m : s.getModules()) {
                HardwareStructureGenerator.addLevel(lc, String.valueOf(prefix) + "\t", m);
            }
        }
        for (HwStructure su : s.getStructures()) {
            HardwareStructureGenerator.generateLevels(lc, String.valueOf(prefix) + "\t", su);
        }
        lc.diagram.append("\n");
        lc.diagram.append(prefix);
        lc.diagram.append("}\n");
        lc.diagram.append(prefix);
        lc.diagram.append("url of " + id + " is [[#" + id + "]]");
    }

    private static void addLevel(LocalContext lc, String prefix, HwModule m) {
        if (m == null) {
            return;
        }
        String id = lc.diagram.getOrCreateId((Object)m);
        String command = "component \"" + m.getName() + "\" as " + id + " <<" + m.eClass().getName() + ">>";
        if (!lc.commands.contains(command)) {
            lc.commands.add(command);
            lc.components.add(id);
            lc.diagram.append("\n");
            lc.diagram.append(prefix);
            lc.diagram.append(command);
            lc.diagram.append("\n");
            lc.diagram.append(prefix);
            lc.diagram.append("url of " + id + " is [[#" + id + "]]");
        }
    }

    private static void generateRoutes(LocalContext lc, String prefix, HwStructure s) {
        if (s == null) {
            return;
        }
        if (lc.config.isShowPhysicalConnections()) {
            HardwareStructureGenerator.addPhysicalConnections(lc, s);
        }
        if (lc.config.isShowModules() && lc.config.isShowLogicalConnections()) {
            HardwareStructureGenerator.addLogicalConnections(lc, s);
        }
        for (HwStructure su : s.getStructures()) {
            HardwareStructureGenerator.generateRoutes(lc, String.valueOf(prefix) + "\t", su);
        }
    }

    private static void addPhysicalConnections(LocalContext lc, HwStructure s) {
        if (!s.getConnections().isEmpty()) {
            lc.diagram.append("\n\n' add physical connections of structure ");
            lc.diagram.append(s.getName());
            lc.diagram.append(":");
            for (HwConnection c : s.getConnections()) {
                INamed container1 = c.getPort1() == null ? null : (INamed)c.getPort1().eContainer();
                INamed container2 = c.getPort2() == null ? null : (INamed)c.getPort2().eContainer();
                HardwareStructureGenerator.addRoute(lc, container1, container2, (INamed)c, " -- ");
            }
        }
    }

    private static void addLogicalConnections(LocalContext lc, HwStructure s) {
        for (HwModule m : s.getModules()) {
            ProcessingUnit pu;
            if (!(m instanceof ProcessingUnit) || (pu = (ProcessingUnit)m).getAccessElements().isEmpty()) continue;
            lc.diagram.append("\n\n' add logical connections of processing unit ");
            lc.diagram.append(pu.getName());
            lc.diagram.append(":");
            for (HwAccessElement ae : pu.getAccessElements()) {
                if (ae.getDestination() == null) continue;
                HardwareStructureGenerator.addRoute(lc, (INamed)pu, (INamed)ae.getDestination(), (INamed)ae, " ..> ");
            }
        }
    }

    private static void addRoute(LocalContext lc, INamed source, INamed destination, INamed con, String conType) {
        if (source == null || destination == null) {
            return;
        }
        String id1 = lc.diagram.getOrCreateId((Object)source);
        String id2 = lc.diagram.getOrCreateId((Object)destination);
        String conLabel = con.getName() == null || con.getName().isEmpty() ? con.toString() : con.getName();
        String command = String.valueOf(id1) + conType + id2 + " : " + conLabel;
        if (!lc.commands.contains(command)) {
            lc.commands.add(command);
            if (lc.components.add(id1)) {
                lc.diagram.append("\n\tcomponent ");
                lc.diagram.appendName(source.getName());
                lc.diagram.append(" as " + id1);
            }
            if (lc.components.add(id2)) {
                lc.diagram.append("\n\tcomponent ");
                lc.diagram.appendName(destination.getName());
                lc.diagram.append(" as " + id2);
            }
            lc.diagram.append("\n\t");
            lc.diagram.append(command);
        }
    }

    static String timestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        return dateFormat.format(new Date());
    }

    private static LocalContext createLocalContext(Context context) {
        if (context.object instanceof List && context.config instanceof HardwareStructureConfig && context.diagram instanceof PlantUmlDiagram) {
            ArrayList<HwStructure> hwStructures = new ArrayList<HwStructure>();
            for (Object object : (List)context.object) {
                if (!(object instanceof HwStructure)) continue;
                hwStructures.add((HwStructure)object);
            }
            return new LocalContext(hwStructures, (HardwareStructureConfig)context.config, (PlantUmlDiagram)context.diagram);
        }
        return null;
    }

    private static class LocalContext {
        public final List<HwStructure> structures;
        public final HardwareStructureConfig config;
        public final PlantUmlDiagram diagram;
        public final Set<String> commands = new HashSet<String>();
        public final Set<String> components = new HashSet<String>();

        public LocalContext(List<HwStructure> structures, HardwareStructureConfig config, PlantUmlDiagram diagram) {
            this.structures = structures;
            this.config = config;
            this.diagram = diagram;
        }
    }
}

