/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.predefined;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StandardSchedulers {
    private static final String ALGORITHM_PARAMETERS = "\nAlgorithm parameters:\n";
    private static final String PROCESS_PARAMETERS = "\nProcess parameters:\n";
    private static final String OPTIONS = "\nOptions:\n";
    private static final String REFERENCE = "\nReference:\n";
    private static final String NO_ITEMS = " -\n";
    private static final String PASSES_PARAMETERS_UPWARDS = " - passes parameters upwards\n";
    private static final String HAS_EXACTLY_ONE_CHILD = " - has exactly one child\n";
    private static final String REQUIRES_PARENT_SCHEDULER = " - requires parent scheduler\n";
    private static final String LIU_LAYLAND_1973 = " - Liu, Chung Laung, and James W. Layland (1973).\n   \"Scheduling Algorithms for Multiprogramming in a Hard-Real-Time Environment\"\n   Journal of the ACM (JACM) 20.1 (1973): 46-61.\n";
    private static final String SPRUNT_SHA_LEHOCZKY_1989 = " - Sprunt, Brinkley, Lui Sha, and John Lehoczky (1989).\n   \"Aperiodic Task Scheduling for Hard Real-Time Systems\"\n   Real-Time Systems 1(1):27-60, DOI:10.1007/BF02341920\n";
    private static final String AUDSLEY_1990 = " - Audsley, Neil (1990).\n   \"Deadline Monotonic Scheduling\"\n";
    private static final String STROSNIDER_LEHOCZKY_SHA_1995 = " - Strosnider, Jay K., John P. Lehoczky, and Lui Sha (1995).\n   \"The Deferrable Server Algorithm for Enhanced Aperiodic Responsiveness in Hard Real-Time Environments\"\n   IEEE Transactions on Computers 44.1 (1995): 73-91.\n";
    private static final String ABENI_BUTTAZZO_1998 = " - Abeni, Luca, and Giorgio Buttazzo (1998).\n   \"Integrating Multimedia Applications in Hard Real-Time Systems\"\n   Proceedings 19th IEEE Real-Time Systems Symposium (Cat. No. 98CB36279). IEEE, 1998.\n";
    private static final String CACCAMO_BUTTAZZO_SHA_2000 = " - M. Caccamo, G. Buttazzo and Lui Sha (2000).\n   \"Capacity sharing for overrun control\"\n   Proceedings 21st IEEE Real-Time Systems Symposium, 2000, pp. 295-304, doi: 10.1109/REAL.2000.896018.\n";
    private static final String ANDERSON_SRINIVASAN_2001 = " - J. H. Anderson and A. Srinivasan.\n   \"Mixed Pfair/ERfair scheduling of asynchronous periodic tasks\"\n   Proceedings 13th Euromicro Conference on Real-Time Systems, 2001, pp. 76-85, doi: 10.1109/EMRTS.2001.934004.\n";
    private static final String BUTTAZZO_2004 = " - Buttazzo, Giorgio (2004).\n   \"Real-Time Computing Systems - Predictable Scheduling Algorithms and Applications\"\n   Springer Publications, Chapter 5, DOI:10.1007/0-387-27578-9\n";
    private static final String OSEK_2005 = " - OSEK/VDX - Operating System Specification 2.2.3 (2005)\n";
    private static final String DEUBZER_MARGULL_MOTTOK = " - Deubzer, Michael & Margull, Ulrich & Mottok, Juergen & Niemetz, M. & Wirrer, G. (2010).\n   \"Efficient scheduling of reliable automotive multi-core systems with pd2 by weakening erfair tasksystem requirements\"\n   Lecture Notes in Informatics (LNI), Proceedings - Series of the Gesellschaft fur Informatik (GI). 53-68.\n";
    private static final String ZOUAOUI_BOUSSAID_ABDELLATIF_2019 = " - Zouaoui, Sonia & Boussaid, Lotfi & Abdellatif, Mtibaa (2019).\n   \"Priority based round robin (PBRR) CPU scheduling algorithm\"\n   International Journal of Electrical and Computer Engineering (IJECE),\n   9. 190. 10.11591/ijece.v9i1.pp190-202.\n";
    private static final Map<String, Parameter> PARAMETERS = Arrays.stream(Parameter.values()).collect(Collectors.toMap(Parameter::getParameterName, Function.identity()));
    private static final Map<String, Algorithm> ALGORITHMS = Arrays.stream(Algorithm.values()).collect(Collectors.toMap(Algorithm::getAlgorithmName, Function.identity()));

    private StandardSchedulers() {
        throw new IllegalStateException("Utility class");
    }

    public static Algorithm getAlgorithm(String algorithmName) {
        return ALGORITHMS.get(algorithmName);
    }

    public static Parameter getParameter(String parameterName) {
        return PARAMETERS.get(parameterName);
    }

    public static List<Parameter> getAllParametersOfAlgorithm(String algorithmName) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        Algorithm algo = ALGORITHMS.get(algorithmName);
        if (algo != null) {
            result.addAll(algo.getAlgorithmParameters());
            result.addAll(algo.getProcessParameters());
        }
        return result;
    }

    public static List<Parameter> getAlgorithmParametersOfAlgorithm(String algorithmName) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        Algorithm algo = ALGORITHMS.get(algorithmName);
        if (algo != null) {
            result.addAll(algo.getAlgorithmParameters());
        }
        return result;
    }

    public static List<Parameter> getProcessParametersOfAlgorithm(String algorithmName) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        Algorithm algo = ALGORITHMS.get(algorithmName);
        if (algo != null) {
            result.addAll(algo.getProcessParameters());
        }
        return result;
    }

    public static enum Algorithm {
        GROUPING_SERVER("GroupingServer", "This is not a scheduler algorithm. Schedulers using this definition\nact as a logical grouping of tasks/child-schedulers, e.g. a partition\nfor some tasks for budget accounting reasons.\n\nThis scheduler does not take any scheduling decisions,\nand a parent scheduler is mandatory.\n\nAlgorithm parameters:\n - capacity [1] Time\n      The fixed budget that can be used by processes.\n      It will be replenished periodically.\n - period [1] Time\n      Amount of time after which the capacity will be replenished.\n\nProcess parameters:\n -\n\nOptions:\n - passes parameters upwards\n - requires parent scheduler\n", new Parameter[]{Parameter.CAPACITY, Parameter.PERIOD}, new Parameter[0], false, true, true),
        PRIORITY_BASED("PriorityBased", "???\n\nAlgorithm parameters:\n -\n\nProcess parameters:\n - priority [1] Integer\n      The priority of the process (a higher value means a higher priority).\n\nOptions:\n -\n", new Parameter[0], new Parameter[]{Parameter.PRIORITY}, false, false, false),
        OSEK("OSEK", "OSEK compliant Scheduling. A fixed priority preemptive scheduling algorithm\nwith task groups. Tasks belonging to the same task group are scheduled\ncooperatively (they do not preempt each other), preemptive otherwise.\nTasks with the same priority also behave cooperatively.\n\nAlgorithm parameters:\n -\n\nProcess parameters:\n - priority [1] Integer\n      The priority of the process (a higher value means a higher priority).\n - taskGroup [1] Integer\n      The OSEK task group number (if for two processes the number is equal,\n      that means they are in the same task group).\n\nOptions:\n -\n\nReference:\n - OSEK/VDX - Operating System Specification 2.2.3 (2005)\n", new Parameter[0], new Parameter[]{Parameter.PRIORITY, Parameter.TASK_GROUP}, false, false, false),
        FIXED_PRIORITY_PREEMPTIVE("FixedPriorityPreemptive", "Fixed Priority Preemptive Scheduling (e.g. AUTOSAR),\nsame as OSEK but without task groups.\n\nAlgorithm parameters:\n -\n\nProcess parameters:\n - priority [1] Integer\n      The priority of the process (a higher value means a higher priority).\n\nOptions:\n -\n\nReference:\n - Liu, Chung Laung, and James W. Layland (1973).\n   \"Scheduling Algorithms for Multiprogramming in a Hard-Real-Time Environment\"\n   Journal of the ACM (JACM) 20.1 (1973): 46-61.\n", new Parameter[0], new Parameter[]{Parameter.PRIORITY}, false, false, false),
        FIXED_PRIORITY_PREEMPTIVE_WITH_BUDGET_ENFORCEMENT("FixedPriorityPreemptiveWithBudgetEnforcement", "Works like the Fixed Priority Preemptive Scheduling. But it is possible\nto put budget boundaries on the execution. Prevents low priority tasks \nfrom starving if a higher priority task is trying to constantly occupy the\nCPU (safety insurance, bounding the execution time of sporadic loads).\n\nAlgorithm parameters:\n -\n\nProcess parameters:\n - priority [1] Integer\n      The priority of the process (a higher value means a higher priority).\n - minBudget [1] Time\n      The guaranteed amount of budget available to the process within the replenishment period.\n - maxBudget [1] Time\n      The upper bound of the budget available to the process within the replenishment period.\n      Sets a limit to the usage of a process even if the CPU would be idle\n      (important for algorithms with payback mechanisms).\n - replenishment [1] Time\n      The periodic time interval after which the budget is set to the configured value.\n\nOptions:\n -\n", new Parameter[0], new Parameter[]{Parameter.PRIORITY, Parameter.MIN_BUDGET, Parameter.MAX_BUDGET, Parameter.REPLENISHMENT}, false, false, false),
        DEADLINE_MONOTONIC("DeadlineMonotonic", "This is not a scheduling algorithm, it only describes how to derive priorities for a\nfixed priority scheduler: Task with the shortest deadline gets the highest priority.\n\nAlgorithm parameters:\n -\n\nProcess parameters:\n - deadline [1] Time\n      The time after each activation at which the process must finish.\n\nOptions:\n -\n\nReference:\n - Audsley, Neil (1990).\n   \"Deadline Monotonic Scheduling\"\n", new Parameter[0], new Parameter[]{Parameter.DEADLINE}, false, false, false),
        RATE_MONOTONIC("RateMonotonic", "This is not a scheduling algorithm, it only describes how to derive priorities for a\nfixed priority scheduler: Task with the shortest period gets the highest priority.\n\nAlgorithm parameters:\n -\n\nProcess parameters:\n - period [1] Integer\n      The time span after the previous activation at which\n      the next instance of the process shall be activated.\n\nOptions:\n -\n\nReference:\n - Liu, Chung Laung, and James W. Layland (1973).\n   \"Scheduling Algorithms for Multiprogramming in a Hard-Real-Time Environment\"\n   Journal of the ACM (JACM) 20.1 (1973): 46-61.\n", new Parameter[0], new Parameter[]{Parameter.PERIOD}, false, false, false),
        EARLIEST_DEADLINE_FIRST("EarliestDeadlineFirst", "Earliest Deadline First (EDF): The task with the closest deadline in relation\nto the current point in time will be scheduled next.\n\nAlgorithm parameters:\n -\n\nProcess parameters:\n - deadline [1] Time\n      The time after each activation at which the process must finish.\n\nOptions:\n -\n\nReference:\n - Liu, Chung Laung, and James W. Layland (1973).\n   \"Scheduling Algorithms for Multiprogramming in a Hard-Real-Time Environment\"\n   Journal of the ACM (JACM) 20.1 (1973): 46-61.\n", new Parameter[0], new Parameter[]{Parameter.DEADLINE}, false, false, false),
        LEAST_LOCAL_REMAINING_EXECUTION_TIME_FIRST("LeastLocalRemainingExecutionTimeFirst", "Least Local Remaining Execution-time First (LLREF): Task with the\nsmallest local remaining execution time will be scheduled next.\n\nAlgorithm parameters:\n -\n\nProcess parameters:\n - executionTime [1] Time\n      The time which the process will use until it is finished\n      (usually the worst case execution time is used here in order\n      to guarantee that the process can finish).\n\nOptions:\n -\n", new Parameter[0], new Parameter[]{Parameter.EXECUTION_TIME}, false, false, false),
        PRIORITY_BASED_ROUND_ROBIN("PriorityBasedRoundRobin", "Round Robin scheduling algorithm assigns equally sized time slices\nto each process that it schedules. The priority describes the order\nin which the processes will be executed. If two processes have the\nsame priority, the order of these two is random (non-deterministic).\n\nAlgorithm parameters:\n - timeSliceLength [1] Time\n      Length of each time slice.\n\nProcess parameters:\n - priority [1] Integer\n      The priority of the process (a higher value means a higher priority).\n\nOptions:\n -\n\nReference:\n - Zouaoui, Sonia & Boussaid, Lotfi & Abdellatif, Mtibaa (2019).\n   \"Priority based round robin (PBRR) CPU scheduling algorithm\"\n   International Journal of Electrical and Computer Engineering (IJECE),\n   9. 190. 10.11591/ijece.v9i1.pp190-202.\n", new Parameter[]{Parameter.TIME_SLICE_LENGTH}, new Parameter[]{Parameter.PRIORITY}, false, false, false),
        P_FAIR_PD2("PFairPD2", "Proportionate Fair PD2 Scheduling (Pfair-PD2).\n\nAlgorithm parameters:\n - quantSize [0..1] Time = 1ns\n      Length of the minimum schedulable time slot used in Pfair scheduling.\n      It is assumed that execution times are an integer multiple of this\n      time slot length.\n\nProcess parameters:\n -\n\nOptions:\n -\n\nReference:\n - J. H. Anderson and A. Srinivasan.\n   \"Mixed Pfair/ERfair scheduling of asynchronous periodic tasks\"\n   Proceedings 13th Euromicro Conference on Real-Time Systems, 2001, pp. 76-85, doi: 10.1109/EMRTS.2001.934004.\n", new Parameter[]{Parameter.QUANT_SIZE}, new Parameter[0], false, false, false),
        PARTLY_P_FAIR_PD2("PartlyPFairPD2", "Partly Proportionate Fair PD2 Scheduling (PPfair-PD2).\n\nAlgorithm parameters:\n - quantSize [0..1] Time = 1ns\n      Length of the minimum schedulable time slot used in Pfair scheduling.\n      It is assumed that execution times are an integer multiple of this\n      time slot length.\n\nProcess parameters:\n -\n\nOptions:\n -\n", new Parameter[]{Parameter.QUANT_SIZE}, new Parameter[0], false, false, false),
        EARLY_RELEASE_FAIR_PD2("EarlyReleaseFairPD2", "Early Release Fair PD2 Scheduling (ERfair-PD2).\n\nAlgorithm parameters:\n - quantSize [0..1] Time = 1ns\n      Length of the minimum schedulable time slot used in Pfair scheduling.\n      It is assumed that execution times are an integer multiple of this\n      time slot length.\n\nProcess parameters:\n -\n\nOptions:\n -\n\nReference:\n - Deubzer, Michael & Margull, Ulrich & Mottok, Juergen & Niemetz, M. & Wirrer, G. (2010).\n   \"Efficient scheduling of reliable automotive multi-core systems with pd2 by weakening erfair tasksystem requirements\"\n   Lecture Notes in Informatics (LNI), Proceedings - Series of the Gesellschaft fur Informatik (GI). 53-68.\n", new Parameter[]{Parameter.QUANT_SIZE}, new Parameter[0], false, false, false),
        PARTLY_EARLY_RELEASE_FAIR_PD2("PartlyEarlyReleaseFairPD2", "Partly Early Release Fair PD2 Scheduling (P-ERfair-PD2).\n\nAlgorithm parameters:\n - quantSize [0..1] Time = 1ns\n      Length of the minimum schedulable time slot used in Pfair scheduling.\n      It is assumed that execution times are an integer multiple of this\n      time slot length.\n\nProcess parameters:\n -\n\nOptions:\n -\n", new Parameter[]{Parameter.QUANT_SIZE}, new Parameter[0], false, false, false),
        DEFERRABLE_SERVER("DeferrableServer", "Deferrable Server (DS): provides a fixed budget,\nin which the budget replenishment is done periodically.\n\nAlgorithm parameters:\n - capacity [1] Time\n      The fixed budget that can be used by processes.\n      It will be replenished periodically.\n - period [1] Time\n      Amount of time after which the capacity will be replenished.\n\nProcess parameters:\n -\n\nOptions:\n - has exactly one child\n - requires parent scheduler\n\nReference:\n - Strosnider, Jay K., John P. Lehoczky, and Lui Sha (1995).\n   \"The Deferrable Server Algorithm for Enhanced Aperiodic Responsiveness in Hard Real-Time Environments\"\n   IEEE Transactions on Computers 44.1 (1995): 73-91.\n", new Parameter[]{Parameter.CAPACITY, Parameter.PERIOD}, new Parameter[0], true, false, true),
        POLLING_SERVER("PollingServer", "Polling Server (PS): provides a fixed budget periodically that is only\navailable at pre-defined times. If the process is not using the budget\nat that point in time the budget is lost.\n\nAlgorithm parameters:\n - capacity [1] Time\n      The fixed budget that can be used by processes (usually directly\n      after it has been replenished). The capacity will be consumed even\n      if there is no process using it. It will be replenished periodically.\n - period [1] Time\n      Amount of time after which the capacity will be replenished.\n\nProcess parameters:\n -\n\nOptions:\n - has exactly one child\n - requires parent scheduler\n\nReference:\n - Buttazzo, Giorgio (2004).\n   \"Real-Time Computing Systems - Predictable Scheduling Algorithms and Applications\"\n   Springer Publications, Chapter 5, DOI:10.1007/0-387-27578-9\n", new Parameter[]{Parameter.CAPACITY, Parameter.PERIOD}, new Parameter[0], true, false, true),
        SPORADIC_SERVER("SporadicServer", "Sporadic Server (SS): provides a fixed budget, in which the budget replenishment\nis performed with a pre-defined replenishment delay after it was consumed.\n\nAlgorithm parameters:\n - capacity [1] Time\n      The fixed budget that can be used by processes. It will be replenished after\n      the specified amount of time has passed since it has last been consumed.\n - replenishmentDelay [1] Time\n      Amount of time after which the capacity will be replenished\n      after it has last been consumed.\n\nProcess parameters:\n -\n\nOptions:\n - has exactly one child\n - requires parent scheduler\n\nReference:\n - Sprunt, Brinkley, Lui Sha, and John Lehoczky (1989).\n   \"Aperiodic Task Scheduling for Hard Real-Time Systems\"\n   Real-Time Systems 1(1):27-60, DOI:10.1007/BF02341920\n", new Parameter[]{Parameter.CAPACITY, Parameter.REPLENISHMENT_DELAY}, new Parameter[0], true, false, true),
        CONSTANT_BANDWIDTH_SERVER("ConstantBandwidthServer", "Constant Bandwidth Server (CBS): provides a fixed utilization for\nexecuting jobs, in which the deadline for execution is independent\non the execution time of jobs.\n\nAlgorithm parameters:\n - capacity [1] Time\n      The fixed budget that can be used by processes.\n      It will be replenished periodically.\n - period [1] Time\n      Amount of time after which the capacity will be replenished.\n\nProcess parameters:\n -\n\nOptions:\n - has exactly one child\n - requires parent scheduler\n\nReference:\n - Abeni, Luca, and Giorgio Buttazzo (1998).\n   \"Integrating Multimedia Applications in Hard Real-Time Systems\"\n   Proceedings 19th IEEE Real-Time Systems Symposium (Cat. No. 98CB36279). IEEE, 1998.\n", new Parameter[]{Parameter.CAPACITY, Parameter.PERIOD}, new Parameter[0], true, false, true),
        CONSTANT_BANDWIDTH_SERVER_WITH_CAPACITY_SHARING("ConstantBandwidthServerWithCapacitySharing", "Constant Bandwidth Server (CBS) with capacity sharing (CASH).\nConsumes residual slack from other servers (work conserving).\n\nAlgorithm parameters:\n - capacity [1] Time\n      The fixed budget that can be used by processes.\n      It will be replenished periodically.\n - period [1] Time\n      Amount of time after which the capacity will be replenished.\n\nProcess parameters:\n -\n\nOptions:\n - has exactly one child\n - requires parent scheduler\n\nReference:\n - M. Caccamo, G. Buttazzo and Lui Sha (2000).\n   \"Capacity sharing for overrun control\"\n   Proceedings 21st IEEE Real-Time Systems Symposium, 2000, pp. 295-304, doi: 10.1109/REAL.2000.896018.\n", new Parameter[]{Parameter.CAPACITY, Parameter.PERIOD}, new Parameter[0], true, false, true);

        private final String algorithmName;
        private final String description;
        private final List<Parameter> algorithmParameters;
        private final List<Parameter> processParameters;
        private final boolean hasExactlyOneChild;
        private final boolean passesParametersUpwards;
        private final boolean requiresParentScheduler;

        private Algorithm(String algorithmName, String description, Parameter[] algorithmParameters, Parameter[] processParameters, boolean hasExactlyOneChild, boolean passesParametersUpwards, boolean requiresParentScheduler) {
            this.algorithmName = algorithmName;
            this.description = description;
            this.algorithmParameters = Arrays.asList(algorithmParameters);
            this.processParameters = Arrays.asList(processParameters);
            this.hasExactlyOneChild = hasExactlyOneChild;
            this.passesParametersUpwards = passesParametersUpwards;
            this.requiresParentScheduler = requiresParentScheduler;
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        public String getDescription() {
            return this.description;
        }

        public List<Parameter> getAlgorithmParameters() {
            return this.algorithmParameters;
        }

        public List<String> getAlgorithmParameterNames() {
            return this.algorithmParameters.stream().map(Parameter::getParameterName).collect(Collectors.toList());
        }

        public List<Parameter> getProcessParameters() {
            return this.processParameters;
        }

        public List<String> getProcessParameterNames() {
            return this.processParameters.stream().map(Parameter::getParameterName).collect(Collectors.toList());
        }

        public boolean hasExactlyOneChild() {
            return this.hasExactlyOneChild;
        }

        public boolean passesParametersUpwards() {
            return this.passesParametersUpwards;
        }

        public boolean requiresParentScheduler() {
            return this.requiresParentScheduler;
        }
    }

    public static enum Parameter {
        PRIORITY("priority", Type.INTEGER, false, true),
        TASK_GROUP("taskGroup", Type.INTEGER, false, true),
        MIN_BUDGET("minBudget", Type.TIME, false, true),
        MAX_BUDGET("maxBudget", Type.TIME, false, true),
        REPLENISHMENT("replenishment", Type.TIME, false, true),
        DEADLINE("deadline", Type.TIME, false, true),
        PERIOD("period", Type.TIME, false, true),
        EXECUTION_TIME("executionTime", Type.TIME, false, true),
        QUANT_SIZE("quantSize", Type.TIME, false, false, "1 ns"),
        TIME_SLICE_LENGTH("timeSliceLength", Type.TIME, false, true),
        CAPACITY("capacity", Type.TIME, false, true),
        REPLENISHMENT_DELAY("replenishmentDelay", Type.TIME, false, true);

        private final String parameterName;
        private final Type type;
        private final boolean many;
        private final boolean mandatory;
        private final String defaultValue;

        private Parameter(String parameterName, Type type, boolean many, boolean mandatory) {
            this(parameterName, type, many, mandatory, null);
        }

        private Parameter(String parameterName, Type type, boolean many, boolean mandatory, String defaultValue) {
            this.parameterName = parameterName;
            this.type = type;
            this.many = many;
            this.mandatory = mandatory;
            this.defaultValue = defaultValue;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isMany() {
            return this.many;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static enum Type {
        INTEGER("Integer"),
        FLOAT("Float"),
        BOOL("Bool"),
        TIME("Time"),
        STRING("String");

        private final String typeName;

        private Type(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

