/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.tracing.converter.atdb.model;

import org.eclipse.app4mc.tracing.converter.ot1.OT1.EventTypeEnum;

public enum EventType {
    ACTIVATE,
    START,
    SUSPEND,
    TERMINATE,
    RESUME,
    PREEMPT,
    WAIT,
    RELEASE,
    RELEASE_PARKING,
    PARK,
    POLL_PARKING,
    POLL,
    RUN,
    READ,
    WRITE;


    public static EventType getEventTypeForOT1(EventTypeEnum ot1EventType) {
        switch (ot1EventType) {
            case SCHED_START: 
            case RUNNABLE_START: 
            case FUNCTION_START: {
                return START;
            }
            case RUNNABLE_STOP: 
            case FUNCTION_STOP: {
                return SUSPEND;
            }
            case CODEBLOCK_START: 
            case CODEBLOCK_STOP: 
            case PDU_RECEIVE: 
            case SIG_RECEIVE: 
            case FRAME_RECEIVE: 
            case MSG_RECEIVE: {
                return READ;
            }
            case PDU_TRANSMIT: 
            case SIG_TRANSMIT: 
            case FRAME_TRANSMIT: 
            case MSG_TRANSMIT: {
                return WRITE;
            }
            case SCHED_ACTIVATION: {
                return ACTIVATE;
            }
            case SCHED_PREEMPT: {
                return PREEMPT;
            }
            case SCHED_RELEASE: {
                return RELEASE;
            }
            case SCHED_RESUME: {
                return RESUME;
            }
            case SCHED_STOP: 
            case SCHED_TERMINATE: {
                return TERMINATE;
            }
            case SCHED_WAIT: {
                return WAIT;
            }
        }
        return null;
    }
}

