/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.app4mc.atdb._import.btf.ImportTransformation;
import org.eclipse.app4mc.atdb._import.btf.wizard.ImportPage;
import org.eclipse.app4mc.atdb._import.btf.wizard.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.FrameworkUtil;

public class ImportWizard
extends Wizard
implements IImportWizard {
    private ImportPage mainPage;
    private IStructuredSelection selection;

    public void addPages() {
        super.addPages();
        this.mainPage = new ImportPage(this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)selection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        this.setWindowTitle(Messages.ImportWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        final String source = this.mainPage.getSource();
        final IContainer target = this.mainPage.getTargetContainer();
        int from = Math.max(source.lastIndexOf(47), source.lastIndexOf(92));
        int to = source.lastIndexOf(".btf");
        String name = source.substring(from + 1, to);
        final String atdbFile = target.getLocation() + "/" + name + ".atdb";
        final boolean calculateMetrics = this.mainPage.isCalculateMetrics();
        final boolean persistTraceEvents = this.mainPage.isPersistTraceEvents();
        final boolean doInMemoryDBImport = this.mainPage.isDoInMemoryDBImport();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException, CoreException {
                ImportTransformation transformer = new ImportTransformation(source, atdbFile, calculateMetrics, persistTraceEvents, doInMemoryDBImport);
                transformer.run(progressMonitor);
                target.refreshLocal(1, progressMonitor);
                progressMonitor.done();
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e1) {
            Platform.getLog(((Object)((Object)this)).getClass()).log((IStatus)new Status(4, FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName(), e1.getLocalizedMessage(), (Throwable)e1));
            return false;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        IProject project = target.getProject();
        IFile file = project.getFile(atdbFile.substring(atdbFile.lastIndexOf(47) + 1));
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file);
        }
        catch (PartInitException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).log((IStatus)new Status(4, FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName(), e.getLocalizedMessage(), (Throwable)e));
            return false;
        }
        return true;
    }
}

