/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.workflow.mwe2.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.emf.AmaltheaResourceFactory;
import org.eclipse.app4mc.amalthea.workflow.mwe2.AmaltheaWorkflow;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class AmaltheaWriter
extends AmaltheaWorkflow {
    private boolean singleFile = true;
    private String outputDir;
    private String fileName;
    private static final String fileType = "amxmi";
    private final Map<String, EObject> cache = new HashMap<String, EObject>();
    private final Map<URI, Resource> cache2 = new HashMap<URI, Resource>();

    public AmaltheaWriter() {
        this.log = Logger.getLogger((String)"AmaltheaWriter");
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.log.info((Object)"Starting...");
        try {
            if (this.isSingleFile()) {
                ArrayList<EObject> tmp = new ArrayList<EObject>();
                tmp.add((EObject)this.getAmaltheaModelCopy(ctx));
                this.saveModelFile(null, tmp);
            } else {
                ArrayList<EObject> tmp = new ArrayList<EObject>();
                Amalthea model = this.getAmaltheaModelCopy(ctx);
                if (model.getCommonElements() != null) {
                    tmp.add((EObject)model.getCommonElements());
                    this.saveModelFile("-common", tmp);
                }
                if (model.getHwModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getHwModel());
                    this.saveModelFile("-hw", tmp);
                }
                if (model.getOsModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getOsModel());
                    this.saveModelFile("-os", tmp);
                }
                if (model.getStimuliModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getStimuliModel());
                    this.saveModelFile("-stimuli", tmp);
                }
                if (model.getSwModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getSwModel());
                    this.saveModelFile("-sw", tmp);
                }
                if (model.getEventModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getEventModel());
                    this.saveModelFile("-events", tmp);
                }
                if (model.getPropertyConstraintsModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getPropertyConstraintsModel());
                    this.saveModelFile("-pc", tmp);
                }
                if (model.getConstraintsModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getConstraintsModel());
                    this.saveModelFile("-constraints", tmp);
                }
                if (model.getMappingModel() != null) {
                    tmp.clear();
                    tmp.add((EObject)model.getMappingModel());
                    this.saveModelFile("-mapping", tmp);
                }
                tmp.clear();
            }
        }
        catch (IOException e) {
            this.log.error((Object)"An error occured by writing the model!", (Throwable)e);
        }
        this.log.info((Object)"Finished");
    }

    public void checkConfiguration(Issues issues) {
        if (this.getOutputDir() == null || this.getOutputDir().isEmpty()) {
            issues.addError((WorkflowComponent)this, "No output directory defined!");
        }
        if (this.getFileName() == null || this.getFileName().isEmpty()) {
            issues.addError((WorkflowComponent)this, "No filename defined!");
        }
        super.checkConfiguration(issues);
    }

    private void saveModelFile(String filenameType, List<EObject> content) throws IOException {
        if (content != null && !content.isEmpty()) {
            String outputFilePath = this.getOutputDir();
            if (!outputFilePath.endsWith("/")) {
                outputFilePath = outputFilePath.concat("/");
            }
            outputFilePath = filenameType == null ? outputFilePath.concat(this.getFileName()).concat(".").concat(this.getFileType()) : outputFilePath.concat(this.getFileName()).concat(filenameType).concat(".").concat(this.getFileType());
            this.log.info((Object)("Writing file " + outputFilePath));
            URI tmpUri = URI.createURI((String)outputFilePath);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileType, new AmaltheaResourceFactory());
            resourceSet.setURIResourceMap(this.cache2);
            Resource outResource = resourceSet.createResource(tmpUri);
            ((ResourceImpl)outResource).setIntrinsicIDToEObjectMap(this.cache);
            outResource.getContents().addAll(content);
            outResource.save(null);
        }
    }

    public boolean isSingleFile() {
        return this.singleFile;
    }

    public void setSingleFile(boolean singleFile) {
        this.singleFile = singleFile;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileType() {
        return fileType;
    }
}

