/*********************************************************************************
 * Copyright (c) 2021 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */ 

package org.eclipse.app4mc.amalthea.model.editor.contribution.handler;

import javax.annotation.PostConstruct;
import javax.inject.Named;

import org.eclipse.app4mc.amalthea.model.editor.contribution.registry.CreationServiceRegistry;
import org.eclipse.app4mc.amalthea.model.editor.contribution.registry.RegistryServiceWrapper;
import org.eclipse.app4mc.amalthea.model.editor.contribution.service.CreationService;
import org.eclipse.app4mc.amalthea.model.provider.TransientItemProvider;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.viewers.IStructuredSelection;

@SuppressWarnings("restriction")
public class CreateModelStructureHandler {

	@Execute
	public void execute(
			@Named("app4mc.creator.model") String modelType,
			@Named("app4mc.creator.id") String creatorId,
			@Named(IServiceConstants.ACTIVE_SELECTION) IStructuredSelection selection,
			@Service CreationServiceRegistry registry,
			IEclipseContext context) {

		RegistryServiceWrapper<CreationService> creation = registry.getService(modelType, creatorId);

		if (creation != null) {

			// in case of TransientItemProvider: replace with target object
			Object modelElement = selection.getFirstElement();
			if (modelElement instanceof TransientItemProvider) {
				modelElement = ((TransientItemProvider) modelElement).getTarget();
			}

			IEclipseContext activeContext = context.createChild(modelType + " CreateModelStructure");
			activeContext.set(creation.getType(), modelElement);

			try {
				ContextInjectionFactory.invoke(creation.getServiceInstance(), PostConstruct.class, activeContext);
			} finally {
				// dispose the context after the execution to avoid memory leaks
				activeContext.dispose();
			}
		}
	}

}
