/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.eclipse.app4mc.atdb.ATDBBuilder;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.DBConnection;
import org.eclipse.app4mc.atdb._import.btf.ATDBMetricCalculator;
import org.eclipse.app4mc.atdb._import.btf.BTFImporter;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ImportTransformation
implements IRunnableWithProgress {
    private final String btfFile;
    private final String atdbFile;
    private final boolean persistTraceEvents;

    public ImportTransformation(String source, String target, boolean persistTraceEvents) {
        if (source.endsWith(".btf") && target.endsWith(".atdb")) {
            this.btfFile = source;
            this.atdbFile = target;
        } else {
            this.btfFile = "";
            this.atdbFile = "";
        }
        this.persistTraceEvents = persistTraceEvents;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        if (!this.btfFile.isEmpty() && !this.atdbFile.isEmpty()) {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Converting BTF trace to ATDB...", (int)100);
            try {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (ATDBConnection con = new ATDBConnection(this.atdbFile, true);){
                        SubMonitor createATDBMonitor = subMon.split(1);
                        createATDBMonitor.beginTask("Creating empty ATDB...", 1);
                        ATDBBuilder atdbBuilder = new ATDBBuilder((DBConnection)con).createBasicDBStructure().createBasicViews().createOptionalAndTemporaryTables(BTFEntityType.literals, this.persistTraceEvents);
                        if (this.persistTraceEvents) {
                            atdbBuilder.createOptionalViews(BTFEntityType.literals);
                        }
                        createATDBMonitor.done();
                        SubMonitor btfImportMonitor = subMon.split(69);
                        BTFImporter btfImporter = new BTFImporter(con, this.btfFile);
                        btfImporter.run((IProgressMonitor)btfImportMonitor);
                        btfImportMonitor.done();
                        SubMonitor metricCalcMonitor = subMon.split(30);
                        atdbBuilder.autoPopulateEntityFilteredTraceEventTables(BTFEntityType.literals);
                        ATDBMetricCalculator metricCalc = new ATDBMetricCalculator(con);
                        metricCalc.run((IProgressMonitor)metricCalcMonitor);
                        metricCalcMonitor.done();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                progressMonitor.done();
            }
        }
    }
}

