/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.amalthea;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.io.AmaltheaLoader;
import org.eclipse.app4mc.atdb.ATDBBuilder;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.DBConnection;
import org.eclipse.app4mc.atdb._import.amalthea.EventChainImporter;
import org.eclipse.app4mc.atdb._import.amalthea.EventChainMetricCalculator;
import org.eclipse.app4mc.atdb._import.amalthea.EventImporter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ImportTransformation
implements IRunnableWithProgress {
    private final String amxmiSource;
    private final String atdbSource;
    private final String atdbFile;
    private final boolean copySource;

    public ImportTransformation(String amxmiSource, String atdbSource, String atdbFile, boolean copySource) {
        this.amxmiSource = amxmiSource;
        this.atdbSource = atdbSource;
        this.atdbFile = atdbFile;
        this.copySource = copySource;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        if (this.amxmiSource.isEmpty() || this.atdbFile.isEmpty()) {
            return;
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Inserting AMALTHEA model specification parts to ATDB...", (int)4);
        if (this.copySource && !this.atdbSource.isEmpty() && !this.atdbSource.equals(this.atdbFile)) {
            try {
                Files.copy((File)new File(this.atdbSource), (File)new File(this.atdbFile));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        SubMonitor openAMXMI_ATDBMonitor = subMon.split(1);
        openAMXMI_ATDBMonitor.beginTask("Opening AMXMI and ATDB files...", 1);
        try {
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (ATDBConnection con = new ATDBConnection(this.atdbFile, true);){
                    Amalthea model = AmaltheaLoader.loadFromFileNamed((String)this.amxmiSource);
                    new ATDBBuilder((DBConnection)con).createBasicDBStructure().createBasicViews();
                    SubMonitor eventImportMonitor = subMon.split(1);
                    EventImporter eventImporter = new EventImporter(con, model);
                    eventImporter.run((IProgressMonitor)eventImportMonitor);
                    SubMonitor ecImportMonitor = subMon.split(1);
                    EventChainImporter ecImporter = new EventChainImporter(con, model);
                    ecImporter.run((IProgressMonitor)ecImportMonitor);
                    SubMonitor ecInstMetricMonitor = subMon.split(1);
                    if (con.tableExists("traceEvent")) {
                        EventChainMetricCalculator ecmc = new EventChainMetricCalculator(con);
                        ecmc.run((IProgressMonitor)ecInstMetricMonitor);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

