/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.emf;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.app4mc.amalthea.model.emf.AmaltheaResource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class AmaltheaResourceFactory
extends XMIResourceFactoryImpl {
    private boolean isInvokedProgrammatically = false;

    public AmaltheaResourceFactory() {
    }

    public AmaltheaResourceFactory(boolean isInvokedProgrammatically) {
        this.isInvokedProgrammatically = isInvokedProgrammatically;
    }

    public Resource createResource(URI uri) {
        if (this.canLoadAmaltheaModel(uri)) {
            return new AmaltheaResource(uri);
        }
        return null;
    }

    private boolean canLoadAmaltheaModel(URI uri) {
        String scheme;
        IWorkspaceRoot root;
        if (!Platform.isRunning() || this.isInvokedProgrammatically) {
            return true;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null && (root = workspace.getRoot()) != null && (scheme = uri.scheme()) != null) {
            int segmentCount = uri.segmentCount();
            if (scheme.equals("platform") && segmentCount > 1 && uri.segment(0).equals("resource")) {
                String resourcePathString;
                StringBuilder resourcePath = new StringBuilder();
                int segmentNumber = 1;
                int size = uri.segmentCount();
                while (segmentNumber < size) {
                    resourcePath.append(String.valueOf('/') + uri.segment(segmentNumber));
                    ++segmentNumber;
                }
                String decoded = resourcePathString = resourcePath.toString();
                try {
                    decoded = URLDecoder.decode(resourcePathString, StandardCharsets.UTF_8.toString());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println("Decoding URI failed");
                }
                IFile iFile = root.getFile((IPath)new Path(decoded));
                IProject project = iFile.getProject();
                try {
                    if (project.getNature("amlt.no.load.nature") != null) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public boolean isInvokedExplicitly() {
        return this.isInvokedProgrammatically;
    }

    public void setInvokedExplicitly(boolean isInvokedExplicitly) {
        this.isInvokedProgrammatically = isInvokedExplicitly;
    }
}

