/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.log4j.configuration;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class EclipseLogAppender
extends AppenderSkeleton {
    private int getStatus(LoggingEvent event) {
        Level level = event.getLevel();
        int status = 1;
        if (level == Level.ERROR) {
            status = 4;
        } else if (level == Level.INFO) {
            status = 1;
        } else if (level == Level.WARN) {
            status = 2;
        } else if (level == Level.FATAL) {
            status = 4;
        }
        return status;
    }

    protected void append(LoggingEvent event) {
        Object messageObject = event.getMessage();
        ThrowableInformation throwableInformation = event.getThrowableInformation();
        int status = this.getStatus(event);
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        if (bundle != null) {
            if (throwableInformation != null) {
                Platform.getLog((Bundle)bundle).log((IStatus)new Status(status, bundle.getSymbolicName(), messageObject != null ? messageObject.toString() : "", throwableInformation.getThrowable()));
            } else {
                Platform.getLog((Bundle)bundle).log((IStatus)new Status(status, bundle.getSymbolicName(), messageObject != null ? messageObject.toString() : ""));
            }
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

