/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters096.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.9.5", "output_model_version=0.9.6"}, service={IConverter.class})
public class ConstraintsConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstraintsConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File file, Map<File, Document> map, List<ICache> caches) {
        LOGGER.info("Migration from 0.9.5 to 0.9.6 : Executing Constraints converter for model file : {}", (Object)file.getName());
        this.basicConvert(file, map);
    }

    public void basicConvert(File file, Map<File, Document> map) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateEventChains(rootElement);
    }

    private void updateEventChains(Element rootElement) {
        String xpath = "./constraintsModel/eventChains";
        List eventChains = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/eventChains", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        boolean hasSegments = false;
        for (Element element : eventChains) {
            hasSegments = false;
            ArrayList<Element> segments = new ArrayList<Element>(element.getChildren("segments"));
            if (!segments.isEmpty()) {
                this.convertToItems(segments, element, "sequence");
                hasSegments = true;
            }
            ArrayList<Element> strands = new ArrayList<Element>(element.getChildren("strands"));
            if (hasSegments && !strands.isEmpty()) {
                LOGGER.info("EventChains Migration from 0.9.5 to 0.9.6 : Removing strands because Segments are already migrated and both cannot exist at a time in 0.9.6.");
                for (Element strand : strands) {
                    strand.detach();
                }
                continue;
            }
            if (strands.isEmpty()) continue;
            this.convertToItems(strands, element, "parallel");
        }
    }

    private void convertToItems(List<Element> segments, Element eventChain, String itemType) {
        Attribute itemTypeAttr = new Attribute("itemType", itemType);
        eventChain.setAttribute(itemTypeAttr);
        for (Element element : segments) {
            element.setName("items");
            if (!element.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")).equals("am:EventChainContainer")) continue;
            Element subevent = element.getChild("eventChain");
            subevent.setAttribute("minItemsCompleted", "1");
            eventChain.setAttribute("minItemsCompleted", "1");
        }
    }
}

