/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.BooleanObject;
import org.eclipse.app4mc.amalthea.model.IAnnotatable;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.IntegerObject;
import org.eclipse.app4mc.amalthea.model.ListObject;
import org.eclipse.app4mc.amalthea.model.MapObject;
import org.eclipse.app4mc.amalthea.model.ReferenceObject;
import org.eclipse.app4mc.amalthea.model.StringObject;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.jdt.annotation.NonNull;

public final class CustomPropertyUtil {
    private static final String ARG1_MESSAGE = "First argument is null, expected instance of IAnnotatable";
    private static final String ARG2_MESSAGE = "Key is null or empty, expected non empty String";

    private CustomPropertyUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, boolean bool) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        BooleanObject valueObject = FactoryUtil.createBooleanObject(bool);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, int num) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        IntegerObject valueObject = FactoryUtil.createIntegerObject(num);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, String str) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        StringObject valueObject = FactoryUtil.createStringObject(str);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, Time time) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Time valueObject = FactoryUtil.createTime(time);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, IReferable reference) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        ReferenceObject valueObject = FactoryUtil.createReferenceObject(reference);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean customGetBoolean(@NonNull IAnnotatable object, @NonNull String firstKey, String ... nextKeys) {
        Value valueObject;
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstKey) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value value = valueObject = CustomPropertyUtil.customGetValue(object, firstKey, nextKeys);
        if (value instanceof BooleanObject) {
            void boolObj;
            BooleanObject booleanObject = (BooleanObject)value;
            BooleanObject cfr_ignored_0 = (BooleanObject)value;
            return boolObj.isValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Integer customGetInteger(@NonNull IAnnotatable object, @NonNull String firstKey, String ... nextKeys) {
        Value valueObject;
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstKey) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value value = valueObject = CustomPropertyUtil.customGetValue(object, firstKey, nextKeys);
        if (value instanceof IntegerObject) {
            void intObj;
            IntegerObject integerObject = (IntegerObject)value;
            IntegerObject cfr_ignored_0 = (IntegerObject)value;
            return intObj.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String customGetString(@NonNull IAnnotatable object, @NonNull String firstKey, String ... nextKeys) {
        Value valueObject;
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstKey) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value value = valueObject = CustomPropertyUtil.customGetValue(object, firstKey, nextKeys);
        if (value instanceof StringObject) {
            void strObj;
            StringObject stringObject = (StringObject)value;
            StringObject cfr_ignored_0 = (StringObject)value;
            return strObj.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Time customGetTime(@NonNull IAnnotatable object, @NonNull String firstKey, String ... nextKeys) {
        Value valueObject;
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstKey) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value value = valueObject = CustomPropertyUtil.customGetValue(object, firstKey, nextKeys);
        if (value instanceof Time) {
            void time;
            Time time2 = (Time)value;
            Time cfr_ignored_0 = (Time)value;
            return FactoryUtil.createTime((Time)time);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static IReferable customGetReference(@NonNull IAnnotatable object, @NonNull String firstKey, String ... nextKeys) {
        Value valueObject;
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstKey) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value value = valueObject = CustomPropertyUtil.customGetValue(object, firstKey, nextKeys);
        if (value instanceof ReferenceObject) {
            void refObj;
            ReferenceObject referenceObject = (ReferenceObject)value;
            ReferenceObject cfr_ignored_0 = (ReferenceObject)value;
            return refObj.getValue();
        }
        return null;
    }

    public static Value customGetValue(@NonNull IAnnotatable object, @NonNull String key, char separator) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        List keys = Splitter.on((char)separator).splitToList((CharSequence)key);
        String firstKey = (String)keys.get(0);
        if (firstKey == null || firstKey.isEmpty()) {
            return null;
        }
        String[] nextKeys = keys.size() < 2 ? new String[]{} : keys.subList(1, keys.size()).toArray(new String[0]);
        return CustomPropertyUtil.customGetValue(object, firstKey, nextKeys);
    }

    /*
     * Unable to fully structure code
     */
    public static Value customGetValue(@NonNull IAnnotatable object, @NonNull String firstKey, String ... nextKeys) {
        Preconditions.checkArgument((boolean)(object != null), (Object)"First argument is null, expected instance of IAnnotatable");
        Preconditions.checkArgument((boolean)(Strings.isNullOrEmpty((String)firstKey) == false), (Object)"Key is null or empty, expected non empty String");
        valueObject = (Value)object.getCustomProperties().get((Object)firstKey);
        var7_4 = nextKeys;
        var6_5 = nextKeys.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block4: {
                block3: {
                    key = var7_4[var5_6];
                    if (valueObject == null) break;
                    var10_9 = valueObject;
                    if (!(var10_9 instanceof MapObject)) break block3;
                    (MapObject)var10_9;
                    (MapObject)var10_9;
                    if (Strings.isNullOrEmpty((String)key)) break block3;
                    valueObject = (Value)mapObj.getEntries().get((Object)key);
                    break block4;
                }
                if (!((var13_11 = valueObject) instanceof ListObject)) ** GOTO lbl-1000
                (ListObject)var13_11;
                (ListObject)var13_11;
                if (CustomPropertyUtil.isIndex(key)) {
                    index = Integer.parseInt(key);
                    valueObject = index < (list = listObj.getValues()).size() ? (Value)list.get(index) : null;
                } else lbl-1000:
                // 2 sources

                {
                    valueObject = null;
                }
            }
            ++var5_6;
        }
        return valueObject;
    }

    private static boolean isIndex(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        int i = 0;
        while (i < len) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

