/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.os;

import java.util.List;
import java.util.Objects;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.SchedulingParameterDefinition;
import org.eclipse.app4mc.amalthea.model.predefined.AmaltheaTemplates;
import org.eclipse.app4mc.amalthea.model.predefined.StandardSchedulers;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-OS-Standard-Scheduling-Parameter-Definition-Conformance", checks={"Scheduling parameter definition that are used in a standard scheduler should conform to the parameters defined by the APP4MC standard scheduler library"})
public class AmOSStandardSchedulingParameterDefinitionConformance
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getSchedulingParameterDefinition();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject object, List<ValidationDiagnostic> results) {
        EObject eObject = object;
        if (eObject instanceof SchedulingParameterDefinition) {
            void candidateSPD;
            SchedulingParameterDefinition schedulingParameterDefinition = (SchedulingParameterDefinition)eObject;
            SchedulingParameterDefinition cfr_ignored_0 = (SchedulingParameterDefinition)eObject;
            OSModel dummyOSModel = AmaltheaFactory.eINSTANCE.createOSModel();
            candidateSPD.getSchedulerDefinitions().stream().flatMap(sd -> StandardSchedulers.getAllParametersOfAlgorithm((String)sd.getName()).stream()).filter(Objects::nonNull).distinct().filter(arg_0 -> AmOSStandardSchedulingParameterDefinitionConformance.lambda$2((SchedulingParameterDefinition)candidateSPD, arg_0)).findFirst().map(spd -> AmaltheaTemplates.addStandardSchedulingParameterDefinition((OSModel)dummyOSModel, (StandardSchedulers.Parameter)spd)).ifPresent(arg_0 -> this.lambda$4((SchedulingParameterDefinition)candidateSPD, results, arg_0));
        }
    }

    private static /* synthetic */ boolean lambda$2(SchedulingParameterDefinition schedulingParameterDefinition, StandardSchedulers.Parameter spd) {
        return spd.getParameterName().equals(schedulingParameterDefinition.getName());
    }

    private /* synthetic */ void lambda$4(SchedulingParameterDefinition schedulingParameterDefinition, List list, SchedulingParameterDefinition standardSPD) {
        ePackage.getSchedulingParameterDefinition().getEAttributes().forEach(spdAttribute -> {
            Object candidateValue;
            Object standardValue = standardSPD.eGet((EStructuralFeature)spdAttribute);
            if (!standardValue.equals(candidateValue = schedulingParameterDefinition.eGet((EStructuralFeature)spdAttribute))) {
                this.addIssue(list, (EObject)schedulingParameterDefinition, (EStructuralFeature)spdAttribute, "Standard scheduling parameter definition \"" + standardSPD.getName() + "\" expects " + spdAttribute.getName() + " set to '" + standardValue + "', but found '" + candidateValue + "' in " + this.objectInfo((EObject)schedulingParameterDefinition));
            }
        });
        if (!schedulingParameterDefinition.isMandatory() && schedulingParameterDefinition.getDefaultValue() == null && standardSPD.getDefaultValue() != null) {
            this.addIssue(list, (EObject)schedulingParameterDefinition, (EStructuralFeature)ePackage.getSchedulingParameterDefinition_DefaultValue(), "Standard scheduling parameter definition \"" + standardSPD.getName() + "\" defines a default value, which should also be provided here, " + "since " + this.objectInfo((EObject)schedulingParameterDefinition) + " is optional");
        }
    }
}

